// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_UI_Composition_H
#define WINRT_Windows_UI_Composition_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.UI.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Graphics.2.h"
#include "winrt/impl/Windows.Graphics.DirectX.2.h"
#include "winrt/impl/Windows.Graphics.Effects.2.h"
#include "winrt/impl/Windows.System.2.h"
#include "winrt/impl/Windows.UI.2.h"
#include "winrt/impl/Windows.UI.Core.2.h"
#include "winrt/impl/Windows.UI.Composition.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_UI_Composition_IAmbientLight<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAmbientLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAmbientLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAmbientLight<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAmbientLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAmbientLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAmbientLight2<D>::Intensity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAmbientLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAmbientLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight2>**)this;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAmbientLight2<D>::Intensity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAmbientLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAmbientLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAmbientLight2>**)this;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::PlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->get_PlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::PlaybackRate(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PlaybackRate(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->put_PlaybackRate(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::Progress() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Progress(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->get_Progress(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::Progress(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Progress(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->put_Progress(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::ProgressBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationControllerProgressBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProgressBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->get_ProgressBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::ProgressBehavior(winrt::Windows::UI::Composition::AnimationControllerProgressBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ProgressBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->put_ProgressBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::Pause() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Pause());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->Pause());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationController<D>::Resume() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Resume());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationController>**)this;
            check_hresult(_winrt_abi_type->Resume());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationControllerStatics<D>::MaxPlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationControllerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationControllerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationControllerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxPlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationControllerStatics>**)this;
            check_hresult(_winrt_abi_type->get_MaxPlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationControllerStatics<D>::MinPlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationControllerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationControllerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationControllerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinPlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationControllerStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinPlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationObject<D>::PopulatePropertyInfo(param::hstring const& propertyName, winrt::Windows::UI::Composition::AnimationPropertyInfo const& propertyInfo) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PopulatePropertyInfo(*(void**)(&propertyName), *(void**)(&propertyInfo)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationObject>**)this;
            check_hresult(_winrt_abi_type->PopulatePropertyInfo(*(void**)(&propertyName), *(void**)(&propertyInfo)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationPropertyInfo<D>::AccessMode() const
    {
        winrt::Windows::UI::Composition::AnimationPropertyAccessMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationPropertyInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccessMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo>**)this;
            check_hresult(_winrt_abi_type->get_AccessMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationPropertyInfo<D>::AccessMode(winrt::Windows::UI::Composition::AnimationPropertyAccessMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationPropertyInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AccessMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo>**)this;
            check_hresult(_winrt_abi_type->put_AccessMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationPropertyInfo2<D>::GetResolvedCompositionObject() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationPropertyInfo2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetResolvedCompositionObject(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo2>**)this;
            check_hresult(_winrt_abi_type->GetResolvedCompositionObject(&result));
        }
        return winrt::Windows::UI::Composition::CompositionObject{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IAnimationPropertyInfo2<D>::GetResolvedCompositionObjectProperty() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IAnimationPropertyInfo2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetResolvedCompositionObjectProperty(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IAnimationPropertyInfo2>**)this;
            check_hresult(_winrt_abi_type->GetResolvedCompositionObjectProperty(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IBackEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBackEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBackEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBackEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBackEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBackEasingFunction<D>::Amplitude() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBackEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBackEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBackEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Amplitude(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBackEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Amplitude(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBooleanKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceEasingFunction<D>::Bounces() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bounces(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Bounces(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceEasingFunction<D>::Bounciness() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bounciness(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Bounciness(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceScalarNaturalMotionAnimation<D>::Acceleration() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceScalarNaturalMotionAnimation<D>::Acceleration(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceScalarNaturalMotionAnimation<D>::Restitution() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceScalarNaturalMotionAnimation<D>::Restitution(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector2NaturalMotionAnimation<D>::Acceleration() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector2NaturalMotionAnimation<D>::Acceleration(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector2NaturalMotionAnimation<D>::Restitution() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector2NaturalMotionAnimation<D>::Restitution(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector3NaturalMotionAnimation<D>::Acceleration() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Acceleration(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector3NaturalMotionAnimation<D>::Acceleration(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Acceleration(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector3NaturalMotionAnimation<D>::Restitution() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Restitution(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IBounceVector3NaturalMotionAnimation<D>::Restitution(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Restitution(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICircleEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICircleEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICircleEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICircleEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICircleEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IColorKeyFrameAnimation<D>::InterpolationColorSpace() const
    {
        winrt::Windows::UI::Composition::CompositionColorSpace value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IColorKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InterpolationColorSpace(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InterpolationColorSpace(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IColorKeyFrameAnimation<D>::InterpolationColorSpace(winrt::Windows::UI::Composition::CompositionColorSpace const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IColorKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InterpolationColorSpace(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InterpolationColorSpace(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IColorKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IColorKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IColorKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::UI::Color const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IColorKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IColorKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::ClearAllParameters() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearAllParameters());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->ClearAllParameters());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::ClearParameter(param::hstring const& key) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearParameter(*(void**)(&key)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->ClearParameter(*(void**)(&key)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetColorParameter(param::hstring const& key, winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetColorParameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetColorParameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetMatrix3x2Parameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetMatrix3x2Parameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetMatrix3x2Parameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetMatrix4x4Parameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::float4x4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetMatrix4x4Parameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetMatrix4x4Parameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetQuaternionParameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::quaternion const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetQuaternionParameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetQuaternionParameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetReferenceParameter(param::hstring const& key, winrt::Windows::UI::Composition::CompositionObject const& compositionObject) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetReferenceParameter(*(void**)(&key), *(void**)(&compositionObject)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetReferenceParameter(*(void**)(&key), *(void**)(&compositionObject)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetScalarParameter(param::hstring const& key, float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetScalarParameter(*(void**)(&key), value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetScalarParameter(*(void**)(&key), value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetVector2Parameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetVector2Parameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetVector2Parameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetVector3Parameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetVector3Parameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetVector3Parameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation<D>::SetVector4Parameter(param::hstring const& key, winrt::Windows::Foundation::Numerics::float4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetVector4Parameter(*(void**)(&key), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation>**)this;
            check_hresult(_winrt_abi_type->SetVector4Parameter(*(void**)(&key), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation2<D>::SetBooleanParameter(param::hstring const& key, bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBooleanParameter(*(void**)(&key), value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)this;
            check_hresult(_winrt_abi_type->SetBooleanParameter(*(void**)(&key), value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation2<D>::Target() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)this;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation2<D>::Target(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation2>**)this;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation3<D>::InitialValueExpressions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialValueExpressions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation3>**)this;
            check_hresult(_winrt_abi_type->get_InitialValueExpressions(&value));
        }
        return winrt::Windows::UI::Composition::InitialValueExpressionCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimation4<D>::SetExpressionReferenceParameter(param::hstring const& parameterName, winrt::Windows::UI::Composition::IAnimationObject const& source) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimation4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimation4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetExpressionReferenceParameter(*(void**)(&parameterName), *(void**)(&source)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimation4>**)this;
            check_hresult(_winrt_abi_type->SetExpressionReferenceParameter(*(void**)(&parameterName), *(void**)(&source)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimationGroup<D>::Count() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimationGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)this;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimationGroup<D>::Add(winrt::Windows::UI::Composition::CompositionAnimation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimationGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Add(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)this;
            check_hresult(_winrt_abi_type->Add(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimationGroup<D>::Remove(winrt::Windows::UI::Composition::CompositionAnimation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimationGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)this;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionAnimationGroup<D>::RemoveAll() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionAnimationGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionAnimationGroup>**)this;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilities<D>::AreEffectsSupported() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AreEffectsSupported(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)this;
            check_hresult(_winrt_abi_type->AreEffectsSupported(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilities<D>::AreEffectsFast() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AreEffectsFast(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)this;
            check_hresult(_winrt_abi_type->AreEffectsFast(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilities<D>::Changed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionCapabilities, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)this;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilities<D>::Changed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionCapabilities, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Changed_revoker>(this, Changed(handler));
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilities<D>::Changed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilities>**)this;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCapabilitiesStatics<D>::GetForCurrentView() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetForCurrentView(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics>**)this;
            check_hresult(_winrt_abi_type->GetForCurrentView(&result));
        }
        return winrt::Windows::UI::Composition::CompositionCapabilities{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::AnchorPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::AnchorPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::RotationAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::RotationAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::RotationAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::RotationAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::Scale(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float3x2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionClip2<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionClip2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionClip2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionClip2>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorBrush<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorBrush>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorBrush<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorBrush>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorGradientStop<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorGradientStop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorGradientStop<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorGradientStop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorGradientStop<D>::Offset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorGradientStop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)this;
            check_hresult(_winrt_abi_type->get_Offset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionColorGradientStop<D>::Offset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionColorGradientStop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionColorGradientStop>**)this;
            check_hresult(_winrt_abi_type->put_Offset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCommitBatch<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCommitBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCommitBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCommitBatch<D>::IsEnded() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCommitBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCommitBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnded(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)this;
            check_hresult(_winrt_abi_type->get_IsEnded(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCommitBatch<D>::Completed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCommitBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCommitBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)this;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCommitBatch<D>::Completed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Completed_revoker>(this, Completed(handler));
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionCommitBatch<D>::Completed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionCommitBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionCommitBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionCommitBatch>**)this;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionContainerShape<D>::Shapes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionContainerShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionContainerShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionContainerShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Shapes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionContainerShape>**)this;
            check_hresult(_winrt_abi_type->get_Shapes(&value));
        }
        return winrt::Windows::UI::Composition::CompositionShapeCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface<D>::AlphaMode() const
    {
        winrt::Windows::Graphics::DirectX::DirectXAlphaMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)this;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface<D>::PixelFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)this;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface<D>::Size() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::SizeInt32() const
    {
        winrt::Windows::Graphics::SizeInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SizeInt32(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->get_SizeInt32(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::Resize(winrt::Windows::Graphics::SizeInt32 const& sizePixels) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Resize(impl::bind_in(sizePixels)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->Resize(impl::bind_in(sizePixels)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::Scroll(winrt::Windows::Graphics::PointInt32 const& offset) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Scroll(impl::bind_in(offset)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->Scroll(impl::bind_in(offset)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::Scroll(winrt::Windows::Graphics::PointInt32 const& offset, winrt::Windows::Graphics::RectInt32 const& scrollRect) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ScrollRect(impl::bind_in(offset), impl::bind_in(scrollRect)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->ScrollRect(impl::bind_in(offset), impl::bind_in(scrollRect)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::ScrollWithClip(winrt::Windows::Graphics::PointInt32 const& offset, winrt::Windows::Graphics::RectInt32 const& clipRect) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ScrollWithClip(impl::bind_in(offset), impl::bind_in(clipRect)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->ScrollWithClip(impl::bind_in(offset), impl::bind_in(clipRect)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionDrawingSurface2<D>::ScrollWithClip(winrt::Windows::Graphics::PointInt32 const& offset, winrt::Windows::Graphics::RectInt32 const& clipRect, winrt::Windows::Graphics::RectInt32 const& scrollRect) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionDrawingSurface2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ScrollRectWithClip(impl::bind_in(offset), impl::bind_in(clipRect), impl::bind_in(scrollRect)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionDrawingSurface2>**)this;
            check_hresult(_winrt_abi_type->ScrollRectWithClip(impl::bind_in(offset), impl::bind_in(clipRect), impl::bind_in(scrollRect)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateCubicBezierEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::Foundation::Numerics::float2 const& controlPoint1, winrt::Windows::Foundation::Numerics::float2 const& controlPoint2) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateCubicBezierEasingFunction(*(void**)(&owner), impl::bind_in(controlPoint1), impl::bind_in(controlPoint2), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateCubicBezierEasingFunction(*(void**)(&owner), impl::bind_in(controlPoint1), impl::bind_in(controlPoint2), &result));
        }
        return winrt::Windows::UI::Composition::CubicBezierEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateLinearEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateLinearEasingFunction(*(void**)(&owner), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateLinearEasingFunction(*(void**)(&owner), &result));
        }
        return winrt::Windows::UI::Composition::LinearEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateStepEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStepEasingFunction(*(void**)(&owner), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateStepEasingFunction(*(void**)(&owner), &result));
        }
        return winrt::Windows::UI::Composition::StepEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateStepEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, int32_t stepCount) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStepEasingFunctionWithStepCount(*(void**)(&owner), stepCount, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateStepEasingFunctionWithStepCount(*(void**)(&owner), stepCount, &result));
        }
        return winrt::Windows::UI::Composition::StepEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateBackEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode, float amplitude) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBackEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), amplitude, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateBackEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), amplitude, &result));
        }
        return winrt::Windows::UI::Composition::BackEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateBounceEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode, int32_t bounces, float bounciness) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBounceEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), bounces, bounciness, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateBounceEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), bounces, bounciness, &result));
        }
        return winrt::Windows::UI::Composition::BounceEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateCircleEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateCircleEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateCircleEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), &result));
        }
        return winrt::Windows::UI::Composition::CircleEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateElasticEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode, int32_t oscillations, float springiness) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateElasticEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), oscillations, springiness, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateElasticEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), oscillations, springiness, &result));
        }
        return winrt::Windows::UI::Composition::ElasticEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateExponentialEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode, float exponent) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateExponentialEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), exponent, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateExponentialEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), exponent, &result));
        }
        return winrt::Windows::UI::Composition::ExponentialEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreatePowerEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode, float power) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePowerEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), power, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreatePowerEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), power, &result));
        }
        return winrt::Windows::UI::Composition::PowerEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEasingFunctionStatics<D>::CreateSineEasingFunction(winrt::Windows::UI::Composition::Compositor const& owner, winrt::Windows::UI::Composition::CompositionEasingFunctionMode const& mode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSineEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>**)this;
            check_hresult(_winrt_abi_type->CreateSineEasingFunction(*(void**)(&owner), static_cast<int32_t>(mode), &result));
        }
        return winrt::Windows::UI::Composition::SineEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectBrush<D>::GetSourceParameter(param::hstring const& name) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetSourceParameter(*(void**)(&name), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectBrush>**)this;
            check_hresult(_winrt_abi_type->GetSourceParameter(*(void**)(&name), &result));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectBrush<D>::SetSourceParameter(param::hstring const& name, winrt::Windows::UI::Composition::CompositionBrush const& source) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetSourceParameter(*(void**)(&name), *(void**)(&source)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectBrush>**)this;
            check_hresult(_winrt_abi_type->SetSourceParameter(*(void**)(&name), *(void**)(&source)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectFactory<D>::CreateBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)this;
            check_hresult(_winrt_abi_type->CreateBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionEffectBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectFactory<D>::ExtendedError() const
    {
        winrt::hresult value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedError(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectFactory<D>::LoadStatus() const
    {
        winrt::Windows::UI::Composition::CompositionEffectFactoryLoadStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LoadStatus(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectFactory>**)this;
            check_hresult(_winrt_abi_type->get_LoadStatus(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectSourceParameter<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectSourceParameter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectSourceParameter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectSourceParameter>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEffectSourceParameterFactory<D>::Create(param::hstring const& name) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&name), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&name), &value));
        }
        return winrt::Windows::UI::Composition::CompositionEffectSourceParameter{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEllipseGeometry<D>::Center() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEllipseGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Center(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Center(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEllipseGeometry<D>::Center(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEllipseGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Center(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Center(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEllipseGeometry<D>::Radius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEllipseGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Radius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Radius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionEllipseGeometry<D>::Radius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionEllipseGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Radius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionEllipseGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Radius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometricClip<D>::Geometry() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometricClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometricClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Geometry(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)this;
            check_hresult(_winrt_abi_type->get_Geometry(&value));
        }
        return winrt::Windows::UI::Composition::CompositionGeometry{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometricClip<D>::Geometry(winrt::Windows::UI::Composition::CompositionGeometry const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometricClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometricClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Geometry(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)this;
            check_hresult(_winrt_abi_type->put_Geometry(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometricClip<D>::ViewBox() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometricClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometricClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ViewBox(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)this;
            check_hresult(_winrt_abi_type->get_ViewBox(&value));
        }
        return winrt::Windows::UI::Composition::CompositionViewBox{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometricClip<D>::ViewBox(winrt::Windows::UI::Composition::CompositionViewBox const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometricClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometricClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ViewBox(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometricClip>**)this;
            check_hresult(_winrt_abi_type->put_ViewBox(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimEnd() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TrimEnd(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->get_TrimEnd(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimEnd(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TrimEnd(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->put_TrimEnd(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimOffset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TrimOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->get_TrimOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimOffset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TrimOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->put_TrimOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimStart() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TrimStart(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->get_TrimStart(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGeometry<D>::TrimStart(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TrimStart(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGeometry>**)this;
            check_hresult(_winrt_abi_type->put_TrimStart(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::AnchorPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::AnchorPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::ColorStops() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ColorStops(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_ColorStops(&value));
        }
        return winrt::Windows::UI::Composition::CompositionColorGradientStopCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::ExtendMode() const
    {
        winrt::Windows::UI::Composition::CompositionGradientExtendMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_ExtendMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::ExtendMode(winrt::Windows::UI::Composition::CompositionGradientExtendMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ExtendMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_ExtendMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::InterpolationSpace() const
    {
        winrt::Windows::UI::Composition::CompositionColorSpace value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InterpolationSpace(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_InterpolationSpace(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::InterpolationSpace(winrt::Windows::UI::Composition::CompositionColorSpace const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InterpolationSpace(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_InterpolationSpace(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::RotationAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::RotationAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::RotationAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::RotationAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::Scale(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float3x2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush2<D>::MappingMode() const
    {
        winrt::Windows::UI::Composition::CompositionMappingMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MappingMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush2>**)this;
            check_hresult(_winrt_abi_type->get_MappingMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGradientBrush2<D>::MappingMode(winrt::Windows::UI::Composition::CompositionMappingMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGradientBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGradientBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MappingMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGradientBrush2>**)this;
            check_hresult(_winrt_abi_type->put_MappingMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice<D>::CreateDrawingSurface(winrt::Windows::Foundation::Size const& sizePixels, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat, winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& alphaMode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDrawingSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)this;
            check_hresult(_winrt_abi_type->CreateDrawingSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        return winrt::Windows::UI::Composition::CompositionDrawingSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice<D>::RenderingDeviceReplaced(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionGraphicsDevice, winrt::Windows::UI::Composition::RenderingDeviceReplacedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_RenderingDeviceReplaced(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)this;
            check_hresult(_winrt_abi_type->add_RenderingDeviceReplaced(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice<D>::RenderingDeviceReplaced(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionGraphicsDevice, winrt::Windows::UI::Composition::RenderingDeviceReplacedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, RenderingDeviceReplaced_revoker>(this, RenderingDeviceReplaced(handler));
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice<D>::RenderingDeviceReplaced(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)&_winrt_casted_result;
            _winrt_abi_type->remove_RenderingDeviceReplaced(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice>**)this;
            _winrt_abi_type->remove_RenderingDeviceReplaced(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice2<D>::CreateDrawingSurface2(winrt::Windows::Graphics::SizeInt32 const& sizePixels, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat, winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& alphaMode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDrawingSurface2(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>**)this;
            check_hresult(_winrt_abi_type->CreateDrawingSurface2(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        return winrt::Windows::UI::Composition::CompositionDrawingSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice2<D>::CreateVirtualDrawingSurface(winrt::Windows::Graphics::SizeInt32 const& sizePixels, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat, winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& alphaMode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateVirtualDrawingSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>**)this;
            check_hresult(_winrt_abi_type->CreateVirtualDrawingSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        return winrt::Windows::UI::Composition::CompositionVirtualDrawingSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice3<D>::CreateMipmapSurface(winrt::Windows::Graphics::SizeInt32 const& sizePixels, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat, winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& alphaMode) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateMipmapSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>**)this;
            check_hresult(_winrt_abi_type->CreateMipmapSurface(impl::bind_in(sizePixels), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), &result));
        }
        return winrt::Windows::UI::Composition::CompositionMipmapSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice3<D>::Trim() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Trim());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>**)this;
            check_hresult(_winrt_abi_type->Trim());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionGraphicsDevice4<D>::CaptureAsync(winrt::Windows::UI::Composition::Visual const& captureVisual, winrt::Windows::Graphics::SizeInt32 const& size, winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& pixelFormat, winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& alphaMode, float sdrBoost) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionGraphicsDevice4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CaptureAsync(*(void**)(&captureVisual), impl::bind_in(size), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), sdrBoost, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionGraphicsDevice4>**)this;
            check_hresult(_winrt_abi_type->CaptureAsync(*(void**)(&captureVisual), impl::bind_in(size), static_cast<int32_t>(pixelFormat), static_cast<int32_t>(alphaMode), sdrBoost, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::UI::Composition::ICompositionSurface>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLight<D>::Targets() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Targets(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight>**)this;
            check_hresult(_winrt_abi_type->get_Targets(&value));
        }
        return winrt::Windows::UI::Composition::VisualUnorderedCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLight2<D>::ExclusionsFromTargets() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExclusionsFromTargets(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight2>**)this;
            check_hresult(_winrt_abi_type->get_ExclusionsFromTargets(&value));
        }
        return winrt::Windows::UI::Composition::VisualUnorderedCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLight3<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight3>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLight3<D>::IsEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLight3>**)this;
            check_hresult(_winrt_abi_type->put_IsEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLineGeometry<D>::Start() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLineGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLineGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Start(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Start(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLineGeometry<D>::Start(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLineGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLineGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Start(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Start(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLineGeometry<D>::End() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLineGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLineGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_End(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)this;
            check_hresult(_winrt_abi_type->get_End(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLineGeometry<D>::End(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLineGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLineGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_End(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLineGeometry>**)this;
            check_hresult(_winrt_abi_type->put_End(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLinearGradientBrush<D>::EndPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EndPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_EndPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLinearGradientBrush<D>::EndPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EndPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_EndPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLinearGradientBrush<D>::StartPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StartPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_StartPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionLinearGradientBrush<D>::StartPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StartPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_StartPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMaskBrush<D>::Mask() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMaskBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMaskBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mask(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)this;
            check_hresult(_winrt_abi_type->get_Mask(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMaskBrush<D>::Mask(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMaskBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMaskBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mask(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)this;
            check_hresult(_winrt_abi_type->put_Mask(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMaskBrush<D>::Source() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMaskBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMaskBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)this;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMaskBrush<D>::Source(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMaskBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMaskBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMaskBrush>**)this;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMipmapSurface<D>::LevelCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMipmapSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LevelCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)this;
            check_hresult(_winrt_abi_type->get_LevelCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMipmapSurface<D>::AlphaMode() const
    {
        winrt::Windows::Graphics::DirectX::DirectXAlphaMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMipmapSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)this;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMipmapSurface<D>::PixelFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMipmapSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)this;
            check_hresult(_winrt_abi_type->get_PixelFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMipmapSurface<D>::SizeInt32() const
    {
        winrt::Windows::Graphics::SizeInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMipmapSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SizeInt32(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)this;
            check_hresult(_winrt_abi_type->get_SizeInt32(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionMipmapSurface<D>::GetDrawingSurfaceForLevel(uint32_t level) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionMipmapSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDrawingSurfaceForLevel(level, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionMipmapSurface>**)this;
            check_hresult(_winrt_abi_type->GetDrawingSurfaceForLevel(level, &result));
        }
        return winrt::Windows::UI::Composition::CompositionDrawingSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::BottomInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BottomInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_BottomInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::BottomInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BottomInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_BottomInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::BottomInsetScale() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BottomInsetScale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_BottomInsetScale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::BottomInsetScale(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BottomInsetScale(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_BottomInsetScale(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::IsCenterHollow() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCenterHollow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_IsCenterHollow(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::IsCenterHollow(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCenterHollow(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_IsCenterHollow(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::LeftInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LeftInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_LeftInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::LeftInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LeftInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_LeftInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::LeftInsetScale() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LeftInsetScale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_LeftInsetScale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::LeftInsetScale(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LeftInsetScale(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_LeftInsetScale(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::RightInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RightInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_RightInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::RightInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RightInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_RightInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::RightInsetScale() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RightInsetScale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_RightInsetScale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::RightInsetScale(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RightInsetScale(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_RightInsetScale(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::Source() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::Source(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::TopInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TopInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_TopInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::TopInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TopInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_TopInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::TopInsetScale() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TopInsetScale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->get_TopInsetScale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::TopInsetScale(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TopInsetScale(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->put_TopInsetScale(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::SetInsets(float inset) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetInsets(inset));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->SetInsets(inset));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::SetInsets(float left, float top, float right, float bottom) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetInsetsWithValues(left, top, right, bottom));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->SetInsetsWithValues(left, top, right, bottom));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::SetInsetScales(float scale) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetInsetScales(scale));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->SetInsetScales(scale));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionNineGridBrush<D>::SetInsetScales(float left, float top, float right, float bottom) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionNineGridBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetInsetScalesWithValues(left, top, right, bottom));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionNineGridBrush>**)this;
            check_hresult(_winrt_abi_type->SetInsetScalesWithValues(left, top, right, bottom));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject<D>::Compositor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Compositor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)this;
            check_hresult(_winrt_abi_type->get_Compositor(&value));
        }
        return winrt::Windows::UI::Composition::Compositor{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject<D>::Dispatcher() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)this;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        return winrt::Windows::UI::Core::CoreDispatcher{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::UI::Composition::CompositionPropertySet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject<D>::StartAnimation(param::hstring const& propertyName, winrt::Windows::UI::Composition::CompositionAnimation const& animation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimation(*(void**)(&propertyName), *(void**)(&animation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)this;
            check_hresult(_winrt_abi_type->StartAnimation(*(void**)(&propertyName), *(void**)(&animation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject<D>::StopAnimation(param::hstring const& propertyName) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StopAnimation(*(void**)(&propertyName)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject>**)this;
            check_hresult(_winrt_abi_type->StopAnimation(*(void**)(&propertyName)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::Comment() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::Comment(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Comment(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->put_Comment(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::ImplicitAnimations() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ImplicitAnimations(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->get_ImplicitAnimations(&value));
        }
        return winrt::Windows::UI::Composition::ImplicitAnimationCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::ImplicitAnimations(winrt::Windows::UI::Composition::ImplicitAnimationCollection const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ImplicitAnimations(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->put_ImplicitAnimations(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::StartAnimationGroup(winrt::Windows::UI::Composition::ICompositionAnimationBase const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimationGroup(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->StartAnimationGroup(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject2<D>::StopAnimationGroup(winrt::Windows::UI::Composition::ICompositionAnimationBase const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StopAnimationGroup(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject2>**)this;
            check_hresult(_winrt_abi_type->StopAnimationGroup(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject3<D>::DispatcherQueue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DispatcherQueue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject3>**)this;
            check_hresult(_winrt_abi_type->get_DispatcherQueue(&value));
        }
        return winrt::Windows::System::DispatcherQueue{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject4<D>::TryGetAnimationController(param::hstring const& propertyName) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetAnimationController(*(void**)(&propertyName), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject4>**)this;
            check_hresult(_winrt_abi_type->TryGetAnimationController(*(void**)(&propertyName), &result));
        }
        return winrt::Windows::UI::Composition::AnimationController{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObject5<D>::StartAnimation(param::hstring const& propertyName, winrt::Windows::UI::Composition::CompositionAnimation const& animation, winrt::Windows::UI::Composition::AnimationController const& animationController) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObject5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObject5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimationWithController(*(void**)(&propertyName), *(void**)(&animation), *(void**)(&animationController)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObject5>**)this;
            check_hresult(_winrt_abi_type->StartAnimationWithController(*(void**)(&propertyName), *(void**)(&animation), *(void**)(&animationController)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObjectStatics<D>::StartAnimationWithIAnimationObject(winrt::Windows::UI::Composition::IAnimationObject const& target, param::hstring const& propertyName, winrt::Windows::UI::Composition::CompositionAnimation const& animation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObjectStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObjectStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObjectStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimationWithIAnimationObject(*(void**)(&target), *(void**)(&propertyName), *(void**)(&animation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObjectStatics>**)this;
            check_hresult(_winrt_abi_type->StartAnimationWithIAnimationObject(*(void**)(&target), *(void**)(&propertyName), *(void**)(&animation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionObjectStatics<D>::StartAnimationGroupWithIAnimationObject(winrt::Windows::UI::Composition::IAnimationObject const& target, winrt::Windows::UI::Composition::ICompositionAnimationBase const& animation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionObjectStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionObjectStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObjectStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimationGroupWithIAnimationObject(*(void**)(&target), *(void**)(&animation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionObjectStatics>**)this;
            check_hresult(_winrt_abi_type->StartAnimationGroupWithIAnimationObject(*(void**)(&target), *(void**)(&animation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPathFactory<D>::Create(winrt::Windows::Graphics::IGeometrySource2D const& source) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPathFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPathFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&source), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&source), &value));
        }
        return winrt::Windows::UI::Composition::CompositionPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPathGeometry<D>::Path() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPathGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPathGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        return winrt::Windows::UI::Composition::CompositionPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPathGeometry<D>::Path(winrt::Windows::UI::Composition::CompositionPath const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPathGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPathGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Path(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPathGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Path(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::BlurRadiusMultiplier() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BlurRadiusMultiplier(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_BlurRadiusMultiplier(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::BlurRadiusMultiplier(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BlurRadiusMultiplier(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->put_BlurRadiusMultiplier(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::Casters() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Casters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_Casters(&value));
        }
        return winrt::Windows::UI::Composition::CompositionProjectedShadowCasterCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::LightSource() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LightSource(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_LightSource(&value));
        }
        return winrt::Windows::UI::Composition::CompositionLight{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::LightSource(winrt::Windows::UI::Composition::CompositionLight const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LightSource(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->put_LightSource(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::MaxBlurRadius() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxBlurRadius(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_MaxBlurRadius(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::MaxBlurRadius(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxBlurRadius(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->put_MaxBlurRadius(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::MinBlurRadius() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinBlurRadius(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_MinBlurRadius(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::MinBlurRadius(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinBlurRadius(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->put_MinBlurRadius(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadow<D>::Receivers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Receivers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->get_Receivers(&value));
        }
        return winrt::Windows::UI::Composition::CompositionProjectedShadowReceiverUnorderedCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCaster<D>::Brush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Brush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)this;
            check_hresult(_winrt_abi_type->get_Brush(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCaster<D>::Brush(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Brush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)this;
            check_hresult(_winrt_abi_type->put_Brush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCaster<D>::CastingVisual() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CastingVisual(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)this;
            check_hresult(_winrt_abi_type->get_CastingVisual(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCaster<D>::CastingVisual(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CastingVisual(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>**)this;
            check_hresult(_winrt_abi_type->put_CastingVisual(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::Count() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::InsertAbove(winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& newCaster, winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& reference) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAbove(*(void**)(&newCaster), *(void**)(&reference)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAbove(*(void**)(&newCaster), *(void**)(&reference)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::InsertAtBottom(winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& newCaster) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAtBottom(*(void**)(&newCaster)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAtBottom(*(void**)(&newCaster)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::InsertAtTop(winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& newCaster) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAtTop(*(void**)(&newCaster)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAtTop(*(void**)(&newCaster)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::InsertBelow(winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& newCaster, winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& reference) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertBelow(*(void**)(&newCaster), *(void**)(&reference)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->InsertBelow(*(void**)(&newCaster), *(void**)(&reference)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::Remove(winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const& caster) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&caster)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&caster)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollection<D>::RemoveAll() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>**)this;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowCasterCollectionStatics<D>::MaxRespectedCasters() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxRespectedCasters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics>**)this;
            check_hresult(_winrt_abi_type->get_MaxRespectedCasters(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiver<D>::ReceivingVisual() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReceivingVisual(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>**)this;
            check_hresult(_winrt_abi_type->get_ReceivingVisual(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiver<D>::ReceivingVisual(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ReceivingVisual(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>**)this;
            check_hresult(_winrt_abi_type->put_ReceivingVisual(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiverUnorderedCollection<D>::Add(winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Add(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->Add(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiverUnorderedCollection<D>::Count() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiverUnorderedCollection<D>::Remove(winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionProjectedShadowReceiverUnorderedCollection<D>::RemoveAll() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertColor(param::hstring const& propertyName, winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertColor(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertColor(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertMatrix3x2(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertMatrix3x2(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertMatrix3x2(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertMatrix4x4(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float4x4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertMatrix4x4(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertMatrix4x4(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertQuaternion(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::quaternion const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertQuaternion(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertQuaternion(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertScalar(param::hstring const& propertyName, float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertScalar(*(void**)(&propertyName), value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertScalar(*(void**)(&propertyName), value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertVector2(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertVector2(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertVector2(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertVector3(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertVector3(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertVector3(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::InsertVector4(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertVector4(*(void**)(&propertyName), impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->InsertVector4(*(void**)(&propertyName), impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetColor(param::hstring const& propertyName, winrt::Windows::UI::Color& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetColor(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetColor(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetMatrix3x2(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float3x2& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetMatrix3x2(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetMatrix3x2(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetMatrix4x4(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float4x4& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetMatrix4x4(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetMatrix4x4(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetQuaternion(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::quaternion& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetQuaternion(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetQuaternion(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetScalar(param::hstring const& propertyName, float& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetScalar(*(void**)(&propertyName), &value, reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetScalar(*(void**)(&propertyName), &value, reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetVector2(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float2& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetVector2(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetVector2(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetVector3(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float3& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetVector3(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetVector3(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet<D>::TryGetVector4(param::hstring const& propertyName, winrt::Windows::Foundation::Numerics::float4& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetVector4(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet>**)this;
            check_hresult(_winrt_abi_type->TryGetVector4(*(void**)(&propertyName), impl::bind_out(value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet2<D>::InsertBoolean(param::hstring const& propertyName, bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertBoolean(*(void**)(&propertyName), value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet2>**)this;
            check_hresult(_winrt_abi_type->InsertBoolean(*(void**)(&propertyName), value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionPropertySet2<D>::TryGetBoolean(param::hstring const& propertyName, bool& value) const
    {
        winrt::Windows::UI::Composition::CompositionGetValueStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionPropertySet2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionPropertySet2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetBoolean(*(void**)(&propertyName), &value, reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionPropertySet2>**)this;
            check_hresult(_winrt_abi_type->TryGetBoolean(*(void**)(&propertyName), &value, reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::EllipseCenter() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EllipseCenter(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_EllipseCenter(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::EllipseCenter(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EllipseCenter(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_EllipseCenter(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::EllipseRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EllipseRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_EllipseRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::EllipseRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EllipseRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_EllipseRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::GradientOriginOffset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GradientOriginOffset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->get_GradientOriginOffset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRadialGradientBrush<D>::GradientOriginOffset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_GradientOriginOffset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>**)this;
            check_hresult(_winrt_abi_type->put_GradientOriginOffset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRectangleGeometry<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRectangleGeometry<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRectangleGeometry<D>::Size() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRectangleGeometry<D>::Size(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::CornerRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CornerRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->get_CornerRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::CornerRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CornerRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->put_CornerRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::Size() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionRoundedRectangleGeometry<D>::Size(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>**)this;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::IsEnded() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnded(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->get_IsEnded(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::End() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->End());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->End());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::Resume() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Resume());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->Resume());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::Suspend() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Suspend());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->Suspend());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::Completed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::Completed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Completed_revoker>(this, Completed(handler));
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionScopedBatch<D>::Completed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionScopedBatch, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionScopedBatch>**)this;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::RotationAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::RotationAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::RotationAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::RotationAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::Scale(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float3x2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionShape<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionShape>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::FillBrush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FillBrush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_FillBrush(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::FillBrush(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FillBrush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_FillBrush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::Geometry() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Geometry(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_Geometry(&value));
        }
        return winrt::Windows::UI::Composition::CompositionGeometry{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::Geometry(winrt::Windows::UI::Composition::CompositionGeometry const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Geometry(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_Geometry(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::IsStrokeNonScaling() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStrokeNonScaling(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_IsStrokeNonScaling(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::IsStrokeNonScaling(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsStrokeNonScaling(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_IsStrokeNonScaling(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeBrush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeBrush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeBrush(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeBrush(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeBrush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeBrush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeDashArray() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeDashArray(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeDashArray(&value));
        }
        return winrt::Windows::UI::Composition::CompositionStrokeDashArray{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeDashCap() const
    {
        winrt::Windows::UI::Composition::CompositionStrokeCap value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeDashCap(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeDashCap(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeDashCap(winrt::Windows::UI::Composition::CompositionStrokeCap const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeDashCap(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeDashCap(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeDashOffset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeDashOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeDashOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeDashOffset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeDashOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeDashOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeEndCap() const
    {
        winrt::Windows::UI::Composition::CompositionStrokeCap value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeEndCap(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeEndCap(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeEndCap(winrt::Windows::UI::Composition::CompositionStrokeCap const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeEndCap(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeEndCap(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeLineJoin() const
    {
        winrt::Windows::UI::Composition::CompositionStrokeLineJoin value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeLineJoin(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeLineJoin(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeLineJoin(winrt::Windows::UI::Composition::CompositionStrokeLineJoin const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeLineJoin(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeLineJoin(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeMiterLimit() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeMiterLimit(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeMiterLimit(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeMiterLimit(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeMiterLimit(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeMiterLimit(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeStartCap() const
    {
        winrt::Windows::UI::Composition::CompositionStrokeCap value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeStartCap(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeStartCap(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeStartCap(winrt::Windows::UI::Composition::CompositionStrokeCap const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeStartCap(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeStartCap(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeThickness() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StrokeThickness(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->get_StrokeThickness(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSpriteShape<D>::StrokeThickness(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSpriteShape, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StrokeThickness(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSpriteShape>**)this;
            check_hresult(_winrt_abi_type->put_StrokeThickness(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSupportsSystemBackdrop<D>::SystemBackdrop() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemBackdrop(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>**)this;
            check_hresult(_winrt_abi_type->get_SystemBackdrop(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSupportsSystemBackdrop<D>::SystemBackdrop(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SystemBackdrop(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>**)this;
            check_hresult(_winrt_abi_type->put_SystemBackdrop(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::BitmapInterpolationMode() const
    {
        winrt::Windows::UI::Composition::CompositionBitmapInterpolationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BitmapInterpolationMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->get_BitmapInterpolationMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::BitmapInterpolationMode(winrt::Windows::UI::Composition::CompositionBitmapInterpolationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BitmapInterpolationMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->put_BitmapInterpolationMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::HorizontalAlignmentRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::HorizontalAlignmentRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::Stretch() const
    {
        winrt::Windows::UI::Composition::CompositionStretch value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Stretch(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->get_Stretch(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::Stretch(winrt::Windows::UI::Composition::CompositionStretch const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Stretch(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->put_Stretch(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::Surface() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Surface(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->get_Surface(&value));
        }
        return winrt::Windows::UI::Composition::ICompositionSurface{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::Surface(winrt::Windows::UI::Composition::ICompositionSurface const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Surface(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->put_Surface(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::VerticalAlignmentRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush<D>::VerticalAlignmentRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush>**)this;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::AnchorPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::AnchorPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::RotationAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::RotationAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::RotationAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::RotationAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::Scale(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float3x2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush2<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush3<D>::SnapToPixels() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SnapToPixels(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>**)this;
            check_hresult(_winrt_abi_type->get_SnapToPixels(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceBrush3<D>::SnapToPixels(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SnapToPixels(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>**)this;
            check_hresult(_winrt_abi_type->put_SnapToPixels(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionSurfaceFacade<D>::GetRealSurface() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionSurfaceFacade>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionSurfaceFacade, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceFacade>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetRealSurface(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionSurfaceFacade>**)this;
            check_hresult(_winrt_abi_type->GetRealSurface(&result));
        }
        return winrt::Windows::UI::Composition::ICompositionSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTarget<D>::Root() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTarget>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTarget, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTarget>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Root(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTarget>**)this;
            check_hresult(_winrt_abi_type->get_Root(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTarget<D>::Root(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTarget>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTarget, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTarget>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Root(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTarget>**)this;
            check_hresult(_winrt_abi_type->put_Root(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::SourceRect() const
    {
        winrt::Windows::Graphics::RectInt32 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourceRect(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->get_SourceRect(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::SourceRect(winrt::Windows::Graphics::RectInt32 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SourceRect(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->put_SourceRect(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::AlphaMode() const
    {
        winrt::Windows::Graphics::DirectX::DirectXAlphaMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->get_AlphaMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::AlphaMode(winrt::Windows::Graphics::DirectX::DirectXAlphaMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AlphaMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->put_AlphaMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::ColorSpace() const
    {
        winrt::Windows::Graphics::DirectX::DirectXColorSpace value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ColorSpace(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->get_ColorSpace(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionTexture<D>::ColorSpace(winrt::Windows::Graphics::DirectX::DirectXColorSpace const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionTexture>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionTexture, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ColorSpace(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionTexture>**)this;
            check_hresult(_winrt_abi_type->put_ColorSpace(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::HorizontalAlignmentRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::HorizontalAlignmentRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Offset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Size() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Size(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Stretch() const
    {
        winrt::Windows::UI::Composition::CompositionStretch value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Stretch(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->get_Stretch(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::Stretch(winrt::Windows::UI::Composition::CompositionStretch const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Stretch(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->put_Stretch(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::VerticalAlignmentRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionViewBox<D>::VerticalAlignmentRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionViewBox>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionViewBox, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionViewBox>**)this;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVirtualDrawingSurface<D>::Trim(array_view<winrt::Windows::Graphics::RectInt32 const> rects) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Trim(rects.size(), get_abi(rects)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface>**)this;
            check_hresult(_winrt_abi_type->Trim(rects.size(), get_abi(rects)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceVisual() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourceVisual(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->get_SourceVisual(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceVisual(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SourceVisual(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->put_SourceVisual(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceOffset() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourceOffset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->get_SourceOffset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceOffset(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SourceOffset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->put_SourceOffset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceSize() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourceSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->get_SourceSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositionVisualSurface<D>::SourceSize(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositionVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SourceSize(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositionVisualSurface>**)this;
            check_hresult(_winrt_abi_type->put_SourceSize(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateColorKeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateColorKeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateColorKeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::ColorKeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateColorBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateColorBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateColorBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionColorBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateColorBrush(winrt::Windows::UI::Color const& color) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateColorBrushWithColor(impl::bind_in(color), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateColorBrushWithColor(impl::bind_in(color), &result));
        }
        return winrt::Windows::UI::Composition::CompositionColorBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateContainerVisual() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateContainerVisual(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateContainerVisual(&result));
        }
        return winrt::Windows::UI::Composition::ContainerVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateCubicBezierEasingFunction(winrt::Windows::Foundation::Numerics::float2 const& controlPoint1, winrt::Windows::Foundation::Numerics::float2 const& controlPoint2) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateCubicBezierEasingFunction(impl::bind_in(controlPoint1), impl::bind_in(controlPoint2), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateCubicBezierEasingFunction(impl::bind_in(controlPoint1), impl::bind_in(controlPoint2), &result));
        }
        return winrt::Windows::UI::Composition::CubicBezierEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateEffectFactory(winrt::Windows::Graphics::Effects::IGraphicsEffect const& graphicsEffect) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateEffectFactory(*(void**)(&graphicsEffect), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateEffectFactory(*(void**)(&graphicsEffect), &result));
        }
        return winrt::Windows::UI::Composition::CompositionEffectFactory{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateEffectFactory(winrt::Windows::Graphics::Effects::IGraphicsEffect const& graphicsEffect, param::iterable<hstring> const& animatableProperties) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateEffectFactoryWithProperties(*(void**)(&graphicsEffect), *(void**)(&animatableProperties), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateEffectFactoryWithProperties(*(void**)(&graphicsEffect), *(void**)(&animatableProperties), &result));
        }
        return winrt::Windows::UI::Composition::CompositionEffectFactory{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateExpressionAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateExpressionAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateExpressionAnimation(&result));
        }
        return winrt::Windows::UI::Composition::ExpressionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateExpressionAnimation(param::hstring const& expression) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateExpressionAnimationWithExpression(*(void**)(&expression), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateExpressionAnimationWithExpression(*(void**)(&expression), &result));
        }
        return winrt::Windows::UI::Composition::ExpressionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateInsetClip() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInsetClip(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateInsetClip(&result));
        }
        return winrt::Windows::UI::Composition::InsetClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateInsetClip(float leftInset, float topInset, float rightInset, float bottomInset) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInsetClipWithInsets(leftInset, topInset, rightInset, bottomInset, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateInsetClipWithInsets(leftInset, topInset, rightInset, bottomInset, &result));
        }
        return winrt::Windows::UI::Composition::InsetClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateLinearEasingFunction() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateLinearEasingFunction(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateLinearEasingFunction(&result));
        }
        return winrt::Windows::UI::Composition::LinearEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreatePropertySet() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePropertySet(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreatePropertySet(&result));
        }
        return winrt::Windows::UI::Composition::CompositionPropertySet{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateQuaternionKeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateQuaternionKeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateQuaternionKeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::QuaternionKeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateScalarKeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateScalarKeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateScalarKeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::ScalarKeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateScopedBatch(winrt::Windows::UI::Composition::CompositionBatchTypes const& batchType) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateScopedBatch(static_cast<uint32_t>(batchType), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateScopedBatch(static_cast<uint32_t>(batchType), &result));
        }
        return winrt::Windows::UI::Composition::CompositionScopedBatch{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateSpriteVisual() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpriteVisual(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateSpriteVisual(&result));
        }
        return winrt::Windows::UI::Composition::SpriteVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateSurfaceBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSurfaceBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateSurfaceBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionSurfaceBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateSurfaceBrush(winrt::Windows::UI::Composition::ICompositionSurface const& surface) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSurfaceBrushWithSurface(*(void**)(&surface), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateSurfaceBrushWithSurface(*(void**)(&surface), &result));
        }
        return winrt::Windows::UI::Composition::CompositionSurfaceBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateTargetForCurrentView() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateTargetForCurrentView(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateTargetForCurrentView(&result));
        }
        return winrt::Windows::UI::Composition::CompositionTarget{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateVector2KeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateVector2KeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateVector2KeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::Vector2KeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateVector3KeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateVector3KeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateVector3KeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::Vector3KeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::CreateVector4KeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateVector4KeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->CreateVector4KeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::Vector4KeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor<D>::GetCommitBatch(winrt::Windows::UI::Composition::CompositionBatchTypes const& batchType) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCommitBatch(static_cast<uint32_t>(batchType), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor>**)this;
            check_hresult(_winrt_abi_type->GetCommitBatch(static_cast<uint32_t>(batchType), &result));
        }
        return winrt::Windows::UI::Composition::CompositionCommitBatch{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateAmbientLight() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAmbientLight(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateAmbientLight(&result));
        }
        return winrt::Windows::UI::Composition::AmbientLight{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateAnimationGroup() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAnimationGroup(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateAnimationGroup(&result));
        }
        return winrt::Windows::UI::Composition::CompositionAnimationGroup{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateBackdropBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBackdropBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateBackdropBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionBackdropBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateDistantLight() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDistantLight(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateDistantLight(&result));
        }
        return winrt::Windows::UI::Composition::DistantLight{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateDropShadow() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateDropShadow(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateDropShadow(&result));
        }
        return winrt::Windows::UI::Composition::DropShadow{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateImplicitAnimationCollection() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateImplicitAnimationCollection(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateImplicitAnimationCollection(&result));
        }
        return winrt::Windows::UI::Composition::ImplicitAnimationCollection{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateLayerVisual() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateLayerVisual(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateLayerVisual(&result));
        }
        return winrt::Windows::UI::Composition::LayerVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateMaskBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateMaskBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateMaskBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionMaskBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateNineGridBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateNineGridBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateNineGridBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionNineGridBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreatePointLight() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePointLight(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreatePointLight(&result));
        }
        return winrt::Windows::UI::Composition::PointLight{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateSpotLight() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpotLight(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateSpotLight(&result));
        }
        return winrt::Windows::UI::Composition::SpotLight{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateStepEasingFunction() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStepEasingFunction(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateStepEasingFunction(&result));
        }
        return winrt::Windows::UI::Composition::StepEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor2<D>::CreateStepEasingFunction(int32_t stepCount) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStepEasingFunctionWithStepCount(stepCount, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor2>**)this;
            check_hresult(_winrt_abi_type->CreateStepEasingFunctionWithStepCount(stepCount, &result));
        }
        return winrt::Windows::UI::Composition::StepEasingFunction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor3<D>::CreateHostBackdropBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateHostBackdropBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor3>**)this;
            check_hresult(_winrt_abi_type->CreateHostBackdropBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionBackdropBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateColorGradientStop() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateColorGradientStop(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateColorGradientStop(&result));
        }
        return winrt::Windows::UI::Composition::CompositionColorGradientStop{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateColorGradientStop(float offset, winrt::Windows::UI::Color const& color) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateColorGradientStopWithOffsetAndColor(offset, impl::bind_in(color), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateColorGradientStopWithOffsetAndColor(offset, impl::bind_in(color), &result));
        }
        return winrt::Windows::UI::Composition::CompositionColorGradientStop{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateLinearGradientBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateLinearGradientBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateLinearGradientBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionLinearGradientBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateSpringScalarAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpringScalarAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateSpringScalarAnimation(&result));
        }
        return winrt::Windows::UI::Composition::SpringScalarNaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateSpringVector2Animation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpringVector2Animation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateSpringVector2Animation(&result));
        }
        return winrt::Windows::UI::Composition::SpringVector2NaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor4<D>::CreateSpringVector3Animation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpringVector3Animation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor4>**)this;
            check_hresult(_winrt_abi_type->CreateSpringVector3Animation(&result));
        }
        return winrt::Windows::UI::Composition::SpringVector3NaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::Comment() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::Comment(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Comment(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->put_Comment(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::GlobalPlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GlobalPlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->get_GlobalPlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::GlobalPlaybackRate(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_GlobalPlaybackRate(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->put_GlobalPlaybackRate(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateBounceScalarAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBounceScalarAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateBounceScalarAnimation(&result));
        }
        return winrt::Windows::UI::Composition::BounceScalarNaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateBounceVector2Animation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBounceVector2Animation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateBounceVector2Animation(&result));
        }
        return winrt::Windows::UI::Composition::BounceVector2NaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateBounceVector3Animation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBounceVector3Animation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateBounceVector3Animation(&result));
        }
        return winrt::Windows::UI::Composition::BounceVector3NaturalMotionAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateContainerShape() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateContainerShape(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateContainerShape(&result));
        }
        return winrt::Windows::UI::Composition::CompositionContainerShape{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateEllipseGeometry() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateEllipseGeometry(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateEllipseGeometry(&result));
        }
        return winrt::Windows::UI::Composition::CompositionEllipseGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateLineGeometry() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateLineGeometry(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateLineGeometry(&result));
        }
        return winrt::Windows::UI::Composition::CompositionLineGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreatePathGeometry() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePathGeometry(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreatePathGeometry(&result));
        }
        return winrt::Windows::UI::Composition::CompositionPathGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreatePathGeometry(winrt::Windows::UI::Composition::CompositionPath const& path) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePathGeometryWithPath(*(void**)(&path), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreatePathGeometryWithPath(*(void**)(&path), &result));
        }
        return winrt::Windows::UI::Composition::CompositionPathGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreatePathKeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreatePathKeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreatePathKeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::PathKeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateRectangleGeometry() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRectangleGeometry(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateRectangleGeometry(&result));
        }
        return winrt::Windows::UI::Composition::CompositionRectangleGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateRoundedRectangleGeometry() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRoundedRectangleGeometry(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateRoundedRectangleGeometry(&result));
        }
        return winrt::Windows::UI::Composition::CompositionRoundedRectangleGeometry{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateShapeVisual() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateShapeVisual(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateShapeVisual(&result));
        }
        return winrt::Windows::UI::Composition::ShapeVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateSpriteShape() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpriteShape(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateSpriteShape(&result));
        }
        return winrt::Windows::UI::Composition::CompositionSpriteShape{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateSpriteShape(winrt::Windows::UI::Composition::CompositionGeometry const& geometry) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateSpriteShapeWithGeometry(*(void**)(&geometry), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateSpriteShapeWithGeometry(*(void**)(&geometry), &result));
        }
        return winrt::Windows::UI::Composition::CompositionSpriteShape{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::CreateViewBox() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateViewBox(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->CreateViewBox(&result));
        }
        return winrt::Windows::UI::Composition::CompositionViewBox{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor5<D>::RequestCommitAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestCommitAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor5>**)this;
            check_hresult(_winrt_abi_type->RequestCommitAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor6<D>::CreateGeometricClip() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateGeometricClip(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)this;
            check_hresult(_winrt_abi_type->CreateGeometricClip(&result));
        }
        return winrt::Windows::UI::Composition::CompositionGeometricClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor6<D>::CreateGeometricClip(winrt::Windows::UI::Composition::CompositionGeometry const& geometry) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateGeometricClipWithGeometry(*(void**)(&geometry), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)this;
            check_hresult(_winrt_abi_type->CreateGeometricClipWithGeometry(*(void**)(&geometry), &result));
        }
        return winrt::Windows::UI::Composition::CompositionGeometricClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor6<D>::CreateRedirectVisual() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRedirectVisual(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)this;
            check_hresult(_winrt_abi_type->CreateRedirectVisual(&result));
        }
        return winrt::Windows::UI::Composition::RedirectVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor6<D>::CreateRedirectVisual(winrt::Windows::UI::Composition::Visual const& source) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRedirectVisualWithSourceVisual(*(void**)(&source), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)this;
            check_hresult(_winrt_abi_type->CreateRedirectVisualWithSourceVisual(*(void**)(&source), &result));
        }
        return winrt::Windows::UI::Composition::RedirectVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor6<D>::CreateBooleanKeyFrameAnimation() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateBooleanKeyFrameAnimation(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor6>**)this;
            check_hresult(_winrt_abi_type->CreateBooleanKeyFrameAnimation(&result));
        }
        return winrt::Windows::UI::Composition::BooleanKeyFrameAnimation{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor7<D>::DispatcherQueue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DispatcherQueue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)this;
            check_hresult(_winrt_abi_type->get_DispatcherQueue(&value));
        }
        return winrt::Windows::System::DispatcherQueue{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor7<D>::CreateAnimationPropertyInfo() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAnimationPropertyInfo(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)this;
            check_hresult(_winrt_abi_type->CreateAnimationPropertyInfo(&result));
        }
        return winrt::Windows::UI::Composition::AnimationPropertyInfo{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor7<D>::CreateRectangleClip() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRectangleClip(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)this;
            check_hresult(_winrt_abi_type->CreateRectangleClip(&result));
        }
        return winrt::Windows::UI::Composition::RectangleClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor7<D>::CreateRectangleClip(float left, float top, float right, float bottom) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRectangleClipWithSides(left, top, right, bottom, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)this;
            check_hresult(_winrt_abi_type->CreateRectangleClipWithSides(left, top, right, bottom, &result));
        }
        return winrt::Windows::UI::Composition::RectangleClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor7<D>::CreateRectangleClip(float left, float top, float right, float bottom, winrt::Windows::Foundation::Numerics::float2 const& topLeftRadius, winrt::Windows::Foundation::Numerics::float2 const& topRightRadius, winrt::Windows::Foundation::Numerics::float2 const& bottomRightRadius, winrt::Windows::Foundation::Numerics::float2 const& bottomLeftRadius) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRectangleClipWithSidesAndRadius(left, top, right, bottom, impl::bind_in(topLeftRadius), impl::bind_in(topRightRadius), impl::bind_in(bottomRightRadius), impl::bind_in(bottomLeftRadius), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor7>**)this;
            check_hresult(_winrt_abi_type->CreateRectangleClipWithSidesAndRadius(left, top, right, bottom, impl::bind_in(topLeftRadius), impl::bind_in(topRightRadius), impl::bind_in(bottomRightRadius), impl::bind_in(bottomLeftRadius), &result));
        }
        return winrt::Windows::UI::Composition::RectangleClip{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositor8<D>::CreateAnimationController() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositor8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositor8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAnimationController(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositor8>**)this;
            check_hresult(_winrt_abi_type->CreateAnimationController(&result));
        }
        return winrt::Windows::UI::Composition::AnimationController{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorStatics<D>::MaxGlobalPlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxGlobalPlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorStatics>**)this;
            check_hresult(_winrt_abi_type->get_MaxGlobalPlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorStatics<D>::MinGlobalPlaybackRate() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinGlobalPlaybackRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinGlobalPlaybackRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithBlurredWallpaperBackdropBrush<D>::TryCreateBlurredWallpaperBackdropBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryCreateBlurredWallpaperBackdropBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush>**)this;
            check_hresult(_winrt_abi_type->TryCreateBlurredWallpaperBackdropBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionBackdropBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithProjectedShadow<D>::CreateProjectedShadowCaster() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateProjectedShadowCaster(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->CreateProjectedShadowCaster(&result));
        }
        return winrt::Windows::UI::Composition::CompositionProjectedShadowCaster{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithProjectedShadow<D>::CreateProjectedShadow() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateProjectedShadow(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->CreateProjectedShadow(&result));
        }
        return winrt::Windows::UI::Composition::CompositionProjectedShadow{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithProjectedShadow<D>::CreateProjectedShadowReceiver() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateProjectedShadowReceiver(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>**)this;
            check_hresult(_winrt_abi_type->CreateProjectedShadowReceiver(&result));
        }
        return winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithRadialGradient<D>::CreateRadialGradientBrush() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithRadialGradient>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithRadialGradient, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithRadialGradient>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateRadialGradientBrush(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithRadialGradient>**)this;
            check_hresult(_winrt_abi_type->CreateRadialGradientBrush(&result));
        }
        return winrt::Windows::UI::Composition::CompositionRadialGradientBrush{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICompositorWithVisualSurface<D>::CreateVisualSurface() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICompositorWithVisualSurface>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICompositorWithVisualSurface, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithVisualSurface>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateVisualSurface(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICompositorWithVisualSurface>**)this;
            check_hresult(_winrt_abi_type->CreateVisualSurface(&result));
        }
        return winrt::Windows::UI::Composition::CompositionVisualSurface{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IContainerVisual<D>::Children() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IContainerVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IContainerVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IContainerVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IContainerVisual>**)this;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        return winrt::Windows::UI::Composition::VisualCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ICubicBezierEasingFunction<D>::ControlPoint1() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICubicBezierEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICubicBezierEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICubicBezierEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ControlPoint1(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICubicBezierEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_ControlPoint1(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ICubicBezierEasingFunction<D>::ControlPoint2() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ICubicBezierEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ICubicBezierEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICubicBezierEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ControlPoint2(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ICubicBezierEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_ControlPoint2(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisual<D>::AddTrailPoints(array_view<winrt::Windows::UI::Composition::InkTrailPoint const> inkPoints) const
    {
        uint32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddTrailPoints(inkPoints.size(), get_abi(inkPoints), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)this;
            check_hresult(_winrt_abi_type->AddTrailPoints(inkPoints.size(), get_abi(inkPoints), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisual<D>::AddTrailPointsWithPrediction(array_view<winrt::Windows::UI::Composition::InkTrailPoint const> inkPoints, array_view<winrt::Windows::UI::Composition::InkTrailPoint const> predictedInkPoints) const
    {
        uint32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddTrailPointsWithPrediction(inkPoints.size(), get_abi(inkPoints), predictedInkPoints.size(), get_abi(predictedInkPoints), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)this;
            check_hresult(_winrt_abi_type->AddTrailPointsWithPrediction(inkPoints.size(), get_abi(inkPoints), predictedInkPoints.size(), get_abi(predictedInkPoints), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisual<D>::RemoveTrailPoints(uint32_t generationId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveTrailPoints(generationId));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)this;
            check_hresult(_winrt_abi_type->RemoveTrailPoints(generationId));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisual<D>::StartNewTrail(winrt::Windows::UI::Color const& color) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartNewTrail(impl::bind_in(color)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>**)this;
            check_hresult(_winrt_abi_type->StartNewTrail(impl::bind_in(color)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisualStatics<D>::Create(winrt::Windows::UI::Composition::Compositor const& compositor) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&compositor), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&compositor), &result));
        }
        return winrt::Windows::UI::Composition::DelegatedInkTrailVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IDelegatedInkTrailVisualStatics<D>::CreateForSwapChain(winrt::Windows::UI::Composition::Compositor const& compositor, winrt::Windows::UI::Composition::ICompositionSurface const& swapChain) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateForSwapChain(*(void**)(&compositor), *(void**)(&swapChain), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>**)this;
            check_hresult(_winrt_abi_type->CreateForSwapChain(*(void**)(&compositor), *(void**)(&swapChain), &result));
        }
        return winrt::Windows::UI::Composition::DelegatedInkTrailVisual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::CoordinateSpace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::CoordinateSpace(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::Direction() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Direction(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->get_Direction(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight<D>::Direction(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Direction(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight>**)this;
            check_hresult(_winrt_abi_type->put_Direction(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight2<D>::Intensity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight2>**)this;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDistantLight2<D>::Intensity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDistantLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDistantLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDistantLight2>**)this;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::BlurRadius() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BlurRadius(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->get_BlurRadius(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::BlurRadius(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BlurRadius(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->put_BlurRadius(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Mask() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mask(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->get_Mask(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Mask(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mask(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->put_Mask(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Offset(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Opacity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow<D>::Opacity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow>**)this;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow2<D>::SourcePolicy() const
    {
        winrt::Windows::UI::Composition::CompositionDropShadowSourcePolicy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SourcePolicy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow2>**)this;
            check_hresult(_winrt_abi_type->get_SourcePolicy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IDropShadow2<D>::SourcePolicy(winrt::Windows::UI::Composition::CompositionDropShadowSourcePolicy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IDropShadow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IDropShadow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SourcePolicy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IDropShadow2>**)this;
            check_hresult(_winrt_abi_type->put_SourcePolicy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IElasticEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IElasticEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IElasticEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IElasticEasingFunction<D>::Oscillations() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IElasticEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IElasticEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Oscillations(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Oscillations(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IElasticEasingFunction<D>::Springiness() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IElasticEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IElasticEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Springiness(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IElasticEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Springiness(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IExponentialEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IExponentialEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IExponentialEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExponentialEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExponentialEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IExponentialEasingFunction<D>::Exponent() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IExponentialEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IExponentialEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExponentialEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Exponent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExponentialEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Exponent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IExpressionAnimation<D>::Expression() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IExpressionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IExpressionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExpressionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Expression(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExpressionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Expression(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IExpressionAnimation<D>::Expression(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IExpressionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IExpressionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExpressionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Expression(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IExpressionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Expression(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::BottomInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BottomInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->get_BottomInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::BottomInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BottomInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->put_BottomInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::LeftInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LeftInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->get_LeftInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::LeftInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LeftInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->put_LeftInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::RightInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RightInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->get_RightInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::RightInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RightInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->put_RightInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::TopInset() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TopInset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->get_TopInset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IInsetClip<D>::TopInset(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IInsetClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IInsetClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TopInset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IInsetClip>**)this;
            check_hresult(_winrt_abi_type->put_TopInset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::DelayTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DelayTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DelayTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::DelayTime(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DelayTime(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DelayTime(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::Duration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::Duration(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::IterationBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationIterationBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IterationBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_IterationBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::IterationBehavior(winrt::Windows::UI::Composition::AnimationIterationBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IterationBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_IterationBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::IterationCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IterationCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_IterationCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::IterationCount(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IterationCount(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_IterationCount(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::KeyFrameCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyFrameCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_KeyFrameCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::StopBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationStopBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StopBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->get_StopBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::StopBehavior(winrt::Windows::UI::Composition::AnimationStopBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StopBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->put_StopBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::InsertExpressionKeyFrame(float normalizedProgressKey, param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertExpressionKeyFrame(normalizedProgressKey, *(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertExpressionKeyFrame(normalizedProgressKey, *(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation<D>::InsertExpressionKeyFrame(float normalizedProgressKey, param::hstring const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertExpressionKeyFrameWithEasingFunction(normalizedProgressKey, *(void**)(&value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertExpressionKeyFrameWithEasingFunction(normalizedProgressKey, *(void**)(&value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation2<D>::Direction() const
    {
        winrt::Windows::UI::Composition::AnimationDirection value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Direction(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation2>**)this;
            check_hresult(_winrt_abi_type->get_Direction(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation2<D>::Direction(winrt::Windows::UI::Composition::AnimationDirection const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Direction(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation2>**)this;
            check_hresult(_winrt_abi_type->put_Direction(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation3<D>::DelayBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationDelayBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DelayBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation3>**)this;
            check_hresult(_winrt_abi_type->get_DelayBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IKeyFrameAnimation3<D>::DelayBehavior(winrt::Windows::UI::Composition::AnimationDelayBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IKeyFrameAnimation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IKeyFrameAnimation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DelayBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IKeyFrameAnimation3>**)this;
            check_hresult(_winrt_abi_type->put_DelayBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ILayerVisual<D>::Effect() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ILayerVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ILayerVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Effect(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual>**)this;
            check_hresult(_winrt_abi_type->get_Effect(&value));
        }
        return winrt::Windows::UI::Composition::CompositionEffectBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ILayerVisual<D>::Effect(winrt::Windows::UI::Composition::CompositionEffectBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ILayerVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ILayerVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Effect(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual>**)this;
            check_hresult(_winrt_abi_type->put_Effect(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ILayerVisual2<D>::Shadow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ILayerVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ILayerVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual2>**)this;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        return winrt::Windows::UI::Composition::CompositionShadow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ILayerVisual2<D>::Shadow(winrt::Windows::UI::Composition::CompositionShadow const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ILayerVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ILayerVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ILayerVisual2>**)this;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::DelayBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationDelayBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DelayBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DelayBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::DelayBehavior(winrt::Windows::UI::Composition::AnimationDelayBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DelayBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DelayBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::DelayTime() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DelayTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DelayTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::DelayTime(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DelayTime(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DelayTime(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::StopBehavior() const
    {
        winrt::Windows::UI::Composition::AnimationStopBehavior value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StopBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_StopBehavior(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_INaturalMotionAnimation<D>::StopBehavior(winrt::Windows::UI::Composition::AnimationStopBehavior const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::INaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StopBehavior(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::INaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_StopBehavior(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPathKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::UI::Composition::CompositionPath const& path) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPathKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPathKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPathKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, *(void**)(&path)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPathKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, *(void**)(&path)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPathKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::UI::Composition::CompositionPath const& path, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPathKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPathKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPathKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, *(void**)(&path), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPathKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, *(void**)(&path), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::Color() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_Color(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::Color(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_Color(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::ConstantAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ConstantAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_ConstantAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::ConstantAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ConstantAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_ConstantAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::CoordinateSpace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::CoordinateSpace(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::LinearAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinearAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_LinearAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::LinearAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LinearAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_LinearAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::Offset(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::QuadraticAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_QuadraticAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->get_QuadraticAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight<D>::QuadraticAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_QuadraticAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight>**)this;
            check_hresult(_winrt_abi_type->put_QuadraticAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight2<D>::Intensity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight2>**)this;
            check_hresult(_winrt_abi_type->get_Intensity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight2<D>::Intensity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight2>**)this;
            check_hresult(_winrt_abi_type->put_Intensity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight3<D>::MinAttenuationCutoff() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinAttenuationCutoff(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)this;
            check_hresult(_winrt_abi_type->get_MinAttenuationCutoff(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight3<D>::MinAttenuationCutoff(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinAttenuationCutoff(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)this;
            check_hresult(_winrt_abi_type->put_MinAttenuationCutoff(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight3<D>::MaxAttenuationCutoff() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxAttenuationCutoff(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)this;
            check_hresult(_winrt_abi_type->get_MaxAttenuationCutoff(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPointLight3<D>::MaxAttenuationCutoff(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPointLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPointLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxAttenuationCutoff(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPointLight3>**)this;
            check_hresult(_winrt_abi_type->put_MaxAttenuationCutoff(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IPowerEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPowerEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPowerEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPowerEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPowerEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IPowerEasingFunction<D>::Power() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IPowerEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IPowerEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPowerEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Power(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IPowerEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Power(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IQuaternionKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::quaternion const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IQuaternionKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::quaternion const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IQuaternionKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Bottom() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bottom(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_Bottom(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Bottom(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Bottom(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_Bottom(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::BottomLeftRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BottomLeftRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_BottomLeftRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::BottomLeftRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BottomLeftRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_BottomLeftRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::BottomRightRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BottomRightRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_BottomRightRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::BottomRightRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BottomRightRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_BottomRightRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Left() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Left(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_Left(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Left(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Left(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_Left(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Right() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Right(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_Right(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Right(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Right(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_Right(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Top() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Top(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_Top(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::Top(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Top(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_Top(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::TopLeftRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TopLeftRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_TopLeftRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::TopLeftRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TopLeftRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_TopLeftRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::TopRightRadius() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TopRightRadius(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->get_TopRightRadius(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IRectangleClip<D>::TopRightRadius(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRectangleClip>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRectangleClip, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TopRightRadius(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRectangleClip>**)this;
            check_hresult(_winrt_abi_type->put_TopRightRadius(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRedirectVisual<D>::Source() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRedirectVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRedirectVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRedirectVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRedirectVisual>**)this;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IRedirectVisual<D>::Source(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRedirectVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRedirectVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRedirectVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRedirectVisual>**)this;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IRenderingDeviceReplacedEventArgs<D>::GraphicsDevice() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IRenderingDeviceReplacedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IRenderingDeviceReplacedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRenderingDeviceReplacedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GraphicsDevice(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IRenderingDeviceReplacedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_GraphicsDevice(&value));
        }
        return winrt::Windows::UI::Composition::CompositionGraphicsDevice{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarKeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, float value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, value, *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarKeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, value, *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::FinalValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        return winrt::Windows::Foundation::IReference<float>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::FinalValue(winrt::Windows::Foundation::IReference<float> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::InitialValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        return winrt::Windows::Foundation::IReference<float>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::InitialValue(winrt::Windows::Foundation::IReference<float> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::InitialVelocity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialVelocity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialVelocity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IScalarNaturalMotionAnimation<D>::InitialVelocity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialVelocity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialVelocity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IShapeVisual<D>::Shapes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IShapeVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IShapeVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Shapes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)this;
            check_hresult(_winrt_abi_type->get_Shapes(&value));
        }
        return winrt::Windows::UI::Composition::CompositionShapeCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IShapeVisual<D>::ViewBox() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IShapeVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IShapeVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ViewBox(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)this;
            check_hresult(_winrt_abi_type->get_ViewBox(&value));
        }
        return winrt::Windows::UI::Composition::CompositionViewBox{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IShapeVisual<D>::ViewBox(winrt::Windows::UI::Composition::CompositionViewBox const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IShapeVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IShapeVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ViewBox(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IShapeVisual>**)this;
            check_hresult(_winrt_abi_type->put_ViewBox(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISineEasingFunction<D>::Mode() const
    {
        winrt::Windows::UI::Composition::CompositionEasingFunctionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISineEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISineEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISineEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISineEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::ConstantAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ConstantAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_ConstantAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::ConstantAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ConstantAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_ConstantAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::CoordinateSpace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_CoordinateSpace(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::CoordinateSpace(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_CoordinateSpace(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::Direction() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Direction(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_Direction(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::Direction(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Direction(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_Direction(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InnerConeAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_InnerConeAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InnerConeAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_InnerConeAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InnerConeAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_InnerConeAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InnerConeAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_InnerConeAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeColor() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InnerConeColor(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_InnerConeColor(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::InnerConeColor(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InnerConeColor(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_InnerConeColor(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::LinearAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinearAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_LinearAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::LinearAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LinearAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_LinearAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::Offset(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OuterConeAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_OuterConeAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OuterConeAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_OuterConeAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OuterConeAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_OuterConeAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OuterConeAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_OuterConeAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeColor() const
    {
        winrt::Windows::UI::Color value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OuterConeColor(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_OuterConeColor(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::OuterConeColor(winrt::Windows::UI::Color const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OuterConeColor(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_OuterConeColor(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::QuadraticAttenuation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_QuadraticAttenuation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->get_QuadraticAttenuation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight<D>::QuadraticAttenuation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_QuadraticAttenuation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight>**)this;
            check_hresult(_winrt_abi_type->put_QuadraticAttenuation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight2<D>::InnerConeIntensity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InnerConeIntensity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)this;
            check_hresult(_winrt_abi_type->get_InnerConeIntensity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight2<D>::InnerConeIntensity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InnerConeIntensity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)this;
            check_hresult(_winrt_abi_type->put_InnerConeIntensity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight2<D>::OuterConeIntensity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OuterConeIntensity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)this;
            check_hresult(_winrt_abi_type->get_OuterConeIntensity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight2<D>::OuterConeIntensity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OuterConeIntensity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight2>**)this;
            check_hresult(_winrt_abi_type->put_OuterConeIntensity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight3<D>::MinAttenuationCutoff() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinAttenuationCutoff(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)this;
            check_hresult(_winrt_abi_type->get_MinAttenuationCutoff(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight3<D>::MinAttenuationCutoff(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinAttenuationCutoff(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)this;
            check_hresult(_winrt_abi_type->put_MinAttenuationCutoff(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight3<D>::MaxAttenuationCutoff() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxAttenuationCutoff(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)this;
            check_hresult(_winrt_abi_type->get_MaxAttenuationCutoff(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpotLight3<D>::MaxAttenuationCutoff(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpotLight3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpotLight3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxAttenuationCutoff(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpotLight3>**)this;
            check_hresult(_winrt_abi_type->put_MaxAttenuationCutoff(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringScalarNaturalMotionAnimation<D>::DampingRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringScalarNaturalMotionAnimation<D>::DampingRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringScalarNaturalMotionAnimation<D>::Period() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringScalarNaturalMotionAnimation<D>::Period(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringScalarNaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector2NaturalMotionAnimation<D>::DampingRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector2NaturalMotionAnimation<D>::DampingRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector2NaturalMotionAnimation<D>::Period() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector2NaturalMotionAnimation<D>::Period(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector3NaturalMotionAnimation<D>::DampingRatio() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_DampingRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector3NaturalMotionAnimation<D>::DampingRatio(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_DampingRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector3NaturalMotionAnimation<D>::Period() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_Period(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpringVector3NaturalMotionAnimation<D>::Period(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpringVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_Period(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpriteVisual<D>::Brush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpriteVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpriteVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Brush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual>**)this;
            check_hresult(_winrt_abi_type->get_Brush(&value));
        }
        return winrt::Windows::UI::Composition::CompositionBrush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpriteVisual<D>::Brush(winrt::Windows::UI::Composition::CompositionBrush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpriteVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpriteVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Brush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual>**)this;
            check_hresult(_winrt_abi_type->put_Brush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpriteVisual2<D>::Shadow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpriteVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpriteVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual2>**)this;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        return winrt::Windows::UI::Composition::CompositionShadow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_ISpriteVisual2<D>::Shadow(winrt::Windows::UI::Composition::CompositionShadow const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::ISpriteVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::ISpriteVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::ISpriteVisual2>**)this;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::FinalStep() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FinalStep(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_FinalStep(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::FinalStep(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FinalStep(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->put_FinalStep(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::InitialStep() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialStep(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_InitialStep(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::InitialStep(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialStep(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->put_InitialStep(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::IsFinalStepSingleFrame() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsFinalStepSingleFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_IsFinalStepSingleFrame(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::IsFinalStepSingleFrame(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsFinalStepSingleFrame(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->put_IsFinalStepSingleFrame(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::IsInitialStepSingleFrame() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsInitialStepSingleFrame(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_IsInitialStepSingleFrame(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::IsInitialStepSingleFrame(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsInitialStepSingleFrame(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->put_IsInitialStepSingleFrame(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::StepCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StepCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->get_StepCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IStepEasingFunction<D>::StepCount(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IStepEasingFunction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IStepEasingFunction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StepCount(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IStepEasingFunction>**)this;
            check_hresult(_winrt_abi_type->put_StepCount(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float2 const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::FinalValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float2>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::FinalValue(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float2> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::InitialValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float2>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::InitialValue(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float2> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::InitialVelocity() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialVelocity(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialVelocity(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector2NaturalMotionAnimation<D>::InitialVelocity(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialVelocity(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector2NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialVelocity(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float3 const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::FinalValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_FinalValue(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float3>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::FinalValue(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float3> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_FinalValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::InitialValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialValue(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float3>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::InitialValue(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Numerics::float3> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialValue(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::InitialVelocity() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InitialVelocity(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->get_InitialVelocity(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector3NaturalMotionAnimation<D>::InitialVelocity(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InitialVelocity(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector3NaturalMotionAnimation>**)this;
            check_hresult(_winrt_abi_type->put_InitialVelocity(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector4KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrame(normalizedProgressKey, impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVector4KeyFrameAnimation<D>::InsertKeyFrame(float normalizedProgressKey, winrt::Windows::Foundation::Numerics::float4 const& value, winrt::Windows::UI::Composition::CompositionEasingFunction const& easingFunction) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVector4KeyFrameAnimation>**)this;
            check_hresult(_winrt_abi_type->InsertKeyFrameWithEasingFunction(normalizedProgressKey, impl::bind_in(value), *(void**)(&easingFunction)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::AnchorPoint() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_AnchorPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::AnchorPoint(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_AnchorPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::BackfaceVisibility() const
    {
        winrt::Windows::UI::Composition::CompositionBackfaceVisibility value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BackfaceVisibility(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_BackfaceVisibility(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::BackfaceVisibility(winrt::Windows::UI::Composition::CompositionBackfaceVisibility const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BackfaceVisibility(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_BackfaceVisibility(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::BorderMode() const
    {
        winrt::Windows::UI::Composition::CompositionBorderMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BorderMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_BorderMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::BorderMode(winrt::Windows::UI::Composition::CompositionBorderMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BorderMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_BorderMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Clip() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Clip(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Clip(&value));
        }
        return winrt::Windows::UI::Composition::CompositionClip{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Clip(winrt::Windows::UI::Composition::CompositionClip const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Clip(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Clip(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::CompositeMode() const
    {
        winrt::Windows::UI::Composition::CompositionCompositeMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompositeMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_CompositeMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::CompositeMode(winrt::Windows::UI::Composition::CompositionCompositeMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CompositeMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_CompositeMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::IsVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_IsVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::IsVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_IsVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Offset() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Offset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Offset(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Offset(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Opacity() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Opacity(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Orientation() const
    {
        winrt::Windows::Foundation::Numerics::quaternion value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Orientation(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Orientation(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Orientation(winrt::Windows::Foundation::Numerics::quaternion const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Orientation(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Orientation(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Parent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        return winrt::Windows::UI::Composition::ContainerVisual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAngle() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngle(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAngle(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngle(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAngleInDegrees() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_RotationAngleInDegrees(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAngleInDegrees(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_RotationAngleInDegrees(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAxis() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAxis(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_RotationAxis(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::RotationAxis(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAxis(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_RotationAxis(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Scale(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Size() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::Size(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_Size(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float4x4 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float4x4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::ParentForTransform() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ParentForTransform(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->get_ParentForTransform(&value));
        }
        return winrt::Windows::UI::Composition::Visual{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::ParentForTransform(winrt::Windows::UI::Composition::Visual const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ParentForTransform(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->put_ParentForTransform(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::RelativeOffsetAdjustment() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RelativeOffsetAdjustment(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->get_RelativeOffsetAdjustment(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::RelativeOffsetAdjustment(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RelativeOffsetAdjustment(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->put_RelativeOffsetAdjustment(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::RelativeSizeAdjustment() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RelativeSizeAdjustment(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->get_RelativeSizeAdjustment(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual2<D>::RelativeSizeAdjustment(winrt::Windows::Foundation::Numerics::float2 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RelativeSizeAdjustment(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual2>**)this;
            check_hresult(_winrt_abi_type->put_RelativeSizeAdjustment(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual3<D>::IsHitTestVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHitTestVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual3>**)this;
            check_hresult(_winrt_abi_type->get_IsHitTestVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual3<D>::IsHitTestVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsHitTestVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual3>**)this;
            check_hresult(_winrt_abi_type->put_IsHitTestVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual4<D>::IsPixelSnappingEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPixelSnappingEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual4>**)this;
            check_hresult(_winrt_abi_type->get_IsPixelSnappingEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisual4<D>::IsPixelSnappingEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisual4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisual4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsPixelSnappingEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisual4>**)this;
            check_hresult(_winrt_abi_type->put_IsPixelSnappingEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::Count() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::InsertAbove(winrt::Windows::UI::Composition::Visual const& newChild, winrt::Windows::UI::Composition::Visual const& sibling) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAbove(*(void**)(&newChild), *(void**)(&sibling)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAbove(*(void**)(&newChild), *(void**)(&sibling)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::InsertAtBottom(winrt::Windows::UI::Composition::Visual const& newChild) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAtBottom(*(void**)(&newChild)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAtBottom(*(void**)(&newChild)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::InsertAtTop(winrt::Windows::UI::Composition::Visual const& newChild) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertAtTop(*(void**)(&newChild)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->InsertAtTop(*(void**)(&newChild)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::InsertBelow(winrt::Windows::UI::Composition::Visual const& newChild, winrt::Windows::UI::Composition::Visual const& sibling) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertBelow(*(void**)(&newChild), *(void**)(&sibling)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->InsertBelow(*(void**)(&newChild), *(void**)(&sibling)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::Remove(winrt::Windows::UI::Composition::Visual const& child) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&child)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&child)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualCollection<D>::RemoveAll() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualCollection>**)this;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualElement2<D>::GetVisualInternal() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetVisualInternal(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualElement2>**)this;
            check_hresult(_winrt_abi_type->GetVisualInternal(&result));
        }
        return winrt::Windows::UI::Composition::Visual{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualUnorderedCollection<D>::Count() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->get_Count(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualUnorderedCollection<D>::Add(winrt::Windows::UI::Composition::Visual const& newVisual) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Add(*(void**)(&newVisual)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->Add(*(void**)(&newVisual)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualUnorderedCollection<D>::Remove(winrt::Windows::UI::Composition::Visual const& visual) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&visual)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->Remove(*(void**)(&visual)));
        }
    }
    template <typename D> auto consume_Windows_UI_Composition_IVisualUnorderedCollection<D>::RemoveAll() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Composition::IVisualUnorderedCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Composition::IVisualUnorderedCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Composition::IVisualUnorderedCollection>**)this;
            check_hresult(_winrt_abi_type->RemoveAll());
        }
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAmbientLight> : produce_base<D, winrt::Windows::UI::Composition::IAmbientLight>
    {
        int32_t __stdcall get_Color(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().Color());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Color(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Color(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAmbientLight2> : produce_base<D, winrt::Windows::UI::Composition::IAmbientLight2>
    {
        int32_t __stdcall get_Intensity(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Intensity());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Intensity(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Intensity(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAnimationController> : produce_base<D, winrt::Windows::UI::Composition::IAnimationController>
    {
        int32_t __stdcall get_PlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().PlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PlaybackRate(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PlaybackRate(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Progress(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Progress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Progress(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Progress(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProgressBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationControllerProgressBehavior>(this->shim().ProgressBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ProgressBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ProgressBehavior(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationControllerProgressBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Pause() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Resume() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resume();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAnimationControllerStatics> : produce_base<D, winrt::Windows::UI::Composition::IAnimationControllerStatics>
    {
        int32_t __stdcall get_MaxPlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MaxPlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinPlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MinPlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAnimationObject> : produce_base<D, winrt::Windows::UI::Composition::IAnimationObject>
    {
        int32_t __stdcall PopulatePropertyInfo(void* propertyName, void* propertyInfo) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PopulatePropertyInfo(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Composition::AnimationPropertyInfo const*>(&propertyInfo));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo> : produce_base<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo>
    {
        int32_t __stdcall get_AccessMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationPropertyAccessMode>(this->shim().AccessMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AccessMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AccessMode(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationPropertyAccessMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo2> : produce_base<D, winrt::Windows::UI::Composition::IAnimationPropertyInfo2>
    {
        int32_t __stdcall GetResolvedCompositionObject(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionObject>(this->shim().GetResolvedCompositionObject());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetResolvedCompositionObjectProperty(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().GetResolvedCompositionObjectProperty());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBackEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::IBackEasingFunction>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEasingFunctionMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Amplitude(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Amplitude());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation> : produce_base<D, winrt::Windows::UI::Composition::IBooleanKeyFrameAnimation>
    {
        int32_t __stdcall InsertKeyFrame(float normalizedProgressKey, bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertKeyFrame(normalizedProgressKey, value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBounceEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::IBounceEasingFunction>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEasingFunctionMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Bounces(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Bounces());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Bounciness(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Bounciness());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation> : produce_base<D, winrt::Windows::UI::Composition::IBounceScalarNaturalMotionAnimation>
    {
        int32_t __stdcall get_Acceleration(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Acceleration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Acceleration(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Acceleration(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Restitution(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Restitution());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Restitution(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restitution(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation> : produce_base<D, winrt::Windows::UI::Composition::IBounceVector2NaturalMotionAnimation>
    {
        int32_t __stdcall get_Acceleration(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Acceleration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Acceleration(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Acceleration(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Restitution(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Restitution());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Restitution(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restitution(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation> : produce_base<D, winrt::Windows::UI::Composition::IBounceVector3NaturalMotionAnimation>
    {
        int32_t __stdcall get_Acceleration(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Acceleration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Acceleration(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Acceleration(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Restitution(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Restitution());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Restitution(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restitution(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICircleEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::ICircleEasingFunction>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEasingFunctionMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation> : produce_base<D, winrt::Windows::UI::Composition::IColorKeyFrameAnimation>
    {
        int32_t __stdcall get_InterpolationColorSpace(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionColorSpace>(this->shim().InterpolationColorSpace());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InterpolationColorSpace(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InterpolationColorSpace(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionColorSpace const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertKeyFrame(float normalizedProgressKey, struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertKeyFrame(normalizedProgressKey, *reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertKeyFrameWithEasingFunction(float normalizedProgressKey, struct struct_Windows_UI_Color value, void* easingFunction) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertKeyFrame(normalizedProgressKey, *reinterpret_cast<winrt::Windows::UI::Color const*>(&value), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunction const*>(&easingFunction));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimation> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimation>
    {
        int32_t __stdcall ClearAllParameters() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClearAllParameters();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearParameter(void* key) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClearParameter(*reinterpret_cast<hstring const*>(&key));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetColorParameter(void* key, struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetColorParameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetMatrix3x2Parameter(void* key, winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetMatrix3x2Parameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetMatrix4x4Parameter(void* key, winrt::Windows::Foundation::Numerics::float4x4 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetMatrix4x4Parameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4x4 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetQuaternionParameter(void* key, winrt::Windows::Foundation::Numerics::quaternion value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetQuaternionParameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetReferenceParameter(void* key, void* compositionObject) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetReferenceParameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionObject const*>(&compositionObject));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetScalarParameter(void* key, float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetScalarParameter(*reinterpret_cast<hstring const*>(&key), value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetVector2Parameter(void* key, winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetVector2Parameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetVector3Parameter(void* key, winrt::Windows::Foundation::Numerics::float3 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetVector3Parameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetVector4Parameter(void* key, winrt::Windows::Foundation::Numerics::float4 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetVector4Parameter(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimation2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimation2>
    {
        int32_t __stdcall SetBooleanParameter(void* key, bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetBooleanParameter(*reinterpret_cast<hstring const*>(&key), value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Target(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Target());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Target(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Target(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimation3> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimation3>
    {
        int32_t __stdcall get_InitialValueExpressions(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::InitialValueExpressionCollection>(this->shim().InitialValueExpressions());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimation4> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimation4>
    {
        int32_t __stdcall SetExpressionReferenceParameter(void* parameterName, void* source) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetExpressionReferenceParameter(*reinterpret_cast<hstring const*>(&parameterName), *reinterpret_cast<winrt::Windows::UI::Composition::IAnimationObject const*>(&source));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimationBase> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimationBase>
    {
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimationFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimationFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup> : produce_base<D, winrt::Windows::UI::Composition::ICompositionAnimationGroup>
    {
        int32_t __stdcall get_Count(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Count());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Add(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Add(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionAnimation const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Remove(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Remove(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionAnimation const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveAll() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveAll();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionBackdropBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionBackdropBrush>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionBatchCompletedEventArgs> : produce_base<D, winrt::Windows::UI::Composition::ICompositionBatchCompletedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionBrush>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionBrushFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionBrushFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionCapabilities> : produce_base<D, winrt::Windows::UI::Composition::ICompositionCapabilities>
    {
        int32_t __stdcall AreEffectsSupported(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().AreEffectsSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AreEffectsFast(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().AreEffectsFast());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Changed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Changed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionCapabilities, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Changed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Changed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics> : produce_base<D, winrt::Windows::UI::Composition::ICompositionCapabilitiesStatics>
    {
        int32_t __stdcall GetForCurrentView(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionCapabilities>(this->shim().GetForCurrentView());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionClip> : produce_base<D, winrt::Windows::UI::Composition::ICompositionClip>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionClip2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionClip2>
    {
        int32_t __stdcall get_AnchorPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().AnchorPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AnchorPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AnchorPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CenterPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().CenterPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CenterPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CenterPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngle(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngle(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngle(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngleInDegrees(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngleInDegrees());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngleInDegrees(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngleInDegrees(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Scale(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Scale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Scale(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scale(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3x2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3x2>(this->shim().TransformMatrix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransformMatrix(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionClipFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionClipFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionColorBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionColorBrush>
    {
        int32_t __stdcall get_Color(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().Color());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Color(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Color(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop> : produce_base<D, winrt::Windows::UI::Composition::ICompositionColorGradientStop>
    {
        int32_t __stdcall get_Color(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().Color());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Color(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Color(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionColorGradientStopCollection> : produce_base<D, winrt::Windows::UI::Composition::ICompositionColorGradientStopCollection>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionCommitBatch> : produce_base<D, winrt::Windows::UI::Composition::ICompositionCommitBatch>
    {
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnded(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnded());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Completed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Completed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Completed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Completed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionContainerShape> : produce_base<D, winrt::Windows::UI::Composition::ICompositionContainerShape>
    {
        int32_t __stdcall get_Shapes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionShapeCollection>(this->shim().Shapes());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface>
    {
        int32_t __stdcall get_AlphaMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXAlphaMode>(this->shim().AlphaMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PixelFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().PixelFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Size(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionDrawingSurface2>
    {
        int32_t __stdcall get_SizeInt32(struct struct_Windows_Graphics_SizeInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::SizeInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::SizeInt32>(this->shim().SizeInt32());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Resize(struct struct_Windows_Graphics_SizeInt32 sizePixels) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resize(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&sizePixels));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Scroll(struct struct_Windows_Graphics_PointInt32 offset) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scroll(*reinterpret_cast<winrt::Windows::Graphics::PointInt32 const*>(&offset));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ScrollRect(struct struct_Windows_Graphics_PointInt32 offset, struct struct_Windows_Graphics_RectInt32 scrollRect) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scroll(*reinterpret_cast<winrt::Windows::Graphics::PointInt32 const*>(&offset), *reinterpret_cast<winrt::Windows::Graphics::RectInt32 const*>(&scrollRect));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ScrollWithClip(struct struct_Windows_Graphics_PointInt32 offset, struct struct_Windows_Graphics_RectInt32 clipRect) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ScrollWithClip(*reinterpret_cast<winrt::Windows::Graphics::PointInt32 const*>(&offset), *reinterpret_cast<winrt::Windows::Graphics::RectInt32 const*>(&clipRect));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ScrollRectWithClip(struct struct_Windows_Graphics_PointInt32 offset, struct struct_Windows_Graphics_RectInt32 clipRect, struct struct_Windows_Graphics_RectInt32 scrollRect) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ScrollWithClip(*reinterpret_cast<winrt::Windows::Graphics::PointInt32 const*>(&offset), *reinterpret_cast<winrt::Windows::Graphics::RectInt32 const*>(&clipRect), *reinterpret_cast<winrt::Windows::Graphics::RectInt32 const*>(&scrollRect));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionDrawingSurfaceFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionDrawingSurfaceFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEasingFunction>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEasingFunctionStatics>
    {
        int32_t __stdcall CreateCubicBezierEasingFunction(void* owner, winrt::Windows::Foundation::Numerics::float2 controlPoint1, winrt::Windows::Foundation::Numerics::float2 controlPoint2, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CubicBezierEasingFunction>(this->shim().CreateCubicBezierEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&controlPoint1), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&controlPoint2)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateLinearEasingFunction(void* owner, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::LinearEasingFunction>(this->shim().CreateLinearEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStepEasingFunction(void* owner, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::StepEasingFunction>(this->shim().CreateStepEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStepEasingFunctionWithStepCount(void* owner, int32_t stepCount, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::StepEasingFunction>(this->shim().CreateStepEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), stepCount));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBackEasingFunction(void* owner, int32_t mode, float amplitude, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BackEasingFunction>(this->shim().CreateBackEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode), amplitude));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBounceEasingFunction(void* owner, int32_t mode, int32_t bounces, float bounciness, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BounceEasingFunction>(this->shim().CreateBounceEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode), bounces, bounciness));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateCircleEasingFunction(void* owner, int32_t mode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CircleEasingFunction>(this->shim().CreateCircleEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateElasticEasingFunction(void* owner, int32_t mode, int32_t oscillations, float springiness, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ElasticEasingFunction>(this->shim().CreateElasticEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode), oscillations, springiness));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateExponentialEasingFunction(void* owner, int32_t mode, float exponent, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ExponentialEasingFunction>(this->shim().CreateExponentialEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode), exponent));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePowerEasingFunction(void* owner, int32_t mode, float power, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::PowerEasingFunction>(this->shim().CreatePowerEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode), power));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSineEasingFunction(void* owner, int32_t mode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SineEasingFunction>(this->shim().CreateSineEasingFunction(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&owner), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunctionMode const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEffectBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEffectBrush>
    {
        int32_t __stdcall GetSourceParameter(void* name, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().GetSourceParameter(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetSourceParameter(void* name, void* source) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetSourceParameter(*reinterpret_cast<hstring const*>(&name), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&source));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEffectFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEffectFactory>
    {
        int32_t __stdcall CreateBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionEffectBrush>(this->shim().CreateBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedError(winrt::hresult* value) noexcept final try
        {
            zero_abi<winrt::hresult>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::hresult>(this->shim().ExtendedError());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LoadStatus(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEffectFactoryLoadStatus>(this->shim().LoadStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameter> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameter>
    {
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEffectSourceParameterFactory>
    {
        int32_t __stdcall Create(void* name, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEffectSourceParameter>(this->shim().Create(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionEllipseGeometry>
    {
        int32_t __stdcall get_Center(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Center());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Center(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Center(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Radius(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Radius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Radius(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Radius(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGeometricClip> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGeometricClip>
    {
        int32_t __stdcall get_Geometry(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionGeometry>(this->shim().Geometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Geometry(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Geometry(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionGeometry const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ViewBox(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionViewBox>(this->shim().ViewBox());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ViewBox(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ViewBox(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionViewBox const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGeometry>
    {
        int32_t __stdcall get_TrimEnd(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TrimEnd());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TrimEnd(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TrimEnd(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TrimOffset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TrimOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TrimOffset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TrimOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TrimStart(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TrimStart());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TrimStart(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TrimStart(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGeometryFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGeometryFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGradientBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGradientBrush>
    {
        int32_t __stdcall get_AnchorPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().AnchorPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AnchorPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AnchorPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CenterPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().CenterPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CenterPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CenterPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ColorStops(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionColorGradientStopCollection>(this->shim().ColorStops());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionGradientExtendMode>(this->shim().ExtendMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ExtendMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ExtendMode(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionGradientExtendMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InterpolationSpace(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionColorSpace>(this->shim().InterpolationSpace());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InterpolationSpace(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InterpolationSpace(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionColorSpace const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngle(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngle(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngle(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngleInDegrees(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngleInDegrees());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngleInDegrees(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngleInDegrees(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Scale(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Scale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Scale(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scale(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3x2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3x2>(this->shim().TransformMatrix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransformMatrix(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGradientBrush2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGradientBrush2>
    {
        int32_t __stdcall get_MappingMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionMappingMode>(this->shim().MappingMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MappingMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MappingMode(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionMappingMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGradientBrushFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGradientBrushFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice>
    {
        int32_t __stdcall CreateDrawingSurface(winrt::Windows::Foundation::Size sizePixels, int32_t pixelFormat, int32_t alphaMode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionDrawingSurface>(this->shim().CreateDrawingSurface(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&sizePixels), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&alphaMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_RenderingDeviceReplaced(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().RenderingDeviceReplaced(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Composition::CompositionGraphicsDevice, winrt::Windows::UI::Composition::RenderingDeviceReplacedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_RenderingDeviceReplaced(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RenderingDeviceReplaced(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice2>
    {
        int32_t __stdcall CreateDrawingSurface2(struct struct_Windows_Graphics_SizeInt32 sizePixels, int32_t pixelFormat, int32_t alphaMode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionDrawingSurface>(this->shim().CreateDrawingSurface2(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&sizePixels), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&alphaMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateVirtualDrawingSurface(struct struct_Windows_Graphics_SizeInt32 sizePixels, int32_t pixelFormat, int32_t alphaMode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionVirtualDrawingSurface>(this->shim().CreateVirtualDrawingSurface(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&sizePixels), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&alphaMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice3> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice3>
    {
        int32_t __stdcall CreateMipmapSurface(struct struct_Windows_Graphics_SizeInt32 sizePixels, int32_t pixelFormat, int32_t alphaMode, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionMipmapSurface>(this->shim().CreateMipmapSurface(*reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&sizePixels), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&alphaMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Trim() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Trim();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice4> : produce_base<D, winrt::Windows::UI::Composition::ICompositionGraphicsDevice4>
    {
        int32_t __stdcall CaptureAsync(void* captureVisual, struct struct_Windows_Graphics_SizeInt32 size, int32_t pixelFormat, int32_t alphaMode, float sdrBoost, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::UI::Composition::ICompositionSurface>>(this->shim().CaptureAsync(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&captureVisual), *reinterpret_cast<winrt::Windows::Graphics::SizeInt32 const*>(&size), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&pixelFormat), *reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&alphaMode), sdrBoost));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLight> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLight>
    {
        int32_t __stdcall get_Targets(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::VisualUnorderedCollection>(this->shim().Targets());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLight2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLight2>
    {
        int32_t __stdcall get_ExclusionsFromTargets(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::VisualUnorderedCollection>(this->shim().ExclusionsFromTargets());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLight3> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLight3>
    {
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLightFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLightFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLineGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLineGeometry>
    {
        int32_t __stdcall get_Start(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Start());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Start(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Start(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_End(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().End());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_End(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().End(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionLinearGradientBrush>
    {
        int32_t __stdcall get_EndPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().EndPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EndPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EndPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StartPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().StartPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StartPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionMaskBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionMaskBrush>
    {
        int32_t __stdcall get_Mask(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().Mask());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mask(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mask(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Source(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().Source());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Source(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Source(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositionMipmapSurface>
    {
        int32_t __stdcall get_LevelCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LevelCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AlphaMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXAlphaMode>(this->shim().AlphaMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PixelFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().PixelFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SizeInt32(struct struct_Windows_Graphics_SizeInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::SizeInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::SizeInt32>(this->shim().SizeInt32());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDrawingSurfaceForLevel(uint32_t level, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionDrawingSurface>(this->shim().GetDrawingSurfaceForLevel(level));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionNineGridBrush>
    {
        int32_t __stdcall get_BottomInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().BottomInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BottomInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BottomInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BottomInsetScale(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().BottomInsetScale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BottomInsetScale(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BottomInsetScale(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCenterHollow(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCenterHollow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCenterHollow(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCenterHollow(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LeftInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().LeftInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LeftInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LeftInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LeftInsetScale(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().LeftInsetScale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LeftInsetScale(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LeftInsetScale(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RightInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RightInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RightInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RightInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RightInsetScale(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RightInsetScale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RightInsetScale(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RightInsetScale(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Source(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().Source());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Source(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Source(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TopInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TopInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TopInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TopInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TopInsetScale(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TopInsetScale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TopInsetScale(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TopInsetScale(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetInsets(float inset) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetInsets(inset);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetInsetsWithValues(float left, float top, float right, float bottom) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetInsets(left, top, right, bottom);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetInsetScales(float scale) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetInsetScales(scale);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetInsetScalesWithValues(float left, float top, float right, float bottom) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetInsetScales(left, top, right, bottom);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObject> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObject>
    {
        int32_t __stdcall get_Compositor(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Compositor>(this->shim().Compositor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Dispatcher(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Core::CoreDispatcher>(this->shim().Dispatcher());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionPropertySet>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAnimation(void* propertyName, void* animation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartAnimation(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionAnimation const*>(&animation));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StopAnimation(void* propertyName) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StopAnimation(*reinterpret_cast<hstring const*>(&propertyName));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObject2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObject2>
    {
        int32_t __stdcall get_Comment(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Comment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Comment(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Comment(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ImplicitAnimations(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::ImplicitAnimationCollection>(this->shim().ImplicitAnimations());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ImplicitAnimations(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ImplicitAnimations(*reinterpret_cast<winrt::Windows::UI::Composition::ImplicitAnimationCollection const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAnimationGroup(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartAnimationGroup(*reinterpret_cast<winrt::Windows::UI::Composition::ICompositionAnimationBase const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StopAnimationGroup(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StopAnimationGroup(*reinterpret_cast<winrt::Windows::UI::Composition::ICompositionAnimationBase const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObject3> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObject3>
    {
        int32_t __stdcall get_DispatcherQueue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::System::DispatcherQueue>(this->shim().DispatcherQueue());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObject4> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObject4>
    {
        int32_t __stdcall TryGetAnimationController(void* propertyName, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::AnimationController>(this->shim().TryGetAnimationController(*reinterpret_cast<hstring const*>(&propertyName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObject5> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObject5>
    {
        int32_t __stdcall StartAnimationWithController(void* propertyName, void* animation, void* animationController) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartAnimation(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionAnimation const*>(&animation), *reinterpret_cast<winrt::Windows::UI::Composition::AnimationController const*>(&animationController));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObjectFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObjectFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionObjectStatics> : produce_base<D, winrt::Windows::UI::Composition::ICompositionObjectStatics>
    {
        int32_t __stdcall StartAnimationWithIAnimationObject(void* target, void* propertyName, void* animation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartAnimationWithIAnimationObject(*reinterpret_cast<winrt::Windows::UI::Composition::IAnimationObject const*>(&target), *reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionAnimation const*>(&animation));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAnimationGroupWithIAnimationObject(void* target, void* animation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartAnimationGroupWithIAnimationObject(*reinterpret_cast<winrt::Windows::UI::Composition::IAnimationObject const*>(&target), *reinterpret_cast<winrt::Windows::UI::Composition::ICompositionAnimationBase const*>(&animation));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionPath> : produce_base<D, winrt::Windows::UI::Composition::ICompositionPath>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionPathFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionPathFactory>
    {
        int32_t __stdcall Create(void* source, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionPath>(this->shim().Create(*reinterpret_cast<winrt::Windows::Graphics::IGeometrySource2D const*>(&source)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionPathGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionPathGeometry>
    {
        int32_t __stdcall get_Path(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionPath>(this->shim().Path());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Path(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Path(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionPath const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadow>
    {
        int32_t __stdcall get_BlurRadiusMultiplier(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().BlurRadiusMultiplier());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BlurRadiusMultiplier(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BlurRadiusMultiplier(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Casters(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionProjectedShadowCasterCollection>(this->shim().Casters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LightSource(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionLight>(this->shim().LightSource());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LightSource(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LightSource(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionLight const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxBlurRadius(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MaxBlurRadius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MaxBlurRadius(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MaxBlurRadius(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinBlurRadius(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MinBlurRadius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MinBlurRadius(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MinBlurRadius(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Receivers(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionProjectedShadowReceiverUnorderedCollection>(this->shim().Receivers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCaster>
    {
        int32_t __stdcall get_Brush(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().Brush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Brush(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Brush(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CastingVisual(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Visual>(this->shim().CastingVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CastingVisual(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CastingVisual(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollection>
    {
        int32_t __stdcall get_Count(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Count());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertAbove(void* newCaster, void* reference) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertAbove(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&newCaster), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&reference));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertAtBottom(void* newCaster) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertAtBottom(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&newCaster));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertAtTop(void* newCaster) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertAtTop(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&newCaster));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertBelow(void* newCaster, void* reference) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertBelow(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&newCaster), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&reference));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Remove(void* caster) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Remove(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster const*>(&caster));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveAll() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveAll();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowCasterCollectionStatics>
    {
        int32_t __stdcall get_MaxRespectedCasters(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MaxRespectedCasters());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiver>
    {
        int32_t __stdcall get_ReceivingVisual(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Visual>(this->shim().ReceivingVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ReceivingVisual(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReceivingVisual(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection> : produce_base<D, winrt::Windows::UI::Composition::ICompositionProjectedShadowReceiverUnorderedCollection>
    {
        int32_t __stdcall Add(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Add(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Count(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Count());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Remove(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Remove(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveAll() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveAll();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionPropertySet> : produce_base<D, winrt::Windows::UI::Composition::ICompositionPropertySet>
    {
        int32_t __stdcall InsertColor(void* propertyName, struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertColor(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertMatrix3x2(void* propertyName, winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertMatrix3x2(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertMatrix4x4(void* propertyName, winrt::Windows::Foundation::Numerics::float4x4 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertMatrix4x4(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4x4 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertQuaternion(void* propertyName, winrt::Windows::Foundation::Numerics::quaternion value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertQuaternion(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertScalar(void* propertyName, float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertScalar(*reinterpret_cast<hstring const*>(&propertyName), value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertVector2(void* propertyName, winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertVector2(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertVector3(void* propertyName, winrt::Windows::Foundation::Numerics::float3 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertVector3(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertVector4(void* propertyName, winrt::Windows::Foundation::Numerics::float4 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertVector4(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetColor(void* propertyName, struct struct_Windows_UI_Color* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetColor(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::UI::Color*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetMatrix3x2(void* propertyName, winrt::Windows::Foundation::Numerics::float3x2* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3x2>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetMatrix3x2(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetMatrix4x4(void* propertyName, winrt::Windows::Foundation::Numerics::float4x4* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float4x4>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetMatrix4x4(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4x4*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetQuaternion(void* propertyName, winrt::Windows::Foundation::Numerics::quaternion* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::quaternion>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetQuaternion(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::quaternion*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetScalar(void* propertyName, float* value, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetScalar(*reinterpret_cast<hstring const*>(&propertyName), *value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetVector2(void* propertyName, winrt::Windows::Foundation::Numerics::float2* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetVector2(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetVector3(void* propertyName, winrt::Windows::Foundation::Numerics::float3* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetVector3(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float3*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetVector4(void* propertyName, winrt::Windows::Foundation::Numerics::float4* value, int32_t* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float4>(value);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetVector4(*reinterpret_cast<hstring const*>(&propertyName), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float4*>(value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionPropertySet2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionPropertySet2>
    {
        int32_t __stdcall InsertBoolean(void* propertyName, bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertBoolean(*reinterpret_cast<hstring const*>(&propertyName), value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetBoolean(void* propertyName, bool* value, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGetValueStatus>(this->shim().TryGetBoolean(*reinterpret_cast<hstring const*>(&propertyName), *value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionRadialGradientBrush>
    {
        int32_t __stdcall get_EllipseCenter(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().EllipseCenter());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EllipseCenter(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EllipseCenter(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EllipseRadius(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().EllipseRadius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EllipseRadius(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EllipseRadius(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_GradientOriginOffset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().GradientOriginOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_GradientOriginOffset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().GradientOriginOffset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionRectangleGeometry>
    {
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Size(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Size(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Size(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry> : produce_base<D, winrt::Windows::UI::Composition::ICompositionRoundedRectangleGeometry>
    {
        int32_t __stdcall get_CornerRadius(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().CornerRadius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CornerRadius(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CornerRadius(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Size(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Size(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Size(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionScopedBatch> : produce_base<D, winrt::Windows::UI::Composition::ICompositionScopedBatch>
    {
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnded(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnded());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall End() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().End();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Resume() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resume();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Suspend() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Suspend();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Completed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Completed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Foundation::IInspectable, winrt::Windows::UI::Composition::CompositionBatchCompletedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Completed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Completed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionShadow> : produce_base<D, winrt::Windows::UI::Composition::ICompositionShadow>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionShadowFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionShadowFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionShape> : produce_base<D, winrt::Windows::UI::Composition::ICompositionShape>
    {
        int32_t __stdcall get_CenterPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().CenterPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CenterPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CenterPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngle(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngle(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngle(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngleInDegrees(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngleInDegrees());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngleInDegrees(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngleInDegrees(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Scale(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Scale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Scale(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scale(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3x2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3x2>(this->shim().TransformMatrix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransformMatrix(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionShapeFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionShapeFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSpriteShape> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSpriteShape>
    {
        int32_t __stdcall get_FillBrush(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().FillBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FillBrush(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FillBrush(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Geometry(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionGeometry>(this->shim().Geometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Geometry(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Geometry(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionGeometry const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStrokeNonScaling(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStrokeNonScaling());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsStrokeNonScaling(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsStrokeNonScaling(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeBrush(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().StrokeBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeBrush(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeBrush(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeDashArray(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStrokeDashArray>(this->shim().StrokeDashArray());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeDashCap(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStrokeCap>(this->shim().StrokeDashCap());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeDashCap(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeDashCap(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStrokeCap const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeDashOffset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().StrokeDashOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeDashOffset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeDashOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeEndCap(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStrokeCap>(this->shim().StrokeEndCap());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeEndCap(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeEndCap(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStrokeCap const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeLineJoin(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStrokeLineJoin>(this->shim().StrokeLineJoin());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeLineJoin(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeLineJoin(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStrokeLineJoin const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeMiterLimit(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().StrokeMiterLimit());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeMiterLimit(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeMiterLimit(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeStartCap(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStrokeCap>(this->shim().StrokeStartCap());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeStartCap(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeStartCap(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStrokeCap const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StrokeThickness(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().StrokeThickness());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StrokeThickness(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StrokeThickness(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSupportsSystemBackdrop>
    {
        int32_t __stdcall get_SystemBackdrop(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().SystemBackdrop());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SystemBackdrop(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SystemBackdrop(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSurface>
    {
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush>
    {
        int32_t __stdcall get_BitmapInterpolationMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBitmapInterpolationMode>(this->shim().BitmapInterpolationMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BitmapInterpolationMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BitmapInterpolationMode(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBitmapInterpolationMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalAlignmentRatio(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().HorizontalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalAlignmentRatio(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Stretch(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStretch>(this->shim().Stretch());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Stretch(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Stretch(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStretch const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Surface(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::ICompositionSurface>(this->shim().Surface());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Surface(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Surface(*reinterpret_cast<winrt::Windows::UI::Composition::ICompositionSurface const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalAlignmentRatio(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().VerticalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalAlignmentRatio(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush2>
    {
        int32_t __stdcall get_AnchorPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().AnchorPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AnchorPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AnchorPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CenterPoint(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().CenterPoint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CenterPoint(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CenterPoint(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngle(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngle(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngle(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotationAngleInDegrees(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RotationAngleInDegrees());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RotationAngleInDegrees(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RotationAngleInDegrees(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Scale(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Scale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Scale(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Scale(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3x2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3x2>(this->shim().TransformMatrix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransformMatrix(winrt::Windows::Foundation::Numerics::float3x2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransformMatrix(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3x2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush3> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSurfaceBrush3>
    {
        int32_t __stdcall get_SnapToPixels(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().SnapToPixels());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SnapToPixels(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SnapToPixels(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionSurfaceFacade> : produce_base<D, winrt::Windows::UI::Composition::ICompositionSurfaceFacade>
    {
        int32_t __stdcall GetRealSurface(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ICompositionSurface>(this->shim().GetRealSurface());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTarget> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTarget>
    {
        int32_t __stdcall get_Root(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Visual>(this->shim().Root());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Root(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Root(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTargetFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTargetFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTexture> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTexture>
    {
        int32_t __stdcall get_SourceRect(struct struct_Windows_Graphics_RectInt32* value) noexcept final try
        {
            zero_abi<winrt::Windows::Graphics::RectInt32>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::RectInt32>(this->shim().SourceRect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SourceRect(struct struct_Windows_Graphics_RectInt32 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SourceRect(*reinterpret_cast<winrt::Windows::Graphics::RectInt32 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AlphaMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXAlphaMode>(this->shim().AlphaMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AlphaMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AlphaMode(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXAlphaMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ColorSpace(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXColorSpace>(this->shim().ColorSpace());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ColorSpace(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ColorSpace(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXColorSpace const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTextureFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTextureFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTransform> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTransform>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionTransformFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionTransformFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionViewBox> : produce_base<D, winrt::Windows::UI::Composition::ICompositionViewBox>
    {
        int32_t __stdcall get_HorizontalAlignmentRatio(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().HorizontalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalAlignmentRatio(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Size(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().Size());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Size(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Size(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Stretch(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionStretch>(this->shim().Stretch());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Stretch(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Stretch(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionStretch const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalAlignmentRatio(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().VerticalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalAlignmentRatio(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurface>
    {
        int32_t __stdcall Trim(uint32_t __rectsSize, struct struct_Windows_Graphics_RectInt32* rects) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Trim(array_view<winrt::Windows::Graphics::RectInt32 const>(reinterpret_cast<winrt::Windows::Graphics::RectInt32 const *>(rects), reinterpret_cast<winrt::Windows::Graphics::RectInt32 const *>(rects) + __rectsSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurfaceFactory> : produce_base<D, winrt::Windows::UI::Composition::ICompositionVirtualDrawingSurfaceFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositionVisualSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositionVisualSurface>
    {
        int32_t __stdcall get_SourceVisual(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Visual>(this->shim().SourceVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SourceVisual(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SourceVisual(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SourceOffset(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().SourceOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SourceOffset(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SourceOffset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SourceSize(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().SourceSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SourceSize(winrt::Windows::Foundation::Numerics::float2 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SourceSize(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor> : produce_base<D, winrt::Windows::UI::Composition::ICompositor>
    {
        int32_t __stdcall CreateColorKeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ColorKeyFrameAnimation>(this->shim().CreateColorKeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateColorBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionColorBrush>(this->shim().CreateColorBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateColorBrushWithColor(struct struct_Windows_UI_Color color, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionColorBrush>(this->shim().CreateColorBrush(*reinterpret_cast<winrt::Windows::UI::Color const*>(&color)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateContainerVisual(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ContainerVisual>(this->shim().CreateContainerVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateCubicBezierEasingFunction(winrt::Windows::Foundation::Numerics::float2 controlPoint1, winrt::Windows::Foundation::Numerics::float2 controlPoint2, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CubicBezierEasingFunction>(this->shim().CreateCubicBezierEasingFunction(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&controlPoint1), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&controlPoint2)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateEffectFactory(void* graphicsEffect, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionEffectFactory>(this->shim().CreateEffectFactory(*reinterpret_cast<winrt::Windows::Graphics::Effects::IGraphicsEffect const*>(&graphicsEffect)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateEffectFactoryWithProperties(void* graphicsEffect, void* animatableProperties, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionEffectFactory>(this->shim().CreateEffectFactory(*reinterpret_cast<winrt::Windows::Graphics::Effects::IGraphicsEffect const*>(&graphicsEffect), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&animatableProperties)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateExpressionAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ExpressionAnimation>(this->shim().CreateExpressionAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateExpressionAnimationWithExpression(void* expression, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ExpressionAnimation>(this->shim().CreateExpressionAnimation(*reinterpret_cast<hstring const*>(&expression)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateInsetClip(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::InsetClip>(this->shim().CreateInsetClip());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateInsetClipWithInsets(float leftInset, float topInset, float rightInset, float bottomInset, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::InsetClip>(this->shim().CreateInsetClip(leftInset, topInset, rightInset, bottomInset));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateLinearEasingFunction(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::LinearEasingFunction>(this->shim().CreateLinearEasingFunction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePropertySet(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionPropertySet>(this->shim().CreatePropertySet());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateQuaternionKeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::QuaternionKeyFrameAnimation>(this->shim().CreateQuaternionKeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateScalarKeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ScalarKeyFrameAnimation>(this->shim().CreateScalarKeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateScopedBatch(uint32_t batchType, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionScopedBatch>(this->shim().CreateScopedBatch(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBatchTypes const*>(&batchType)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpriteVisual(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SpriteVisual>(this->shim().CreateSpriteVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSurfaceBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionSurfaceBrush>(this->shim().CreateSurfaceBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSurfaceBrushWithSurface(void* surface, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionSurfaceBrush>(this->shim().CreateSurfaceBrush(*reinterpret_cast<winrt::Windows::UI::Composition::ICompositionSurface const*>(&surface)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateTargetForCurrentView(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionTarget>(this->shim().CreateTargetForCurrentView());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateVector2KeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::Vector2KeyFrameAnimation>(this->shim().CreateVector2KeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateVector3KeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::Vector3KeyFrameAnimation>(this->shim().CreateVector3KeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateVector4KeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::Vector4KeyFrameAnimation>(this->shim().CreateVector4KeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCommitBatch(uint32_t batchType, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionCommitBatch>(this->shim().GetCommitBatch(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBatchTypes const*>(&batchType)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor2> : produce_base<D, winrt::Windows::UI::Composition::ICompositor2>
    {
        int32_t __stdcall CreateAmbientLight(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::AmbientLight>(this->shim().CreateAmbientLight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateAnimationGroup(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionAnimationGroup>(this->shim().CreateAnimationGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBackdropBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionBackdropBrush>(this->shim().CreateBackdropBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateDistantLight(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::DistantLight>(this->shim().CreateDistantLight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateDropShadow(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::DropShadow>(this->shim().CreateDropShadow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateImplicitAnimationCollection(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ImplicitAnimationCollection>(this->shim().CreateImplicitAnimationCollection());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateLayerVisual(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::LayerVisual>(this->shim().CreateLayerVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateMaskBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionMaskBrush>(this->shim().CreateMaskBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateNineGridBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionNineGridBrush>(this->shim().CreateNineGridBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePointLight(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::PointLight>(this->shim().CreatePointLight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpotLight(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SpotLight>(this->shim().CreateSpotLight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStepEasingFunction(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::StepEasingFunction>(this->shim().CreateStepEasingFunction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStepEasingFunctionWithStepCount(int32_t stepCount, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::StepEasingFunction>(this->shim().CreateStepEasingFunction(stepCount));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor3> : produce_base<D, winrt::Windows::UI::Composition::ICompositor3>
    {
        int32_t __stdcall CreateHostBackdropBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionBackdropBrush>(this->shim().CreateHostBackdropBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor4> : produce_base<D, winrt::Windows::UI::Composition::ICompositor4>
    {
        int32_t __stdcall CreateColorGradientStop(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionColorGradientStop>(this->shim().CreateColorGradientStop());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateColorGradientStopWithOffsetAndColor(float offset, struct struct_Windows_UI_Color color, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionColorGradientStop>(this->shim().CreateColorGradientStop(offset, *reinterpret_cast<winrt::Windows::UI::Color const*>(&color)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateLinearGradientBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionLinearGradientBrush>(this->shim().CreateLinearGradientBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpringScalarAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SpringScalarNaturalMotionAnimation>(this->shim().CreateSpringScalarAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpringVector2Animation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SpringVector2NaturalMotionAnimation>(this->shim().CreateSpringVector2Animation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpringVector3Animation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::SpringVector3NaturalMotionAnimation>(this->shim().CreateSpringVector3Animation());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor5> : produce_base<D, winrt::Windows::UI::Composition::ICompositor5>
    {
        int32_t __stdcall get_Comment(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Comment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Comment(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Comment(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_GlobalPlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().GlobalPlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_GlobalPlaybackRate(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().GlobalPlaybackRate(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBounceScalarAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BounceScalarNaturalMotionAnimation>(this->shim().CreateBounceScalarAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBounceVector2Animation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BounceVector2NaturalMotionAnimation>(this->shim().CreateBounceVector2Animation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBounceVector3Animation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BounceVector3NaturalMotionAnimation>(this->shim().CreateBounceVector3Animation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateContainerShape(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionContainerShape>(this->shim().CreateContainerShape());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateEllipseGeometry(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionEllipseGeometry>(this->shim().CreateEllipseGeometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateLineGeometry(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionLineGeometry>(this->shim().CreateLineGeometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePathGeometry(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionPathGeometry>(this->shim().CreatePathGeometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePathGeometryWithPath(void* path, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionPathGeometry>(this->shim().CreatePathGeometry(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionPath const*>(&path)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreatePathKeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::PathKeyFrameAnimation>(this->shim().CreatePathKeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRectangleGeometry(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionRectangleGeometry>(this->shim().CreateRectangleGeometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRoundedRectangleGeometry(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionRoundedRectangleGeometry>(this->shim().CreateRoundedRectangleGeometry());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateShapeVisual(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::ShapeVisual>(this->shim().CreateShapeVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpriteShape(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionSpriteShape>(this->shim().CreateSpriteShape());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateSpriteShapeWithGeometry(void* geometry, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionSpriteShape>(this->shim().CreateSpriteShape(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionGeometry const*>(&geometry)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateViewBox(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionViewBox>(this->shim().CreateViewBox());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestCommitAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().RequestCommitAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor6> : produce_base<D, winrt::Windows::UI::Composition::ICompositor6>
    {
        int32_t __stdcall CreateGeometricClip(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGeometricClip>(this->shim().CreateGeometricClip());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateGeometricClipWithGeometry(void* geometry, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionGeometricClip>(this->shim().CreateGeometricClip(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionGeometry const*>(&geometry)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRedirectVisual(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::RedirectVisual>(this->shim().CreateRedirectVisual());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRedirectVisualWithSourceVisual(void* source, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::RedirectVisual>(this->shim().CreateRedirectVisual(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&source)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateBooleanKeyFrameAnimation(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::BooleanKeyFrameAnimation>(this->shim().CreateBooleanKeyFrameAnimation());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor7> : produce_base<D, winrt::Windows::UI::Composition::ICompositor7>
    {
        int32_t __stdcall get_DispatcherQueue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::System::DispatcherQueue>(this->shim().DispatcherQueue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateAnimationPropertyInfo(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::AnimationPropertyInfo>(this->shim().CreateAnimationPropertyInfo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRectangleClip(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::RectangleClip>(this->shim().CreateRectangleClip());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRectangleClipWithSides(float left, float top, float right, float bottom, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::RectangleClip>(this->shim().CreateRectangleClip(left, top, right, bottom));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateRectangleClipWithSidesAndRadius(float left, float top, float right, float bottom, winrt::Windows::Foundation::Numerics::float2 topLeftRadius, winrt::Windows::Foundation::Numerics::float2 topRightRadius, winrt::Windows::Foundation::Numerics::float2 bottomRightRadius, winrt::Windows::Foundation::Numerics::float2 bottomLeftRadius, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::RectangleClip>(this->shim().CreateRectangleClip(left, top, right, bottom, *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&topLeftRadius), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&topRightRadius), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&bottomRightRadius), *reinterpret_cast<winrt::Windows::Foundation::Numerics::float2 const*>(&bottomLeftRadius)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositor8> : produce_base<D, winrt::Windows::UI::Composition::ICompositor8>
    {
        int32_t __stdcall CreateAnimationController(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::AnimationController>(this->shim().CreateAnimationController());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositorStatics> : produce_base<D, winrt::Windows::UI::Composition::ICompositorStatics>
    {
        int32_t __stdcall get_MaxGlobalPlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MaxGlobalPlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinGlobalPlaybackRate(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().MinGlobalPlaybackRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush> : produce_base<D, winrt::Windows::UI::Composition::ICompositorWithBlurredWallpaperBackdropBrush>
    {
        int32_t __stdcall TryCreateBlurredWallpaperBackdropBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionBackdropBrush>(this->shim().TryCreateBlurredWallpaperBackdropBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositorWithProjectedShadow> : produce_base<D, winrt::Windows::UI::Composition::ICompositorWithProjectedShadow>
    {
        int32_t __stdcall CreateProjectedShadowCaster(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionProjectedShadowCaster>(this->shim().CreateProjectedShadowCaster());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateProjectedShadow(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionProjectedShadow>(this->shim().CreateProjectedShadow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateProjectedShadowReceiver(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionProjectedShadowReceiver>(this->shim().CreateProjectedShadowReceiver());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositorWithRadialGradient> : produce_base<D, winrt::Windows::UI::Composition::ICompositorWithRadialGradient>
    {
        int32_t __stdcall CreateRadialGradientBrush(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionRadialGradientBrush>(this->shim().CreateRadialGradientBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICompositorWithVisualSurface> : produce_base<D, winrt::Windows::UI::Composition::ICompositorWithVisualSurface>
    {
        int32_t __stdcall CreateVisualSurface(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::CompositionVisualSurface>(this->shim().CreateVisualSurface());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IContainerVisual> : produce_base<D, winrt::Windows::UI::Composition::IContainerVisual>
    {
        int32_t __stdcall get_Children(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::VisualCollection>(this->shim().Children());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IContainerVisualFactory> : produce_base<D, winrt::Windows::UI::Composition::IContainerVisualFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ICubicBezierEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::ICubicBezierEasingFunction>
    {
        int32_t __stdcall get_ControlPoint1(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().ControlPoint1());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ControlPoint2(winrt::Windows::Foundation::Numerics::float2* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float2>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float2>(this->shim().ControlPoint2());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual> : produce_base<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisual>
    {
        int32_t __stdcall AddTrailPoints(uint32_t __inkPointsSize, struct struct_Windows_UI_Composition_InkTrailPoint* inkPoints, uint32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<uint32_t>(this->shim().AddTrailPoints(array_view<winrt::Windows::UI::Composition::InkTrailPoint const>(reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(inkPoints), reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(inkPoints) + __inkPointsSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AddTrailPointsWithPrediction(uint32_t __inkPointsSize, struct struct_Windows_UI_Composition_InkTrailPoint* inkPoints, uint32_t __predictedInkPointsSize, struct struct_Windows_UI_Composition_InkTrailPoint* predictedInkPoints, uint32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<uint32_t>(this->shim().AddTrailPointsWithPrediction(array_view<winrt::Windows::UI::Composition::InkTrailPoint const>(reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(inkPoints), reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(inkPoints) + __inkPointsSize), array_view<winrt::Windows::UI::Composition::InkTrailPoint const>(reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(predictedInkPoints), reinterpret_cast<winrt::Windows::UI::Composition::InkTrailPoint const *>(predictedInkPoints) + __predictedInkPointsSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveTrailPoints(uint32_t generationId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveTrailPoints(generationId);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartNewTrail(struct struct_Windows_UI_Color color) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartNewTrail(*reinterpret_cast<winrt::Windows::UI::Color const*>(&color));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics> : produce_base<D, winrt::Windows::UI::Composition::IDelegatedInkTrailVisualStatics>
    {
        int32_t __stdcall Create(void* compositor, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::DelegatedInkTrailVisual>(this->shim().Create(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&compositor)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateForSwapChain(void* compositor, void* swapChain, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Composition::DelegatedInkTrailVisual>(this->shim().CreateForSwapChain(*reinterpret_cast<winrt::Windows::UI::Composition::Compositor const*>(&compositor), *reinterpret_cast<winrt::Windows::UI::Composition::ICompositionSurface const*>(&swapChain)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDistantLight> : produce_base<D, winrt::Windows::UI::Composition::IDistantLight>
    {
        int32_t __stdcall get_Color(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().Color());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Color(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Color(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CoordinateSpace(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::Visual>(this->shim().CoordinateSpace());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CoordinateSpace(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CoordinateSpace(*reinterpret_cast<winrt::Windows::UI::Composition::Visual const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Direction(winrt::Windows::Foundation::Numerics::float3* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3>(this->shim().Direction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Direction(winrt::Windows::Foundation::Numerics::float3 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Direction(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDistantLight2> : produce_base<D, winrt::Windows::UI::Composition::IDistantLight2>
    {
        int32_t __stdcall get_Intensity(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Intensity());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Intensity(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Intensity(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDropShadow> : produce_base<D, winrt::Windows::UI::Composition::IDropShadow>
    {
        int32_t __stdcall get_BlurRadius(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().BlurRadius());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BlurRadius(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BlurRadius(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Color(struct struct_Windows_UI_Color* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Color>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Color>(this->shim().Color());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Color(struct struct_Windows_UI_Color value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Color(*reinterpret_cast<winrt::Windows::UI::Color const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Mask(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionBrush>(this->shim().Mask());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mask(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mask(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Offset(winrt::Windows::Foundation::Numerics::float3* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3>(this->shim().Offset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Offset(winrt::Windows::Foundation::Numerics::float3 value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Offset(*reinterpret_cast<winrt::Windows::Foundation::Numerics::float3 const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Opacity(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Opacity());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Opacity(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Opacity(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IDropShadow2> : produce_base<D, winrt::Windows::UI::Composition::IDropShadow2>
    {
        int32_t __stdcall get_SourcePolicy(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionDropShadowSourcePolicy>(this->shim().SourcePolicy());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SourcePolicy(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SourcePolicy(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionDropShadowSourcePolicy const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IElasticEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::IElasticEasingFunction>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEasingFunctionMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Oscillations(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Oscillations());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Springiness(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Springiness());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IExponentialEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::IExponentialEasingFunction>
    {
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEasingFunctionMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Exponent(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().Exponent());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IExpressionAnimation> : produce_base<D, winrt::Windows::UI::Composition::IExpressionAnimation>
    {
        int32_t __stdcall get_Expression(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Expression());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Expression(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Expression(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IImplicitAnimationCollection> : produce_base<D, winrt::Windows::UI::Composition::IImplicitAnimationCollection>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IInsetClip> : produce_base<D, winrt::Windows::UI::Composition::IInsetClip>
    {
        int32_t __stdcall get_BottomInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().BottomInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BottomInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BottomInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LeftInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().LeftInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LeftInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LeftInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RightInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().RightInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RightInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RightInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TopInset(float* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<float>(this->shim().TopInset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TopInset(float value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TopInset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IKeyFrameAnimation> : produce_base<D, winrt::Windows::UI::Composition::IKeyFrameAnimation>
    {
        int32_t __stdcall get_DelayTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().DelayTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DelayTime(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DelayTime(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Duration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Duration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Duration(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Duration(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IterationBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationIterationBehavior>(this->shim().IterationBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IterationBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IterationBehavior(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationIterationBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IterationCount(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().IterationCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IterationCount(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IterationCount(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_KeyFrameCount(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().KeyFrameCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StopBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationStopBehavior>(this->shim().StopBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StopBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StopBehavior(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationStopBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertExpressionKeyFrame(float normalizedProgressKey, void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertExpressionKeyFrame(normalizedProgressKey, *reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertExpressionKeyFrameWithEasingFunction(float normalizedProgressKey, void* value, void* easingFunction) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InsertExpressionKeyFrame(normalizedProgressKey, *reinterpret_cast<hstring const*>(&value), *reinterpret_cast<winrt::Windows::UI::Composition::CompositionEasingFunction const*>(&easingFunction));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IKeyFrameAnimation2> : produce_base<D, winrt::Windows::UI::Composition::IKeyFrameAnimation2>
    {
        int32_t __stdcall get_Direction(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationDirection>(this->shim().Direction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Direction(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Direction(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationDirection const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IKeyFrameAnimation3> : produce_base<D, winrt::Windows::UI::Composition::IKeyFrameAnimation3>
    {
        int32_t __stdcall get_DelayBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationDelayBehavior>(this->shim().DelayBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DelayBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DelayBehavior(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationDelayBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::IKeyFrameAnimationFactory> : produce_base<D, winrt::Windows::UI::Composition::IKeyFrameAnimationFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ILayerVisual> : produce_base<D, winrt::Windows::UI::Composition::ILayerVisual>
    {
        int32_t __stdcall get_Effect(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionEffectBrush>(this->shim().Effect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Effect(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Effect(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionEffectBrush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ILayerVisual2> : produce_base<D, winrt::Windows::UI::Composition::ILayerVisual2>
    {
        int32_t __stdcall get_Shadow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::CompositionShadow>(this->shim().Shadow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Shadow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Shadow(*reinterpret_cast<winrt::Windows::UI::Composition::CompositionShadow const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::ILinearEasingFunction> : produce_base<D, winrt::Windows::UI::Composition::ILinearEasingFunction>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Composition::INaturalMotionAnimation> : produce_base<D, winrt::Windows::UI::Composition::INaturalMotionAnimation>
    {
        int32_t __stdcall get_DelayBehavior(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Composition::AnimationDelayBehavior>(this->shim().DelayBehavior());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DelayBehavior(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DelayBehavior(*reinterpret_cast<winrt::Windows::UI::Composition::AnimationDelayBehavior const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DelayTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().DelayTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DelayTime(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DelayTime(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { retur