; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -verify-machineinstrs -mattr=+neon | FileCheck %s --check-prefixes=CHECK,CHECK-NEON
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -verify-machineinstrs -mattr=-neon | FileCheck %s --check-prefixes=CHECK,CHECK-SCALAR

; Check that big fp constants can be rematerialized with movi
target triple = "aarch64-unknown-linux-gnu"

; float foo(void) { return float(2147483648); }
define float @foo() {
; CHECK-LABEL: foo:
; CHECK:       // %bb.0: // %entry
; CHECK-NEON-NEXT:    movi v0.2s, #79, lsl #24
; CHECK-SCALAR-NEXT:    mov w8, #1325400064
; CHECK-SCALAR-NEXT:    fmov s0, w8
; CHECK-NEXT:    ret
entry:
 ret float 0x41E0000000000000
}

; float foo2(float p) { return p + float(2147483648); }
define float @foo2(float %f) {
; CHECK-LABEL: foo2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEON-NEXT:    movi v1.2s, #79, lsl #24
; CHECK-NEON-NEXT:    fadd s0, s0, s1
; CHECK-SCALAR-NEXT:    mov w8, #1325400064
; CHECK-SCALAR-NEXT:    fmov s1, w8
; CHECK-SCALAR-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
entry:
  %p = fadd float %f, 0x41E0000000000000
  ret float %p
}
