; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=+neon | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=+neon -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

declare i1 @llvm.vector.reduce.umax.v1i1(<1 x i1> %a)
declare i8 @llvm.vector.reduce.umax.v1i8(<1 x i8> %a)
declare i16 @llvm.vector.reduce.umax.v1i16(<1 x i16> %a)
declare i24 @llvm.vector.reduce.umax.v1i24(<1 x i24> %a)
declare i32 @llvm.vector.reduce.umax.v1i32(<1 x i32> %a)
declare i64 @llvm.vector.reduce.umax.v1i64(<1 x i64> %a)
declare i128 @llvm.vector.reduce.umax.v1i128(<1 x i128> %a)

declare i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> %a)
declare i8 @llvm.vector.reduce.umax.v3i8(<3 x i8> %a)
declare i8 @llvm.vector.reduce.umax.v9i8(<9 x i8> %a)
declare i32 @llvm.vector.reduce.umax.v3i32(<3 x i32> %a)
declare i1 @llvm.vector.reduce.umax.v4i1(<4 x i1> %a)
declare i24 @llvm.vector.reduce.umax.v4i24(<4 x i24> %a)
declare i128 @llvm.vector.reduce.umax.v2i128(<2 x i128> %a)
declare i32 @llvm.vector.reduce.umax.v16i32(<16 x i32> %a)

define i1 @test_v1i1(<1 x i1> %a) nounwind {
; CHECK-LABEL: test_v1i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w0, w0, #0x1
; CHECK-NEXT:    ret
  %b = call i1 @llvm.vector.reduce.umax.v1i1(<1 x i1> %a)
  ret i1 %b
}

define i8 @test_v1i8(<1 x i8> %a) nounwind {
; CHECK-LABEL: test_v1i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.b[0]
; CHECK-NEXT:    ret
  %b = call i8 @llvm.vector.reduce.umax.v1i8(<1 x i8> %a)
  ret i8 %b
}

define i16 @test_v1i16(<1 x i16> %a) nounwind {
; CHECK-LABEL: test_v1i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    ret
  %b = call i16 @llvm.vector.reduce.umax.v1i16(<1 x i16> %a)
  ret i16 %b
}

define i24 @test_v1i24(<1 x i24> %a) nounwind {
; CHECK-LABEL: test_v1i24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = call i24 @llvm.vector.reduce.umax.v1i24(<1 x i24> %a)
  ret i24 %b
}

define i32 @test_v1i32(<1 x i32> %a) nounwind {
; CHECK-SD-LABEL: test_v1i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v1i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
  %b = call i32 @llvm.vector.reduce.umax.v1i32(<1 x i32> %a)
  ret i32 %b
}

define i64 @test_v1i64(<1 x i64> %a) nounwind {
; CHECK-SD-LABEL: test_v1i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    fmov x0, d0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v1i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    ret
  %b = call i64 @llvm.vector.reduce.umax.v1i64(<1 x i64> %a)
  ret i64 %b
}

define i128 @test_v1i128(<1 x i128> %a) nounwind {
; CHECK-LABEL: test_v1i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = call i128 @llvm.vector.reduce.umax.v1i128(<1 x i128> %a)
  ret i128 %b
}

; No i64 vector support for UMAX.
define i64 @test_v2i64(<2 x i64> %a) nounwind {
; CHECK-SD-LABEL: test_v2i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    cmhi d2, d0, d1
; CHECK-SD-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    fmov x0, d0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v2i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    fcsel d0, d0, d1, hi
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    ret
  %b = call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> %a)
  ret i64 %b
}

define i8 @test_v3i8(<3 x i8> %a) nounwind {
; CHECK-SD-LABEL: test_v3i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v0.2d, #0000000000000000
; CHECK-SD-NEXT:    mov v0.h[0], w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    umaxv h0, v0.4h
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v3i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0xff
; CHECK-GI-NEXT:    cmp w8, w1, uxtb
; CHECK-GI-NEXT:    csel w8, w0, w1, hi
; CHECK-GI-NEXT:    and w9, w8, #0xff
; CHECK-GI-NEXT:    cmp w9, w2, uxtb
; CHECK-GI-NEXT:    csel w0, w8, w2, hi
; CHECK-GI-NEXT:    ret
  %b = call i8 @llvm.vector.reduce.umax.v3i8(<3 x i8> %a)
  ret i8 %b
}

define i8 @test_v9i8(<9 x i8> %a) nounwind {
; CHECK-SD-LABEL: test_v9i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI9_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI9_0]
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    umaxv b0, v0.16b
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v9i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov b1, v0.b[1]
; CHECK-GI-NEXT:    umov w8, v0.b[0]
; CHECK-GI-NEXT:    umov w9, v0.b[1]
; CHECK-GI-NEXT:    umov w10, v0.b[2]
; CHECK-GI-NEXT:    fmov w11, s1
; CHECK-GI-NEXT:    cmp w8, w11, uxtb
; CHECK-GI-NEXT:    umov w11, v0.b[3]
; CHECK-GI-NEXT:    csel w8, w8, w9, hi
; CHECK-GI-NEXT:    umov w9, v0.b[4]
; CHECK-GI-NEXT:    cmp w10, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w10, lo
; CHECK-GI-NEXT:    umov w10, v0.b[5]
; CHECK-GI-NEXT:    cmp w11, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w11, lo
; CHECK-GI-NEXT:    umov w11, v0.b[6]
; CHECK-GI-NEXT:    cmp w9, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w9, lo
; CHECK-GI-NEXT:    umov w9, v0.b[7]
; CHECK-GI-NEXT:    cmp w10, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w10, lo
; CHECK-GI-NEXT:    umov w10, v0.b[8]
; CHECK-GI-NEXT:    cmp w11, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w11, lo
; CHECK-GI-NEXT:    cmp w9, w8, uxtb
; CHECK-GI-NEXT:    csel w8, w8, w9, lo
; CHECK-GI-NEXT:    cmp w10, w8, uxtb
; CHECK-GI-NEXT:    csel w0, w8, w10, lo
; CHECK-GI-NEXT:    ret
  %b = call i8 @llvm.vector.reduce.umax.v9i8(<9 x i8> %a)
  ret i8 %b
}

define i32 @test_v3i32(<3 x i32> %a) nounwind {
; CHECK-LABEL: test_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.s[3], wzr
; CHECK-NEXT:    umaxv s0, v0.4s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %b = call i32 @llvm.vector.reduce.umax.v3i32(<3 x i32> %a)
  ret i32 %b
}

define i1 @test_v4i1(<4 x i1> %a) nounwind {
; CHECK-SD-LABEL: test_v4i1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #15
; CHECK-SD-NEXT:    cmlt v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    umaxv h0, v0.4h
; CHECK-SD-NEXT:    fmov w8, s0
; CHECK-SD-NEXT:    and w0, w8, #0x1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v4i1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    umov w8, v0.h[0]
; CHECK-GI-NEXT:    umov w9, v0.h[1]
; CHECK-GI-NEXT:    umov w10, v0.h[2]
; CHECK-GI-NEXT:    umov w11, v0.h[3]
; CHECK-GI-NEXT:    and w12, w8, #0x1
; CHECK-GI-NEXT:    and w13, w9, #0x1
; CHECK-GI-NEXT:    cmp w12, w13
; CHECK-GI-NEXT:    and w12, w10, #0x1
; CHECK-GI-NEXT:    and w13, w11, #0x1
; CHECK-GI-NEXT:    csel w8, w8, w9, hi
; CHECK-GI-NEXT:    cmp w12, w13
; CHECK-GI-NEXT:    csel w9, w10, w11, hi
; CHECK-GI-NEXT:    and w10, w8, #0x1
; CHECK-GI-NEXT:    and w11, w9, #0x1
; CHECK-GI-NEXT:    cmp w10, w11
; CHECK-GI-NEXT:    csel w8, w8, w9, hi
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
  %b = call i1 @llvm.vector.reduce.umax.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i24 @test_v4i24(<4 x i24> %a) nounwind {
; CHECK-SD-LABEL: test_v4i24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #24
; CHECK-SD-NEXT:    umaxv s0, v0.4s
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v4i24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov s2, v0.s[2]
; CHECK-GI-NEXT:    mov s3, v0.s[3]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    fmov w10, s2
; CHECK-GI-NEXT:    fmov w11, s3
; CHECK-GI-NEXT:    and w8, w8, #0xffffff
; CHECK-GI-NEXT:    and w9, w9, #0xffffff
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    and w8, w10, #0xffffff
; CHECK-GI-NEXT:    and w9, w11, #0xffffff
; CHECK-GI-NEXT:    fcsel s0, s0, s1, hi
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    fcsel s1, s2, s3, hi
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    and w8, w8, #0xffffff
; CHECK-GI-NEXT:    and w9, w9, #0xffffff
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    fcsel s0, s0, s1, hi
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
  %b = call i24 @llvm.vector.reduce.umax.v4i24(<4 x i24> %a)
  ret i24 %b
}

define i128 @test_v2i128(<2 x i128> %a) nounwind {
; CHECK-SD-LABEL: test_v2i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp x2, x0
; CHECK-SD-NEXT:    sbcs xzr, x3, x1
; CHECK-SD-NEXT:    csel x0, x0, x2, lo
; CHECK-SD-NEXT:    csel x1, x1, x3, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v2i128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w8, hi
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    cset w9, hi
; CHECK-GI-NEXT:    csel w8, w8, w9, eq
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel x0, x0, x2, ne
; CHECK-GI-NEXT:    csel x1, x1, x3, ne
; CHECK-GI-NEXT:    ret
  %b = call i128 @llvm.vector.reduce.umax.v2i128(<2 x i128> %a)
  ret i128 %b
}

define i32 @test_v16i32(<16 x i32> %a) nounwind {
; CHECK-SD-LABEL: test_v16i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    umax v1.4s, v1.4s, v3.4s
; CHECK-SD-NEXT:    umax v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    umax v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    umaxv s0, v0.4s
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_v16i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    umax v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    umax v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    umax v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    umaxv s0, v0.4s
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
  %b = call i32 @llvm.vector.reduce.umax.v16i32(<16 x i32> %a)
  ret i32 %b
}
