/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;

class TransformWorkspaceIdentity
implements UnitOfWork.Identity {
    private final ValueSnapshot secondaryInputsSnapshot;
    private final String uniqueId;

    private TransformWorkspaceIdentity(ValueSnapshot secondaryInputsSnapshot, HashCode uniqueId) {
        this.uniqueId = uniqueId.toString();
        this.secondaryInputsSnapshot = secondaryInputsSnapshot;
    }

    public ValueSnapshot getSecondaryInputsSnapshot() {
        return this.secondaryInputsSnapshot;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformWorkspaceIdentity that = (TransformWorkspaceIdentity)o;
        return this.uniqueId.equals(that.uniqueId);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public static TransformWorkspaceIdentity createMutable(String normalizedInputArtifactPath, String producerBuildTreePath, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.putString((CharSequence)normalizedInputArtifactPath);
        hasher.putString((CharSequence)producerBuildTreePath);
        hasher.put((Hashable)secondaryInputsSnapshot);
        hasher.putHash(dependenciesHash);
        return new TransformWorkspaceIdentity(secondaryInputsSnapshot, hasher.hash());
    }

    public static TransformWorkspaceIdentity createNonNormalizedImmutable(ValueSnapshot inputArtifactPath, HashCode inputArtifactSnapshot, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.put((Hashable)inputArtifactPath);
        hasher.putHash(inputArtifactSnapshot);
        hasher.put((Hashable)secondaryInputsSnapshot);
        hasher.putHash(dependenciesHash);
        return new TransformWorkspaceIdentity(secondaryInputsSnapshot, hasher.hash());
    }

    public static TransformWorkspaceIdentity createNormalizedImmutable(ValueSnapshot inputArtifactPath, CurrentFileCollectionFingerprint inputArtifactFingerprint, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.put((Hashable)inputArtifactPath);
        hasher.putHash(inputArtifactFingerprint.getHash());
        hasher.put((Hashable)secondaryInputsSnapshot);
        hasher.putHash(dependenciesHash);
        return new TransformWorkspaceIdentity(secondaryInputsSnapshot, hasher.hash());
    }
}

