/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.api.internal.tasks.PublicTaskSpecification;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.DefaultBuildInvocations;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTaskSelector;
import org.gradle.plugins.ide.internal.tooling.model.TaskNameComparator;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class BuildInvocationsBuilder
implements ToolingModelBuilder {
    private final ProjectTaskLister taskLister;
    private final TaskNameComparator taskNameComparator;

    public BuildInvocationsBuilder(ProjectTaskLister taskLister) {
        this.taskLister = taskLister;
        this.taskNameComparator = new TaskNameComparator();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.BuildInvocations");
    }

    public DefaultBuildInvocations buildAll(String modelName, Project project) {
        if (!this.canBuild(modelName)) {
            throw new GradleException("Unknown model name " + modelName);
        }
        DefaultProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        ArrayList<LaunchableGradleTaskSelector> selectors = new ArrayList<LaunchableGradleTaskSelector>();
        TreeMap selectorsByName = Maps.newTreeMap((Comparator)Ordering.natural());
        LinkedHashSet<String> visibleTasks = new LinkedHashSet<String>();
        this.findTasks(project, selectorsByName, visibleTasks);
        for (String selectorName : selectorsByName.keySet()) {
            LaunchableGradleTaskSelector selector = (LaunchableGradleTaskSelector)selectorsByName.get(selectorName);
            selectors.add(selector.setName(selectorName).setTaskName(selectorName).setProjectIdentifier(projectIdentifier).setDisplayName(selectorName + " in " + project + " and subprojects.").setPublic(visibleTasks.contains(selectorName)));
        }
        List<LaunchableGradleTask> projectTasks = this.tasks(project, projectIdentifier);
        return new DefaultBuildInvocations().setSelectors(selectors).setTasks(projectTasks).setProjectIdentifier(projectIdentifier);
    }

    private DefaultProjectIdentifier getProjectIdentifier(Project project) {
        return new DefaultProjectIdentifier(project.getRootDir(), project.getPath());
    }

    private List<LaunchableGradleTask> tasks(Project project, DefaultProjectIdentifier projectIdentifier) {
        return (List)this.taskLister.listProjectTasks(project).stream().map(task -> ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleTask(), projectIdentifier, task)).collect(ImmutableList.toImmutableList());
    }

    private void findTasks(Project project, Map<String, LaunchableGradleTaskSelector> taskSelectors, Collection<String> visibleTasks) {
        for (Project child : ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project)) {
            this.findTasks(child, taskSelectors, visibleTasks);
        }
        for (Task task : this.taskLister.listProjectTasks(project)) {
            LaunchableGradleTaskSelector taskSelector;
            if (!taskSelectors.containsKey(task.getName())) {
                taskSelector = new LaunchableGradleTaskSelector().setDescription(task.getDescription()).setPath(task.getPath());
                taskSelectors.put(task.getName(), taskSelector);
            } else {
                taskSelector = taskSelectors.get(task.getName());
                if (this.hasPathWithLowerOrdering(task, taskSelector)) {
                    taskSelector.setDescription(task.getDescription()).setPath(task.getPath());
                }
            }
            if (!PublicTaskSpecification.INSTANCE.isSatisfiedBy((Object)task)) continue;
            visibleTasks.add(task.getName());
        }
    }

    private boolean hasPathWithLowerOrdering(Task task, LaunchableGradleTaskSelector referenceTaskSelector) {
        return this.taskNameComparator.compare(task.getPath(), referenceTaskSelector.getPath()) < 0;
    }
}

