/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import org.gradle.StartParameter;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.problems.Problems;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeActionExecutor;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.problems.buildtree.ProblemStream;

public class InitDeprecationLoggingActionExecutor
implements BuildTreeActionExecutor {
    private final BuildTreeActionExecutor delegate;
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final StartParameter startParameter;
    private final Problems problemsService;
    private final ProblemStream problemsStream;

    public InitDeprecationLoggingActionExecutor(BuildOperationProgressEventEmitter eventEmitter, StartParameter startParameter, Problems problemsService, ProblemStream problemsStream, BuildTreeActionExecutor delegate) {
        this.delegate = delegate;
        this.eventEmitter = eventEmitter;
        this.startParameter = startParameter;
        this.problemsService = problemsService;
        this.problemsStream = problemsStream;
    }

    @Override
    public BuildActionRunner.Result execute(BuildAction action, BuildTreeContext buildTreeContext) {
        ShowStacktrace showStacktrace = this.startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)false);
            }
        }
        DeprecationLogger.init((WarningMode)this.startParameter.getWarningMode(), (BuildOperationProgressEventEmitter)this.eventEmitter, (Problems)this.problemsService, (ProblemStream)this.problemsStream);
        return this.delegate.execute(action, buildTreeContext);
    }
}

