/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling.model;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleScript;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;

public class DefaultGradleProject
implements Serializable,
GradleProjectIdentity {
    private final DefaultGradleScript buildScript = new DefaultGradleScript();
    private File buildDirectory;
    private File projectDirectory;
    private List<LaunchableGradleProjectTask> tasks = new LinkedList<LaunchableGradleProjectTask>();
    private String name;
    private String description;
    private DefaultProjectIdentifier projectIdentifier;
    private DefaultGradleProject parent;
    private List<? extends DefaultGradleProject> children = new LinkedList<DefaultGradleProject>();
    private String buildTreePath;

    public String getName() {
        return this.name;
    }

    public DefaultGradleProject setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DefaultGradleProject setDescription(String description) {
        this.description = description;
        return this;
    }

    public DefaultGradleProject getParent() {
        return this.parent;
    }

    public DefaultGradleProject setParent(DefaultGradleProject parent) {
        this.parent = parent;
        return this;
    }

    public Collection<? extends DefaultGradleProject> getChildren() {
        return this.children;
    }

    public DefaultGradleProject setChildren(List<? extends DefaultGradleProject> children) {
        this.children = ImmutableList.copyOf(children);
        return this;
    }

    public String getPath() {
        return this.projectIdentifier.getProjectPath();
    }

    public DefaultProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public String getProjectPath() {
        return this.projectIdentifier.getProjectPath();
    }

    public File getRootDir() {
        return this.projectIdentifier.getBuildIdentifier().getRootDir();
    }

    public DefaultGradleProject setProjectIdentifier(DefaultProjectIdentifier projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
        return this;
    }

    public DefaultGradleProject findByPath(String path) {
        if (path.equals(this.getPath())) {
            return this;
        }
        for (DefaultGradleProject defaultGradleProject : this.children) {
            DefaultGradleProject found = defaultGradleProject.findByPath(path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        return "GradleProject{path='" + this.getPath() + '\'' + '}';
    }

    public Collection<LaunchableGradleProjectTask> getTasks() {
        return this.tasks;
    }

    public DefaultGradleProject setTasks(List<LaunchableGradleProjectTask> tasks) {
        this.tasks = ImmutableList.copyOf(tasks);
        return this;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public DefaultGradleProject setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
        return this;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public DefaultGradleProject setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
        return this;
    }

    public DefaultGradleScript getBuildScript() {
        return this.buildScript;
    }

    public DefaultGradleProject setBuildTreePath(String buildTreePath) {
        this.buildTreePath = buildTreePath;
        return this;
    }

    public String getBuildTreePath() {
        return this.buildTreePath;
    }
}

