/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.util.internal.VersionNumber;

public interface VisualStudioTargetBinary {
    public String getProjectPath();

    public String getComponentName();

    public String getVisualStudioProjectName();

    public String getVisualStudioConfigurationName();

    public VersionNumber getVisualStudioVersion();

    public VersionNumber getSdkVersion();

    public ProjectType getProjectType();

    public List<String> getVariantDimensions();

    public FileCollection getSourceFiles();

    public FileCollection getResourceFiles();

    public FileCollection getHeaderFiles();

    public boolean isExecutable();

    public String getBuildTaskPath();

    public String getCleanTaskPath();

    public boolean isDebuggable();

    public File getOutputFile();

    public List<String> getCompilerDefines();

    public LanguageStandard getLanguageStandard();

    public Set<File> getIncludePaths();

    public static enum LanguageStandard {
        NONE(""),
        STD_CPP_14("stdcpp14"),
        STD_CPP_17("stdcpp17"),
        STD_CPP_LATEST("stdcpplatest");

        private final String value;

        private LanguageStandard(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LanguageStandard from(List<String> arguments) {
            return arguments.stream().filter(it -> it.matches("^[-/]std:c\\+\\+.+")).findFirst().map(it -> {
                if (it.endsWith("++14")) {
                    return STD_CPP_14;
                }
                if (it.endsWith("++17")) {
                    return STD_CPP_17;
                }
                if (it.endsWith("++latest")) {
                    return STD_CPP_LATEST;
                }
                return NONE;
            }).orElse(NONE);
        }
    }

    public static enum ProjectType {
        EXE("Exe"),
        LIB("Lib"),
        DLL("Dll"),
        NONE("");

        private final String suffix;

        private ProjectType(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

