/*
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/C++, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <iostream>
#include <string>
#include <algorithm>
#include <expr_parser.h>
#include <protocol.h>
#include <builders.h>
#include <converters.h>

using namespace std;


int main(int argn, char *argv[])
{
  if (argn != 3)
  {
    cout << "Usage:" << endl;
    cout << " " << argv[0] << " type expr" << endl;
    cout << " type: col|tab" << endl;
    return 1;
  }

  parser::Parser_mode::value type = parser::Parser_mode::DOCUMENT;

  std::string type_str = argv[1];
  std::transform(type_str.begin(), type_str.end(), type_str.begin(), ::tolower);

  if (type_str == "tab")
    type = parser::Parser_mode::TABLE;

  try {

    parser::Expression_parser expr(type, argv[2]);

    Mysqlx::Expr::Expr pb_expr;
    cdk::protocol::mysqlx::Expr_builder eb(pb_expr);

    cdk::mysqlx::Expr_converter conv;

    conv.reset(expr);

    conv.process(eb);

    cout << "OK" << endl;

    cout << pb_expr.DebugString() << endl;

  }
  catch( cdk::Error &e)
  {
    cout << "ERROR" << endl;
    cout << e << endl;
  }


  return 0;
}
