/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.matcher;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.matcher.ASTNodePredicate;
import org.codehaus.groovy.macro.matcher.TreeContext;
import org.codehaus.groovy.macro.matcher.TreeContextAction;

public abstract class ContextualClassCodeVisitor
extends ClassCodeVisitorSupport {
    private final Deque<TreeContext> treeContextStack = new ArrayDeque<TreeContext>();
    private TreeContext lastContext;

    public ContextualClassCodeVisitor() {
        this.pushContext(new TreeContext(null, null));
    }

    public TreeContext getTreeContext() {
        return this.treeContextStack.isEmpty() ? null : this.treeContextStack.peek();
    }

    public TreeContext getLastContext() {
        return this.lastContext;
    }

    protected void pushContext(TreeContext ctx) {
        this.treeContextStack.push(ctx);
    }

    protected TreeContext popContext() {
        ASTNode parentNode;
        final TreeContext treeContext = this.treeContextStack.pop();
        List<TreeContextAction> actions = treeContext.getOnPopHandlers();
        for (TreeContextAction contextAction : actions) {
            contextAction.call(treeContext);
        }
        this.lastContext = treeContext;
        ASTNode aSTNode = parentNode = treeContext.parent != null ? treeContext.parent.node : null;
        if (treeContext.node instanceof Expression && parentNode != null) {
            ClassCodeExpressionTransformer classCodeExpressionTransformer = new ClassCodeExpressionTransformer(){

                protected SourceUnit getSourceUnit() {
                    return null;
                }

                public Expression transform(Expression exp) {
                    Expression replacement;
                    if (exp == treeContext.node && (replacement = treeContext.getReplacement()) != null) {
                        return replacement;
                    }
                    return super.transform(exp);
                }
            };
        }
        return treeContext;
    }

    protected void pushContext(ASTNode node) {
        this.pushContext(this.getTreeContext().fork(node));
    }

    public void visitClass(ClassNode node) {
        this.pushContext((ASTNode)node);
        super.visitClass(node);
        this.popContext();
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.pushContext((ASTNode)node);
        }
        super.visitPackage(node);
        if (node != null) {
            this.popContext();
        }
    }

    public void visitImports(ModuleNode node) {
        this.pushContext((ASTNode)node);
        super.visitImports(node);
        this.popContext();
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.pushContext((ASTNode)node);
        super.visitConstructorOrMethod(node, isConstructor);
        this.popContext();
    }

    public void visitField(FieldNode node) {
        this.pushContext((ASTNode)node);
        super.visitField(node);
        this.popContext();
    }

    public void visitProperty(PropertyNode node) {
        this.pushContext((ASTNode)node);
        super.visitProperty(node);
        this.popContext();
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.pushContext((ASTNode)call);
        super.visitMethodCallExpression(call);
        this.popContext();
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.pushContext((ASTNode)call);
        super.visitStaticMethodCallExpression(call);
        this.popContext();
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.pushContext((ASTNode)call);
        super.visitConstructorCallExpression(call);
        this.popContext();
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitBinaryExpression(expression);
        this.popContext();
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitTernaryExpression(expression);
        this.popContext();
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitShortTernaryExpression(expression);
        this.popContext();
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitPostfixExpression(expression);
        this.popContext();
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitPrefixExpression(expression);
        this.popContext();
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitBooleanExpression(expression);
        this.popContext();
    }

    public void visitNotExpression(NotExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitNotExpression(expression);
        this.popContext();
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitClosureExpression(expression);
        this.popContext();
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitTupleExpression(expression);
        this.popContext();
    }

    public void visitListExpression(ListExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitListExpression(expression);
        this.popContext();
    }

    public void visitArrayExpression(ArrayExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitArrayExpression(expression);
        this.popContext();
    }

    public void visitMapExpression(MapExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitMapExpression(expression);
        this.popContext();
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitMapEntryExpression(expression);
        this.popContext();
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitRangeExpression(expression);
        this.popContext();
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitSpreadExpression(expression);
        this.popContext();
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitSpreadMapExpression(expression);
        this.popContext();
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitMethodPointerExpression(expression);
        this.popContext();
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitUnaryMinusExpression(expression);
        this.popContext();
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitUnaryPlusExpression(expression);
        this.popContext();
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitBitwiseNegationExpression(expression);
        this.popContext();
    }

    public void visitCastExpression(CastExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitCastExpression(expression);
        this.popContext();
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitConstantExpression(expression);
        this.popContext();
    }

    public void visitClassExpression(ClassExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitClassExpression(expression);
        this.popContext();
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitVariableExpression(expression);
        this.popContext();
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitPropertyExpression(expression);
        this.popContext();
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitAttributeExpression(expression);
        this.popContext();
    }

    public void visitFieldExpression(FieldExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitFieldExpression(expression);
        this.popContext();
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.pushContext((ASTNode)expression);
        super.visitGStringExpression(expression);
        this.popContext();
    }

    public void visitClosureListExpression(ClosureListExpression cle) {
        this.pushContext((ASTNode)cle);
        super.visitClosureListExpression(cle);
        this.popContext();
    }

    public void visitBytecodeExpression(BytecodeExpression cle) {
        this.pushContext((ASTNode)cle);
        super.visitBytecodeExpression(cle);
        this.popContext();
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitAssertStatement(statement);
        this.popContext();
    }

    public void visitBlockStatement(BlockStatement block) {
        this.pushContext((ASTNode)block);
        super.visitBlockStatement(block);
        this.popContext();
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitBreakStatement(statement);
        this.popContext();
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitCaseStatement(statement);
        this.popContext();
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitCatchStatement(statement);
        this.popContext();
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitContinueStatement(statement);
        this.popContext();
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.pushContext((ASTNode)loop);
        super.visitDoWhileLoop(loop);
        this.popContext();
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitExpressionStatement(statement);
        this.popContext();
    }

    public void visitForLoop(ForStatement forLoop) {
        this.pushContext((ASTNode)forLoop);
        super.visitForLoop(forLoop);
        this.popContext();
    }

    public void visitIfElse(IfStatement ifElse) {
        this.pushContext((ASTNode)ifElse);
        super.visitIfElse(ifElse);
        this.popContext();
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitReturnStatement(statement);
        this.popContext();
    }

    public void visitSwitch(SwitchStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitSwitch(statement);
        this.popContext();
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitSynchronizedStatement(statement);
        this.popContext();
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitThrowStatement(statement);
        this.popContext();
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitTryCatchFinally(statement);
        this.popContext();
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.pushContext((ASTNode)loop);
        super.visitWhileLoop(loop);
        this.popContext();
    }

    public void visitEmptyStatement(EmptyStatement statement) {
        this.pushContext((ASTNode)statement);
        super.visitEmptyStatement(statement);
        this.popContext();
    }

    public List<TreeContext> getTreePath() {
        LinkedList<TreeContext> path = new LinkedList<TreeContext>();
        path.add(this.lastContext);
        path.addAll(this.treeContextStack);
        return path;
    }

    public List<TreeContext> pathMatches(List<ASTNodePredicate> predicates) {
        LinkedList<TreeContext> path = new LinkedList<TreeContext>();
        TreeContext current = this.lastContext.parent;
        for (ASTNodePredicate predicate : predicates) {
            path.add(current);
            if (current == null || !predicate.matches(current.node)) {
                return Collections.emptyList();
            }
            current = current.parent;
        }
        if (!path.isEmpty()) {
            path.add(0, this.lastContext);
        }
        return path;
    }

    public List<TreeContext> pathUpTo(ASTNodePredicate predicate) {
        return this.pathUpTo(null, predicate);
    }

    public List<TreeContext> pathUpTo(Class<ASTNode> node) {
        return this.pathUpTo(node, null);
    }

    public List<TreeContext> pathUpTo(Class<ASTNode> node, ASTNodePredicate predicate) {
        LinkedList<TreeContext> path = new LinkedList<TreeContext>();
        TreeContext current = this.lastContext;
        boolean found = false;
        while (current != null && !found) {
            path.add(current);
            ASTNode currentNode = current.node;
            if (node == null) {
                if (predicate.matches(currentNode)) {
                    found = true;
                }
            } else if (predicate == null) {
                if (currentNode == null || node == currentNode.getClass()) {
                    found = true;
                }
            } else {
                found = currentNode != null && node == currentNode.getClass() && predicate.matches(currentNode);
            }
            current = current.parent;
        }
        if (found) {
            return path;
        }
        return Collections.emptyList();
    }

    public static List<ASTNodePredicate> matchByClass(Class<ASTNode> ... classes) {
        ArrayList<ASTNodePredicate> result = new ArrayList<ASTNodePredicate>(classes.length);
        for (Class<ASTNode> astNodeClass : classes) {
            result.add(new MatchByClass(astNodeClass));
        }
        return result;
    }

    private static class MatchByClass
    implements ASTNodePredicate {
        private final Class<ASTNode> astNodeClass;

        MatchByClass(Class<ASTNode> astNodeClass) {
            this.astNodeClass = astNodeClass;
        }

        @Override
        public boolean matches(ASTNode node) {
            return this.astNodeClass == node.getClass();
        }
    }
}

