/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 173;
    protected char[] symbolAsArray = null;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(173);
    }

    public char[] getCharArray() {
        return this.symbolAsArray;
    }

    public SymbolTable(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public int hash(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 * 37 + cArray[n + n4];
            ++n4;
        }
        return n3 & 0x7FFFFFF;
    }

    public boolean containsSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2);
        int n4 = n3 % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n2 == entry.characters.length && n3 == entry.hashCode) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (cArray[n + n5] == entry.characters[n5]) {
                            ++n5;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public int hash(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = n * 37 + string.charAt(n3);
            ++n3;
        }
        return n & 0x7FFFFFF;
    }

    public boolean containsSymbol(String string) {
        int n = this.hash(string);
        int n2 = n % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            if (n3 == entry.characters.length && n == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n3)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public String addSymbol(char[] cArray, int n, int n2) {
        Entry entry;
        int n3 = this.hash(cArray, n, n2);
        int n4 = n3 % this.fTableSize;
        Entry entry2 = this.fBuckets[n4];
        while (entry2 != null) {
            block4: {
                if (n2 == entry2.characters.length && n3 == entry2.hashCode) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (cArray[n + n5] == entry2.characters[n5]) {
                            ++n5;
                            continue;
                        }
                        break block4;
                    }
                    this.symbolAsArray = entry2.characters;
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        this.fBuckets[n4] = entry = new Entry(cArray, n, n2, this.fBuckets[n4]);
        entry.hashCode = n3;
        this.symbolAsArray = entry.characters;
        return entry.symbol;
    }

    public String addSymbol(String string) {
        int n = this.hash(string);
        int n2 = n % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            if (n3 == entry.characters.length && n == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n3)) {
                this.symbolAsArray = entry.characters;
                return entry.symbol;
            }
            entry = entry.next;
        }
        Entry entry2 = new Entry(string, this.fBuckets[n2]);
        entry2.hashCode = n;
        this.symbolAsArray = entry2.characters;
        this.fBuckets[n2] = entry2;
        return entry2.symbol;
    }

    protected static final class Entry {
        public String symbol;
        int hashCode = 0;
        public char[] characters;
        public Entry next;

        public Entry(char[] cArray, int n, int n2, Entry entry) {
            this.characters = new char[n2];
            System.arraycopy(cArray, n, this.characters, 0, n2);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }
    }
}

