package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

/**
 * The value-binding selection dialog.
 * 
 * @author Naoki Takezoe
 */
public class ValueSelectionDialog extends SelectionDialog {
	
	private TreeViewer viewer;
//	private Button addButton;
	private ManagedBean[] beans;
	private ManagedBeanProperty initial;
	
	public ValueSelectionDialog(Shell parentShell, ManagedBean[] beans, ManagedBeanProperty initial) {
		super(parentShell);
		setTitle(VisualJSFPlugin.getResourceString("dialog.chooseProperty"));
		this.beans = beans;
		this.initial = initial;
		setShellStyle(getShellStyle() | SWT.RESIZE);
	}
	
	protected Point getInitialSize() {
		return new Point(350, 300);
	}

    protected Control createContents(Composite parent) {
    	Control control = super.createContents(parent);
		if(this.initial!=null){
			this.viewer.setSelection(new StructuredSelection(this.initial), true);
		}
    	return control;
    }
	
	protected Control createDialogArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, true));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		this.viewer = new TreeViewer(composite);
		viewer.getTree().setLayoutData(new GridData(GridData.FILL_BOTH));
		viewer.setContentProvider(new ValueContentProvider());
		viewer.setLabelProvider(new ValueLabelProvider());
		viewer.setInput(this.beans);
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event){
				IStructuredSelection sel = (IStructuredSelection)event.getSelection();
				Object obj = sel.getFirstElement();
				if(obj instanceof ManagedBeanProperty){
					setSelectionResult(new Object[]{obj});
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				} else {
					getButton(IDialogConstants.OK_ID).setEnabled(false);
				}
				
//				addButton.setEnabled(false);
//				if(obj instanceof ManagedBean){
//					ManagedBean bean = (ManagedBean)obj;
//					try {
//						IType type = bean.getProject().findType(bean.getClassName());
//						addButton.setEnabled(!type.isBinary());
//					} catch(Exception ex){
//						// ignore
//					}
//				}
			}
		});
		
//		addButton = new Button(composite, SWT.PUSH);
//		addButton.setText("Add New Property");
//		addButton.addSelectionListener(new SelectionAdapter(){
//			public void widgetSelected(SelectionEvent evt){
//				InputDialog dialog = new InputDialog(getParentShell(), 
//						"Add New Property",
//						"Input the new property name.",
//						"", null);
//				if(dialog.open()==InputDialog.OK){
//					String propertyName = dialog.getValue();
//					IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
//					ManagedBean bean = (ManagedBean)sel.getFirstElement();
//					try {
//						IType type = bean.getProject().findType(bean.getClassName());
//						VisualJSFUtil.createProperty(type, propertyName, "String");
//						bean.refresh();
//						viewer.refresh();
//						
//						ManagedBeanProperty selection = null;
//						ManagedBeanProperty[] properties = bean.getProperties();
//						for(int i=0;i<properties.length;i++){
//							if(properties[i].getPropertyName().equals(propertyName)){
//								selection = properties[i];
//								break;
//							}
//						}
//						if(selection!=null){
//							viewer.setSelection(new StructuredSelection(selection), true);
//						}
//						
//					} catch(Exception ex){
//						Util.openErrorDialog(ex);
//					}
//				}
//			}
//		});
//		
//		Label label = new Label(composite,SWT.HORIZONTAL|SWT.SEPARATOR);
//		label.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		return composite;
	}
	
	private class ValueContentProvider implements ITreeContentProvider {

		public Object[] getChildren(Object parentElement) {
			if(parentElement instanceof ManagedBean){
				return ((ManagedBean)parentElement).getProperties();
			}
			return new Object[0];
		}

		public Object getParent(Object element) {
			if(element instanceof ManagedBeanProperty){
				return ((ManagedBeanProperty)element).getParent();
			}
			return null;
		}

		public boolean hasChildren(Object element) {
			return getChildren(element).length > 0;
		}

		public Object[] getElements(Object inputElement) {
			return (ManagedBean[])inputElement;
		}

		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}
	
	private class ValueLabelProvider extends LabelProvider {

		public Image getImage(Object element) {
			if(element instanceof ManagedBean){
				return JSFPlugin.getDefault().getImage(JSFPlugin.ICON_CLASS);
			} else if(element instanceof ManagedBeanProperty){
				return JSFPlugin.getDefault().getImage(JSFPlugin.ICON_PROP);
			}
			return super.getImage(element);
		}

		public String getText(Object element) {
			if(element instanceof ManagedBean){
				return ((ManagedBean)element).getBeanName() + " - " + 
				        ((ManagedBean)element).getClassName();
			} else if(element instanceof ManagedBeanProperty){
				return ((ManagedBeanProperty)element).getPropertyName() + " - " + 
				        ((ManagedBeanProperty)element).getPropertyType();
			}
			return super.getText(element);
		}
		
	}
	
}
