package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.Hyperlink;
import tk.eclipse.plugin.visualjsf.models.CommandLinkModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.CommandButtonLink}.
 * 
 * @author Naoki Takezoe
 */
public class CommandLinkEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		CommandLinkModel model = (CommandLinkModel)getModel();
		
		Hyperlink link = new Hyperlink();
		link.setText(model.getValue());
		return link;
	}

	protected void refreshVisuals() {
		super.refreshVisuals();
		
		CommandLinkModel model = (CommandLinkModel)getModel();
		Hyperlink link = (Hyperlink)getFigure();
		link.setText(model.getValue());
	}

	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		CommandLinkModel model = (CommandLinkModel)getModel();
		return new IAction[]{
				createActionAction("commandLink_action", model.getName()),
				createActionListenerAction("commandLink_actionListener", model.getName()),
		};
	}

}
