package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;

import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.VisualJSFUtil;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.IActionModel;

/**
 * 
 * @author Naoki Takezoe
 */
public class CreateActionListenerAction extends Action {
	
	private IActionModel model = null;
	private EditPartViewer viewer = null;
	
	public CreateActionListenerAction(String id, String text, IActionModel model, EditPartViewer viewer){
		super(text, VisualJSFPlugin.getImageDescriptor("icons/event_1.gif"));
		setId(id);
		this.model = model;
		this.viewer = viewer;
	}
	
	public void run(){
		IType beanType = ((AbstractJSFModel)this.model).getRoot().getBeanType();
		if(beanType==null){
			return;
		}
		final String beanName   = ((AbstractJSFModel)this.model).getRoot().getBeanName();
		final String methodName = getText();
		if(this.model.getActionListener()==null || this.model.getActionListener().length()==0){
			// Sets the method binding
			CommandStack stack = this.viewer.getEditDomain().getCommandStack();
			stack.execute(new Command(){
				public void execute(){
					CreateActionListenerAction.this.model.setActionListener("#{" + beanName + "." + methodName + "}");
				}
				public void undo() {
					CreateActionListenerAction.this.model.setActionListener("");
				}
			});
		}
		IMethod method = getMethod(beanType, methodName);
		if(method==null || !method.exists()){
			// Creates the action method
			VisualJSFUtil.createActionListenerMethod(beanType, methodName);
			method = getMethod(beanType, methodName);
		}
		VisualJSFUtil.openJavaElement(method);
	}
	
	private IMethod getMethod(IType type, String name){
		IMethod method = null;
		try {
			IMethod[] methods = type.getMethods();
			for(int i=0;i<methods.length;i++){
				if(methods[i].getElementName().equals(name)){
					method = methods[i];
					break;
				}
			}
		} catch(JavaModelException ex){
		}
		return method;
	}

}
