package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.swt.graphics.Color;

import tk.eclipse.plugin.visualjsf.models.DataColumnModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.DataColumnModel}.
 * 
 * @author Naoki Takezoe
 */
public class DataColumnEditPart extends AbstractJSFEditPart implements ColorConstants {
	
	private Label headerLabel;
	private Label valueLabel;
	
	protected IFigure createFigure() {
		DataColumnModel model = (DataColumnModel)getModel();
		
		Figure figure = new Figure();
		ToolbarLayout layout = new ToolbarLayout();
		layout.setVertical(true);
		layout.setSpacing(2);
		figure.setLayoutManager(layout);
		
		headerLabel = new Label();
		headerLabel.setText(model.getColumnName());
		headerLabel.setBorder(new SchemeBorder(new ButtonScheme(
				new Color[] { buttonLightest, buttonDarkest },
				new Color[] { buttonDarker, buttonLightest,  }
			)));
		
		Figure content = new Figure();
		content.setLayoutManager(new FlowLayout());
		content.setBorder(new SchemeBorder(new ButtonScheme(
				new Color[] { buttonLightest, buttonDarkest },
				new Color[] { buttonDarker, buttonLightest,  }
			)));
		
		valueLabel = new Label();
		valueLabel.setText(model.getColumnValue());
		content.add(valueLabel);
		
		figure.add(headerLabel);
		figure.add(content);
		
		return figure;
	}

	protected void refreshVisuals() {
		DataColumnModel model = (DataColumnModel)getModel();
		headerLabel.setText(model.getColumnName());
		valueLabel.setText(model.getColumnValue());
	}

}
