package tk.eclipse.plugin.visualjsf.editparts;

import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.ListBox;
import tk.eclipse.plugin.visualjsf.models.SelectManyListboxModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.SelectManyListboxModel}.
 * 
 * @author Naoki Takezoe
 */
public class SelectManyListboxEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		ListBox listbox = new ListBox();
		SelectManyListboxModel model = (SelectManyListboxModel)getModel();
		updateFigure(listbox, model);
		return listbox;
	}
	
	private void updateFigure(ListBox listbox, SelectManyListboxModel model){
		listbox.removeAllItems();
		if(model.getSelectItems().length()==0){
			List items = model.getSelectItem();
			for(int i=0;i<items.size();i++){
				String[] item = (String[])items.get(i);
				listbox.addItem(item[0]);
			}
		}
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		ListBox listbox = (ListBox)getFigure();
		SelectManyListboxModel model = (SelectManyListboxModel)getModel();
		updateFigure(listbox, model);
		listbox.repaint();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		SelectManyListboxModel model = (SelectManyListboxModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("selectManyListbox_valueChangeListener", 
						model.getName())
		};
	}

}
