package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.CommandLinkModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:commandLink.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.CommandLinkModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class CommandLinkLoader extends AbstractFormElementLoader {

	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		CommandLinkModel model = new CommandLinkModel();
		
		model.setValue(getString(element, "value"));
		model.setAction(getString(element, "action"));
		model.setActionListener(getString(element, "actionListener"));
		
		return model;
	}
}
