package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.InputSecretModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:inputSecret.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.InputSecretModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class InputSecretLoader extends AbstractFormElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		InputSecretModel model = new InputSecretModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		
		return model;
	}
}
