package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:selectOneRadio.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class SelectOneRadioLoader extends AbstractSelectElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		SelectOneRadioModel model = new SelectOneRadioModel();
		
		model.setValue(getString(element, "value"));
		model.setLayout(getString(element, "layout"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		setItems(model, element);
		
		return model;
	}

}
