package tk.eclipse.plugin.visualjsf.models;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.visualjsf.VisualJSFUtil;

/**
 * @author Naoki Takezoe
 */
public abstract class AbstractJSFModel extends AbstractModel implements IPropertySource {
	
	private Rectangle constraint;
	private RootModel root;
	private String name = "";
	private String binding = "";
	private String styleClass = "";
	
	public static final String P_CONSTRAINT = "_constraint";
	public static final String P_NAME = "_name";
	public static final String P_BINDING = "_binding";
	public static final String P_STYLE_CLASS = "_styleClass";
	
	public AbstractJSFModel(){
		addModelProperty(P_NAME, new ModelProperty(this, "name", String.class,
				new TextPropertyDescriptor(P_NAME, "name")));
		addModelProperty(P_STYLE_CLASS, new ModelProperty(this, "styleClass", String.class,
				new TextPropertyDescriptor(P_STYLE_CLASS, "styleClass")));
	}
	
	public abstract String getComponentName();
	
	public abstract String getComponentClass();
	
	public abstract String getTagName();
	
	public RootModel getRoot() {
		return root;
	}
	
	public void setRoot(RootModel root) {
		this.root = root;
	}
	
	public void setName(String name){
		if(getRoot()!=null){
			renamed(getRoot().getBeanType(), getRoot().getBeanName(), 
					this.name, name);
		}
		this.name = name;
		firePropertyChange(P_NAME, null, name);
	}
	
	public String getName(){
		return this.name;
	}
	
	public String getBinding() {
		return binding;
	}

	public void setBinding(String binding) {
		this.binding = binding;
		firePropertyChange(P_BINDING, null, binding);
	}	
	
	public String getStyleClass() {
		return styleClass;
	}

	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
		firePropertyChange(P_STYLE_CLASS, null, styleClass);
	}

	public Rectangle getConstraint() {
		return constraint;
	}
	
	public void setConstraint(Rectangle constraint) {
		this.constraint = constraint;
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}
	
	protected void added(IType type, String name){
		if(type!=null && name!=null){
			VisualJSFUtil.createProperty(type, 
					getName(), getComponentClass());
			setBinding("#{" + name + "." + getName() + "}");
		}
	}
	
	protected void renamed(IType type, String name, String oldName, String newName){
		if(type!=null && name!=null){
			VisualJSFUtil.renameProperty(type, oldName, newName, getComponentClass());
			setBinding("#{" + name + "." + newName + "}");
		}
	}
	
	protected void removed(IType type, String name){
		if(type!=null && name!=null){
			VisualJSFUtil.removeProperty(type, getName());
		}
	}
	
	protected String getBindingAttribute(){
		if(binding==null || binding.length()==0){
			return "";
		} else {
			return " binding=\"" + getBinding() + "\"";
		}
	}
	
	protected StringBuffer getPositionStyle(){
		Rectangle rect = getConstraint();
		StringBuffer style = new StringBuffer();
		style.append("position: absolute;");
		style.append("left: ").append(rect.x).append(";");
		style.append("top: ").append(rect.y).append(";");
		style.append("width: ").append(rect.width).append(";");
		style.append("height: ").append(rect.height).append(";");
		return style;
	}
	
}
