package tk.eclipse.plugin.visualjsf.models;

import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.descriptors.ActionListenerDescriptor;
import tk.eclipse.plugin.visualjsf.descriptors.ActionPropertyDescriptor;

/**
 * The model class for h:commandButton.
 * 
 * @author Naoki Takezoe
 */
public class CommandButtonModel extends AbstractJSFFormModel implements IActionModel {
	
	public static final String P_VALUE = "_value";
	public static final String P_ACTION = "_action";
	public static final String P_ACTION_LISTENER = "_actionListener";
	
	private String value = "Submit";
	private String action = "";
	private String actionListener = "";
	
	public CommandButtonModel(){
		addModelProperty(P_VALUE, new ModelProperty(this, "value", String.class, 
				new TextPropertyDescriptor(P_VALUE, "value")));
		addModelProperty(P_ACTION, new ModelProperty(this, "action", String.class, 
				new ActionPropertyDescriptor(P_ACTION, "action")));
		addModelProperty(P_ACTION_LISTENER, new ModelProperty(this, "actionListener", String.class, 
				new ActionListenerDescriptor(P_ACTION_LISTENER, "actionListener")));
	}
	
	public String getComponentClass(){
		return "javax.faces.component.html.HtmlCommandButton";
	}
	
	public String getComponentName(){
		return "commandButton";
	}
	
	public String getTagName(){
		return "h:commandButton";
	}
	
	public void setValue(String value){
		this.value = value;
		firePropertyChange(P_VALUE, null, value);
	}
	
	public String getValue(){
		return this.value;
	}
	
	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
		firePropertyChange(P_ACTION, null, action);
	}
	
	public String getActionListener() {
		return actionListener;
	}

	public void setActionListener(String actionListener) {
		this.actionListener = actionListener;
		firePropertyChange(P_ACTION_LISTENER, null, actionListener);
	}
	
	public String toHTML() {
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getTagName());
		if(getName().length()>0){
			sb.append(" id=\"").append(getName()).append("\"");
		}
		sb.append(" style=\"").append(getPositionStyle().toString()).append("\"");
		if(getValue().length()>0){
			sb.append(" value=\"").append(HTMLUtil.escapeHTML(getValue())).append("\"");
		}
		if(getAction().length()>0){
			sb.append(" action=\"").append(HTMLUtil.escapeHTML(getAction())).append("\"");
		}
		if(getActionListener().length()>0){
			sb.append(" actionListener=\"").append(HTMLUtil.escapeHTML(getActionListener())).append("\"");
		}
		sb.append(getFormAttributes());
		sb.append(" />");
		return sb.toString();
	}

}
