package tk.eclipse.plugin.visualjsf.models;

import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLUtil;

/**
 * The model class for h:column.
 * 
 * @author Naoki Takezoe
 * @see DataTableModel
 */
public class DataColumnModel extends AbstractJSFModel {
	
//	private DataTableModel dataTableModel;
	private String columnName = "";
	private String columnValue = "";
//	private AbstractJSFModel columnModel = null;
	
	public static final String P_COLUMN_NAME = "_column_name";
	public static final String P_COLUMN_VALUE = "_column_value";
//	public static final String P_COLUMN_MODEL = "_column_model";
	
	public DataColumnModel(){
		addModelProperty(P_COLUMN_NAME, new ModelProperty(this, "columnName", String.class, 
				new TextPropertyDescriptor(P_COLUMN_NAME, "columnName")));
		addModelProperty(P_COLUMN_VALUE, new ModelProperty(this, "columnValue", String.class, 
				new TextPropertyDescriptor(P_COLUMN_VALUE, "columnValue")));
	}
	
//	public void setDataTableModel(DataTableModel dataTableModel){
//		this.dataTableModel = dataTableModel;
//	}
	
	public void setColumnValue(String columnValue){
		this.columnValue = columnValue;
		firePropertyChange(P_COLUMN_VALUE, null, columnValue);
	}
	
	public String getColumnValue(){
		return this.columnValue;
	}
	
	public void setColumnName(String columnName){
		this.columnName = columnName;
		firePropertyChange(P_COLUMN_NAME, null, columnName);
	}
	
	public String getColumnName(){
		return this.columnName;
	}
	
//	public void setColumnModel(AbstractJSFModel columnModel){
//		this.columnModel = columnModel;
//		firePropertyChange(P_COLUMN_MODEL, null, null);
//	}
//	
//	public AbstractJSFModel getColumnModel(){
//		return this.columnModel;
//	}

	/**
	 * Returns <code>javax.faces.component.html.HtmlColumn</code>.
	 */
	public String getComponentClass() {
		return "javax.faces.component.html.HtmlColumn";
	}

	/**
	 * Returns <code>column</code>.
	 */
	public String getComponentName() {
		return "column";
	}

	/**
	 * Returns <code>h:column</code>.
	 */
	public String getTagName() {
		return "h:column";
	}

	public String toHTML() {
		StringBuffer sb = new StringBuffer();
		sb.append("\t\t\t\t\t<").append(getTagName()).append(">\n");
		sb.append("\t\t\t\t\t\t<f:facet name=\"header\">\n");
		sb.append("\t\t\t\t\t\t\t<h:outputText value=\"").append(HTMLUtil.escapeHTML(getColumnName())).append("\"/>\n");
		sb.append("\t\t\t\t\t\t</f:facet>\n");
		sb.append("\t\t\t\t\t\t<h:outputText value=\"").append(HTMLUtil.escapeHTML(getColumnValue())).append("\"/>\n");
		sb.append("\t\t\t\t\t</").append(getTagName()).append(">");
		return sb.toString();
	}
	
}
