/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.io;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class SourceWriter {
    private String _encoding = "";

    private String _lfln = System.getProperty("line.separator");

    private boolean _created = false;

    private boolean _updated = false;

    public SourceWriter(String encoding) {
        _encoding = encoding;
    }

    public void write(String path, List code) throws IOException {
        setupToWrite(path);
        BufferedWriter writer = null;
        ByteArrayOutputStream stream = null;

        try {
            stream = new ByteArrayOutputStream();

            final byte[] lfln = _lfln.getBytes();
            // O񂪃uNsłǂ
            boolean isBlankLine = false;
            for (int i = 0; i < code.size(); i++) {
                String line = (String) code.get(i);
                if (line.trim().length() == 0) {
                    // sƂĎ̂ꍇɂ͋sɉH܂B
                    line = line.trim();
                }
                if (line.length() == 0) {
                    if (isBlankLine) {
                        // As͏o͗}܂B
                        continue;
                    }
                    isBlankLine = true;
                } else {
                    isBlankLine = false;
                }

                stream.write(line.getBytes(_encoding));
                stream.write(lfln);
            }

            final byte[] newSource = stream.toByteArray();
            final boolean exists = new File(path).exists();
            if (!exists) {
                writeSource(path, newSource);
                _created = true;
            } else if (exists && !compare(newSource, readTarget(path))) {
                writeSource(path, newSource);
                _updated = true;
            }

        } finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    public boolean isUpdated() {
        return _updated;
    }

    public boolean isCreated() {
        return _created;
    }

    private void writeSource(String path, byte[] source) throws IOException {

        File target = new File(path);
        target.delete();

        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(target), true,
                    _encoding);
            printStream.write(source);
        } finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    private boolean compare(byte[] newSource, byte[] targetSource) {
        boolean result = true;
        if (newSource.length != targetSource.length) {
            result = false;
        } else {
            for (int i = 0; i < newSource.length; i++) {
                if (newSource[i] != targetSource[i]) {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    private byte[] readTarget(String path) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream outputStream = null;
        FileInputStream inputStream = null;
        byte[] buffer = new byte[4096];

        try {
            outputStream = new ByteArrayOutputStream();
            inputStream = new FileInputStream(path);
            int readed = inputStream.read(buffer);
            while (readed != -1) {
                outputStream.write(buffer, 0, readed);
                readed = inputStream.read(buffer);
            }
            result = outputStream.toByteArray();
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            } finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        return result;
    }

    private void setupToWrite(String path) {
        File f = new File(path);
        File directory = f.getParentFile();

        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}
