/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.field;

import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.ClassExpanderDotNet;
import blanco.dotnet.cg.expander.ExpanderDotNet;
import blanco.dotnet.cg.expander.ScopeDotNet;
import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.expander.ValueDotNet;
import blanco.dotnet.cg.expander.implementor.StatementDotNet;
import blanco.dotnet.cg.expander.javadoc.MethodJavaDocDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public class FieldExpanderDotNet extends ExpanderDotNet {
    private ValueDotNet _value = null;

    private ValueDotNet _fieldValue = null;

    private MethodJavaDocDotNet _javaDoc = new MethodJavaDocDotNet();

    private String _defaultValue = "";

    private List _usingType = new ArrayList();

    /**
     * tB[h̓ftHgPRIVATEƂ܂B
     */
    protected ScopeDotNet getScope() {
        return ScopeDotNet.PRIVATE;
    }

    public FieldExpanderDotNet(TypeDotNet type, String name) {
        this(new ValueDotNet(type, name));
    }

    public FieldExpanderDotNet(ValueDotNet value) {
        this(value, value.getName());
    }

    public FieldExpanderDotNet(ValueDotNet value, String fieldName) {
        _value = value;
        _fieldValue = new ValueDotNet(_value.getType(), fieldName);
        _usingType.add(_value.getType());
    }

    public ValueDotNet getFieldValue() {
        return _fieldValue;
    }

    public MethodJavaDocDotNet getJavaDoc() {
        return _javaDoc;
    }

    public void setLiteralValue(String literal) {
        StringBuffer sb = new StringBuffer(literal);
        if (_value.getType().equals(String.class)) {
            sb.insert(0, "\"");
            sb.append("\"");
        }
        _defaultValue = sb.toString();
    }

    public void setDefaultValue(Class constructType) {
        _defaultValue = "new" + constructType.getName() + "()";
        _usingType.add(new TypeDotNet(constructType.getName()));
    }

    public void setDefaultStatement(StatementDotNet statement) {
        _defaultValue = statement.toString();
        _usingType.addAll(statement.getUsingTypeList());
    }

    public ValueDotNet getTypeValue() {
        return _value;
    }

    public String getFieldDeclaration() {
        StringBuffer sb = new StringBuffer();

        sb.append(getScope().get());
        sb.append(" ");
        if (isStatic()) {
            sb.append("static ");
        }
        sb.append(_value.getType().getName());
        sb.append(" ");
        sb.append(_fieldValue.getName());

        if (!_defaultValue.equals("")) {
            sb.append(" = ");
            sb.append(_defaultValue);
        }
        sb.append(";");
        return new String(sb);
    }

    public List expand() {
        List result = new ArrayList();
        if (!_javaDoc.isEmpty()) {
            List list = _javaDoc.expand();
            for (int i = 0; i < list.size(); i++) {
                result.add(ClassExpanderDotNet.INDENT + list.get(i));
            }
        }
        if (getAnnotationList().isEmpty() == false) {
            // tB[h̃Ame[VWJ܂B
            for (int index = 0; index < getAnnotationList().size(); index++) {
                result.add(ClassExpanderDotNet.INDENT
                        + ClassExpanderDotNet.INDENT + "["
                        + (String) getAnnotationList().get(index) + "]");
            }
        }
        result.add(ClassExpanderDotNet.INDENT + ClassExpanderDotNet.INDENT
                + getFieldDeclaration());
        return result;
    }

    public List getUsingTypeList() {
        return _usingType;
    }
}
