/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.implementor;

import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.expander.ValueDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 * @deprecated Ƃ ͗pȂłB
 */
public final class CallDotNet extends StatementDotNet {

    private List _arguments = new ArrayList();

    private String _method = "";

    private CallDotNet _call = null;

    public CallDotNet() {
        super();
    }

    public CallDotNet(String method) {
        setMethod(method);
    }

    public CallDotNet(TypeDotNet type) {
        setConstructor(type);
    }

    public CallDotNet(TypeDotNet staticTarget, String method) {
        addUsingType(staticTarget);
        setMethod(staticTarget.getName() + "." + method);
    }

    public void addArgument(String valueName) {
        _arguments.add(valueName);
    }

    public void addArgument(StatementDotNet statement) {
        _arguments.add(statement.toString());
        addSubStatement(statement);
    }

    public void addArgument(ValueDotNet value) {
        _arguments.add(value.getName());
    }

    public String getStatementString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getMethod());
        sb.append("(");

        for (int i = 0; i < _arguments.size(); i++) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(_arguments.get(i).toString());
        }
        sb.append(")");
        if (_call != null) {
            sb.append(".");
            sb.append(_call.toString());
        }

        return sb.toString();
    }

    private String getMethod() {
        return _method;
    }

    public void setMethod(String name) {
        _method = name;
    }

    public void setConstructor(TypeDotNet type) {
        _method = "new " + type.getName();
        addUsingType(type);
    }

    public void addStringArgument(String string) {
        _arguments.add("\"" + string + "\"");
    }

    public void addCallArgument(CallDotNet call) {
        _arguments.add(call);

    }

    public void call(CallDotNet call) {
        _call = call;
    }

    public CallDotNet call(String methodName) {
        _call = new CallDotNet(methodName);
        return _call;
    }
}
