/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.implementor;

import java.util.List;

import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.expander.ValueDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public class ImplementorDotNet {
    private ImplementDataDotNet _data = null;

    private List _usingTypeList;

    public ImplementorDotNet(final ImplementDataDotNet data) {
        _usingTypeList = data.getUsingTypeList();
        _data = data;
    }

    public void addThrow(final CallDotNet call) {
        addUsingTypeList(call.getUsingTypeList());
        addStatement("throw " + call.toString());
    }

    public void addThrow(final ValueDotNet exception) {
        addStatement("throw " + exception.getName());
    }

    public void declare(final ValueDotNet value,
            final StatementDotNet defaultStatement) {
        addUsingType(value.getType());
        addUsingTypeList(defaultStatement.getUsingTypeList());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(defaultStatement.toString());

        addStatement(sb.toString());
    }

    public void declare(final ValueDotNet value) {
        addUsingType(value.getType());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());

        addStatement(sb.toString());
    }

    public void declareByDefault(final ValueDotNet value) {
        addUsingType(value.getType());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(getDefault(value.getType()));

        addStatement(sb.toString());
    }

    private StatementDotNet getDefault(final TypeDotNet type) {
        StatementDotNet result = null;
        if (type.equals(int.class) || type.equals(short.class)) {
            result = new StatementDotNet("0");
        } else if (type.equals(String.class)) {
            result = new StringLiteralDotNet("");
        } else if (!type.isPrimitive()) {
            result = new StatementDotNet(ValueDotNet.NULL);
        } else {
            String message = "T|[gǑ^łBType:" + type.getFullName();
            throw new RuntimeException(message);
        }
        return result;
    }

    public void assign(final ValueDotNet value, final StatementDotNet statement) {
        final StringBuffer sb = new StringBuffer();
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(statement.toString());

        addStatement(sb.toString());
        addUsingTypeList(statement.getUsingTypeList());

    }

    public void assign(final ValueDotNet value, final ValueDotNet assignValue) {
        assign(value, new StatementDotNet(assignValue));
    }

    public void emptyLine() {
        addLine("");
    }

    public void openIf(final String expresstion) {
        _data.pushBlock(BlockDotNet.IF);
        addLine("if (" + expresstion + ") {");
    }

    public void openFor(final StatementDotNet left,
            final StatementDotNet center, final StatementDotNet right) {
        _data.pushBlock(BlockDotNet.FOR);
        final StringBuffer sb = new StringBuffer();
        sb.append("for (");
        sb.append(left.toString());
        sb.append("; ");
        sb.append(center.toString());
        sb.append("; ");
        sb.append(right.toString());
        sb.append(") {");
        addLine(sb.toString());
    }

    public void openFor(final ValueDotNet counter, final StatementDotNet loop) {
        _data.pushBlock(BlockDotNet.FOR);
        final StringBuffer sb = new StringBuffer();
        sb.append("for (");
        sb.append("int ");
        sb.append(counter.getName());
        sb.append(" = 0; ");
        sb.append(loop.toString());
        sb.append("; ");
        sb.append(counter.getName());
        sb.append("++) {");
        addLine(sb.toString());
    }

    public void openWhile(final String expresstion) {
        _data.pushBlock(BlockDotNet.WHILE);
        addLine("while (" + expresstion + ") {");
    }

    public void openWhile(final StatementDotNet expresstion) {
        addUsingTypeList(expresstion.getUsingTypeList());
        openWhile(expresstion.toString());
    }

    public void openIf(final StatementDotNet statement) {
        openIf(statement.toString());
        addUsingTypeList(statement.getUsingTypeList());
    }

    public void openTry() {
        _data.pushBlock(BlockDotNet.TRY);
        addLine("try {");
    }

    public void addElseIf(final String expresstion) {
        addLine("} else if (" + expresstion + ") {");
    }

    public void addElseIf(final StatementDotNet expresstion) {
        addUsingTypeList(expresstion.getUsingTypeList());
        addLine("} else if (" + expresstion.toString() + ") {");
    }

    public void addCatch(final ValueDotNet value) {
        addUsingType(value.getType());
        addLine("} catch (" + value.getType().getName() + " " + value.getName()
                + ") {");
    }

    public void addElse() {
        addLine("} else {");
    }

    public void addFinally() {
        addLine("} finally {");
    }

    public void closeIf() {
        _data.popBlock();
        addLine("}");
    }

    public void closeTry() {
        _data.popBlock();
        addLine("}");
    }

    public void closeWhile() {
        _data.popBlock();
        addLine("}");
    }

    public void closeFor() {
        _data.popBlock();
        addLine("}");
    }

    public void addStatement(String line) {
        addLine(line + ";");
    }

    public void addStatement(StatementDotNet statement) {
        addStatement(statement.toString());
        getUsingTypeList().addAll(statement.getUsingTypeList());
    }

    public void addLine(String line) {
        _data.addLine(line);
    }

    public List getImplementList() {
        return _data.getImplementList();
    }

    public void addReturn(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("return ");
        sb.append(value);
        sb.append(";");

        addLine(new String(sb));
    }

    public void addReturn(ValueDotNet value) {
        addReturn(value.getName());
    }

    public void addReturn(StatementDotNet statement) {
        addReturn(statement.toString());
        addUsingTypeList(statement.getUsingTypeList());
    }

    public void addReturn() {
        addLine("return;");
    }

    public int getUsingTypeCount() {
        return _usingTypeList.size();
    }

    public void addUsingType(TypeDotNet type) {
        _usingTypeList.add(type);
    }

    public void addUsingTypeList(List typeList) {
        _usingTypeList.addAll(typeList);
    }

    public TypeDotNet getUsingType(int index) {
        return (TypeDotNet) _usingTypeList.get(index);
    }

    public List getUsingTypeList() {
        return _usingTypeList;
    }
}
