/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.javadoc;

import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.ClassExpanderDotNet;
import blanco.dotnet.cg.expander.ExpanderDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX<br>
 * .NETł JavaDocƂ͌Ăт܂񂪁A ̎ JavaDocŎ܂B
 * 
 * @author IGA Tosiki
 */
public abstract class JavaDocDotNet extends ExpanderDotNet {
    private List _docLine = null;

    private List _docLine2 = null;

    public JavaDocDotNet() {
        _docLine = new ArrayList();
        _docLine2 = new ArrayList();
    }

    public boolean isEmpty() {
        return _docLine.size() == 0;
    }

    /**
     * summary^ÕRgǉ܂B
     * 
     * @param doc
     */
    public void addLine(String doc) {
        _docLine.add(doc);
    }

    /**
     * summary^OÕRgǉ܂B
     * 
     * @param doc
     */
    public void addLine2(String doc) {
        _docLine2.add(doc);
    }

    public abstract void expandJavaDoc();

    public List expand() {
        List result = new ArrayList();

        expandJavaDoc();

        // C#̏ꍇɂ͈sRg͗pȂƂƂ܂B
        result.add(ClassExpanderDotNet.INDENT + "/// <summary>");
        for (int i = 0; i < _docLine.size(); i++) {
            result.add(ClassExpanderDotNet.INDENT + "/// <newpara>"
                    + _docLine.get(i) + "</newpara>");
        }
        result.add(ClassExpanderDotNet.INDENT + "/// </summary>");

        for (int i = 0; i < _docLine2.size(); i++) {
            result.add(ClassExpanderDotNet.INDENT + "/// " + _docLine2.get(i));
        }

        return result;
    }
}
