/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public class ImportListDotNet extends ExpanderDotNet {
    private Map _javaPackageList = new TreeMap();

    private Map _javaxPackageList = new TreeMap();

    private Map _otherPackageList = new TreeMap();

    private List _codeList = new ArrayList();

    public ImportListDotNet() {
    }

    public void add(TypeDotNet type) {
        if (type.isPrimitive() || isJavaLangPackage(type)) {
            return;
        }

        if (isJavaPackage(type)) {
            addJavaPackageClass(type);
        } else if (isJavaxPackage(type)) {
            addJavaxPackageClass(type);
        } else {
            addOtherPackageClass(type);
        }
    }

    public void add(List typeList) {
        Iterator i = typeList.iterator();
        while (i.hasNext()) {
            add((TypeDotNet) i.next());
        }
    }

    private void addJavaPackageClass(TypeDotNet type) {
        String className = type.getFullName();
        if (!_javaPackageList.containsKey(className)) {
            _javaPackageList.put(className, className);
        }
    }

    private void addJavaxPackageClass(TypeDotNet type) {
        String className = type.getFullName();
        if (!_javaxPackageList.containsKey(className)) {
            _javaxPackageList.put(className, className);
        }
    }

    private void addOtherPackageClass(TypeDotNet type) {
        String className = type.getFullName();
        if (!_otherPackageList.containsKey(className)) {
            _otherPackageList.put(className, className);
        }
    }

    private boolean isJavaLangPackage(TypeDotNet type) {
        return type.getNameSpace().startsWith("java.lang");
    }

    private boolean isJavaPackage(TypeDotNet type) {
        return type.getNameSpace().startsWith("java.");
    }

    private boolean isJavaxPackage(TypeDotNet type) {
        return type.getNameSpace().startsWith("javax.");
    }

    private String expandImportType(String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("using ");
        if (type.endsWith("[]")) {
            // pbP[W̏I[ [] ͕svȂ̂ŏ܂B
            type = type.substring(0, type.length() - 2);
        }
        sb.append(type);
        sb.append(";");
        return new String(sb);
    }

    public List expand() {
        expandPackageList(_javaPackageList.values().iterator());

        if (_javaPackageList.size() != 0) {
            _codeList.add("");
        }

        expandPackageList(_javaxPackageList.values().iterator());

        if (_javaxPackageList.size() != 0) {
            _codeList.add("");
        }

        expandPackageList(_otherPackageList.values().iterator());

        return _codeList;
    }

    private void expandPackageList(Iterator iterator) {
        final HashMap processedNamespace = new HashMap();
        while (iterator.hasNext()) {
            String nameSpace = (String) iterator.next();

            if (nameSpace.startsWith("java.")) {
                System.out.println("xFJavǎ^[" + nameSpace
                        + "]C|[g悤ƂĂ܂");
            }

            if (nameSpace.lastIndexOf('.') >= 0) {
                nameSpace = nameSpace.substring(0, nameSpace.lastIndexOf('.'));
            }
            if (processedNamespace.get(nameSpace) == null) {
                _codeList.add(expandImportType(nameSpace));
                processedNamespace.put(nameSpace, nameSpace);
            }

        }
    }

    public void clear() {
        _codeList.clear();
        _javaPackageList.clear();
        _javaxPackageList.clear();
        _otherPackageList.clear();
    }
}
