/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.javadoc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * .NET Frameworkp CodeGenerator֘ANX<br>
 * .NETł JavaDocƂ͌Ăт܂񂪁A ̎ JavaDocŎ܂B
 * 
 * @author IGA Tosiki
 */
public class MethodJavaDocDotNet extends JavaDocDotNet {

    private String _return = "";

    private List _parameters = new ArrayList();

    private List _exceptions = new ArrayList();

    private boolean _deprecated = false;

    private String _deprecatedExposition = "";

    public MethodJavaDocDotNet() {
    }

    public boolean isEmpty() {
        int size = _parameters.size() + _exceptions.size();
        return super.isEmpty() && size == 0 && _return.equals("");
    }

    public void addReturn(String doc) {
        StringBuffer sb = new StringBuffer();
        sb.append("<returns>");
        sb.append(doc);
        sb.append("</returns>");
        _return = sb.toString();
    }

    public void addParameter(String name, String doc) {
        StringBuffer sb = new StringBuffer();
        sb.append("<param name=\"");
        sb.append(name);
        sb.append("\">");
        sb.append(doc);
        sb.append("</param>");
        _parameters.add(sb.toString());
    }

    public void expandJavaDoc() {
        if (!_parameters.isEmpty()) {
            for (Iterator ite = _parameters.iterator(); ite.hasNext();) {
                String look = (String) ite.next();
                addLine2(look);
            }
        }

        if (!_return.equals("")) {
            addLine2(_return);
        }

        if (_deprecated) {
            addLine2("@deprecated " + _deprecatedExposition);
        }
    }

    public void addLines(Iterator docs) {
        while (docs.hasNext()) {
            addLine((String) docs.next());
        }
    }

    public void setDeplicated(String exposition) {
        _deprecated = true;
        _deprecatedExposition = exposition;
    }
}
