/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class MulBlankCell
implements Cell,
CellFeaturesAccessor {
    private static Logger logger = Logger.getLogger(MulBlankCell.class);
    private int row;
    private int column;
    private CellFormat cellFormat;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private SheetImpl sheet;
    private CellFeatures features;

    public MulBlankCell(int r, int c, int xfi, FormattingRecords fr, SheetImpl si) {
        this.row = r;
        this.column = c;
        this.xfIndex = xfi;
        this.formattingRecords = fr;
        this.sheet = si;
        this.initialized = false;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public String getContents() {
        return "";
    }

    public CellType getType() {
        return CellType.EMPTY;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    public boolean isHidden() {
        ColumnInfoRecord cir = this.sheet.getColumnInfo(this.column);
        if (cir != null && cir.getWidth() == 0) {
            return true;
        }
        RowRecord rr = this.sheet.getRowInfo(this.row);
        return rr != null && (rr.getRowHeight() == 0 || rr.isCollapsed());
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cf) {
        if (this.features != null) {
            logger.warn("current cell features not null - overwriting");
        }
        this.features = cf;
    }
}

