/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.File;

import blanco.fixedlength.resourcebundle.BlancoFixedLengthRuntimeUtilResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructure;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

public class BlancoFixedLengthExpandRuntimeUtil {
    final BlancoFixedLengthRuntimeUtilResourceBundle bundle = new BlancoFixedLengthRuntimeUtilResourceBundle();

    public void expand(final BlancoFixedLengthStructure processStructure,
            final File directoryTarget) {

        final String className = bundle.getClassName();
        final String classNameblancoFixedLengthIOException = processStructure
                .getRuntimePackage()
                + ".io.BlancoFixedLengthIOException";
        final ClassExpander classExpander = new ClassExpander(new Type(
                processStructure.getRuntimePackage()
                        + bundle.getPackagePrefix(), className)) {
            protected void expandClassStruct() {
                addFileComment(bundle.getFilecomment());
                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new MethodExpander(bundle.getReadtokenName()) {
                    protected boolean isStatic() {
                        return true;
                    }

                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(bundle.getReadtokenJavadoc());
                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg01Type()), bundle
                                .getReadtokenArg01Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg01Name(),
                                bundle.getReadtokenArg01Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg02Type()), bundle
                                .getReadtokenArg02Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg02Name(),
                                bundle.getReadtokenArg02Javadoc());

                        addArgument(new Value(new Type(bundle
                                .getReadtokenArg03Type()), bundle
                                .getReadtokenArg03Name()));
                        getJavaDoc().addParameter(
                                bundle.getReadtokenArg03Name(),
                                bundle.getReadtokenArg03Javadoc());

                        setReturnType(new Type(bundle.getReadtokenReturnType()));
                        getJavaDoc().addReturn(
                                bundle.getReadtokenReturnJavadoc());

                        addException(new Type(
                                classNameblancoFixedLengthIOException));
                        getJavaDoc()
                                .addException(
                                        new Type(
                                                classNameblancoFixedLengthIOException),
                                        "ڐȂȂǗ^ꂽɊւOꍇB");
                        addException(new Type(bundle.getReadtokenThrows01Type()));
                        getJavaDoc().addException(
                                new Type(bundle.getReadtokenThrows01Type()),
                                bundle.getReadtokenThrows01Javadoc());
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine(bundle.getReadtokenLine01());
                        getData().addLine(bundle.getReadtokenLine02());
                        getData().addLine(bundle.getReadtokenLine03());
                        getData().addLine(bundle.getReadtokenLine04());
                        getData().addLine(bundle.getReadtokenLine05());
                        getData().addLine(bundle.getReadtokenLine06());
                        getData().addLine(bundle.getReadtokenLine07());
                        getData().addLine(bundle.getReadtokenLine08());
                        getData().addLine(bundle.getReadtokenLine09());
                        getData().addLine(bundle.getReadtokenLine10());
                        getData().addLine(bundle.getReadtokenLine11());
                        getData().addLine(bundle.getReadtokenLine12());
                        getData().addLine(bundle.getReadtokenLine13());
                        getData().addLine(bundle.getReadtokenLine14());
                        getData().addLine(bundle.getReadtokenLine15());
                        getData().addLine(bundle.getReadtokenLine16());
                        getData().addLine(bundle.getReadtokenLine17());
                        getData().addLine(bundle.getReadtokenLine18());
                        getData().addLine(bundle.getReadtokenLine19());
                        getData().addLine(bundle.getReadtokenLine20());
                        getData().addLine(bundle.getReadtokenLine21());
                        getData().addLine(bundle.getReadtokenLine22());
                        getData().addLine(bundle.getReadtokenLine23());
                        getData().addLine(bundle.getReadtokenLine24());
                        getData().addLine(bundle.getReadtokenLine25());
                        getData().addLine(bundle.getReadtokenLine26());
                        getData().addLine(bundle.getReadtokenLine27());
                        getData().addLine(bundle.getReadtokenLine28());
                        getData().addLine(bundle.getReadtokenLine29());
                        getData().addLine(bundle.getReadtokenLine30());
                        getData().addLine(bundle.getReadtokenLine31());
                    }
                });

                addMethod(new MethodExpander("padRight") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("^ꂽw̒܂ŉEpfBO܂B");

                        getJavaDoc().addParameter("argSource", "͕B");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argSource"));

                        getJavaDoc()
                                .addParameter("argLength", "ڕWƂg[^oCgB");
                        addArgument(new Value(new Type("int"), "argLength"));

                        getJavaDoc().addParameter("argPadChar",
                                "߂ۂɗppfBOB");
                        addArgument(new Value(new Type("char"), "argPadChar"));

                        getJavaDoc()
                                .addParameter("argEncoding",
                                        "oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argEncoding"));

                        getJavaDoc().addReturn("ڕWƂȂoCgɉHꂽ̕B");
                        setReturnType(new Type("java.lang.String"));
                    }

                    public void implement() {
                        getData().addLine("if (argSource == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\"padRight͕̓ null^܂B\");");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("String result = argSource;");
                        getData().addLine("for (;;) {");
                        getData()
                                .addLine(
                                        "if (getBytesLength(result, argEncoding) >= argLength) {");
                        getData().addLine("break;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("// ꕶ₵Ă܂B");
                        getData().addLine("result = result + argPadChar;");
                        getData().addLine("}");
                        getData().addLine("return result;");
                    }
                });

                addMethod(new MethodExpander("padLeft") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("^ꂽw̒܂ōpfBO܂B");

                        getJavaDoc().addParameter("argSource", "͕B");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argSource"));

                        getJavaDoc()
                                .addParameter("argLength", "ڕWƂg[^oCgB");
                        addArgument(new Value(new Type("int"), "argLength"));

                        getJavaDoc().addParameter("argPadChar",
                                "߂ۂɗppfBOB");
                        addArgument(new Value(new Type("char"), "argPadChar"));

                        getJavaDoc()
                                .addParameter("argEncoding",
                                        "oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argEncoding"));

                        getJavaDoc().addReturn("ڕWƂȂoCgɉHꂽ̕B");
                        setReturnType(new Type("java.lang.String"));
                    }

                    public void implement() {
                        getData().addLine("if (argSource == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\"padLeft͕̓ null^܂B\");");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("String result = argSource;");
                        getData().addLine("for (;;) {");
                        getData()
                                .addLine(
                                        "if (getBytesLength(result, argEncoding) >= argLength) {");
                        getData().addLine("break;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("// ꕶ₵Ă܂B");
                        getData().addLine("result = argPadChar + result;");
                        getData().addLine("}");
                        getData().addLine("return result;");
                    }
                });

                addMethod(new MethodExpander("getBytesLength") {
                    protected Scope getScope() {
                        return Scope.PRIVATE;
                    }

                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine("^ꂽ̃oCg擾܂B");

                        getJavaDoc().addParameter("argSource", "͕B");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argSource"));

                        getJavaDoc()
                                .addParameter("argEncoding",
                                        "oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB");
                        addArgument(new Value(new Type("java.lang.String"),
                                "argEncoding"));

                        getJavaDoc().addReturn("͕̃oCgB");
                        setReturnType(new Type("int"));
                    }

                    public void implement() {
                        addImport(new Type(
                                "java.io.UnsupportedEncodingException"));
                        getData().addLine("if (argSource == null) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\"getBytesLength͕̓ null^܂B\");");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("if (argEncoding == null) {");
                        getData()
                                .addLine("return argSource.getBytes().length;");
                        getData().addLine("} else {");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "return argSource.getBytes(argEncoding).length;");
                        getData().addLine(
                                "} catch (UnsupportedEncodingException ex) {");
                        getData()
                                .addLine(
                                        "throw new IllegalArgumentException(\"T|[gȂGR[fBO[\" + argEncoding + \"]w肳܂B\" + ex.toString());");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
