/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

import blanco.commons.util.BlancoJavaSourceUtil;

public class BlancoValueObjectDotNetUtil {
    /**
     * stŁA^ꂽC#.NETXMLRgƂăGXP[v܂B
     * 
     * @param arg
     *            GXP[vsB
     * @return GXP[vꂽƂ̕
     */
    public static final String[] escapeStringAsCsDocWithNewLine(final String arg) {
        final ArrayList result = new ArrayList();
        try {
            final BufferedReader reader = new BufferedReader(new StringReader(
                    arg));
            try {
                for (;;) {
                    final String readLine = reader.readLine();
                    if (readLine == null) {
                        break;
                    }
                    result.add(BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc(readLine));
                }
            } finally {
                reader.close();
            }
        } catch (IOException e) {
            throw new IllegalArgumentException("肦Ȃo͗O܂B"
                    + e.toString());
        }

        // ArrayListz񉻂܂B
        final String[] returnValue = new String[result.size()];
        result.toArray(returnValue);
        for (int index = 0; index < returnValue.length; index++) {
            String readLine = returnValue[index];
            if (index < returnValue.length - 1) {
                // Ō̍sȊO st^܂B
                readLine += "\n";
            }
            // 񒆂ׂ̂Ẳs𖳌܂B
            //  C#.NET̉sꂾłB
            readLine = readLine.replaceAll("\n", "");
            returnValue[index] = readLine;
        }
        return returnValue;
    }
}
