/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.fixedlength.BlancoFixedLengthConstants;
import blanco.fixedlength.BlancoFixedLengthMeta2Xml;
import blanco.fixedlength.BlancoFixedLengthXml2JavaClass;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthResourceBundle;

/**
 * BlancoFixedLengthAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoFixedLengthTask extends AbstractBlancoFixedLengthTask {
    private final BlancoFixedLengthResourceBundle fBundle = new BlancoFixedLengthResourceBundle();

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoFixedLengthTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoFixedLengthConstants.PRODUCT_NAME
                + " (" + BlancoFixedLengthConstants.VERSION + ")");

        try {
            final File blancoTmpDirectory = new File(getTmpdir()
                    + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
            blancoTmpDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            new BlancoFixedLengthMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir()
                            + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);

            final File tempValueObjectFolder = new File(getTmpdir()
                    + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY
                    + BlancoFixedLengthConstants.VALUE_OBJECT_DIRECTORY);
            tempValueObjectFolder.mkdirs();

            final File[] fileTmp = blancoTmpDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoFixedLengthXml2JavaClass().process(
                            fileTmp[index], getRuntimepackage(),
                            tempValueObjectFolder, new File(getTargetdir()),
                            getJunit().equals("true"));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
