/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.File;

import blanco.fixedlength.resourcebundle.BlancoFixedLengthIOExceptionDotNetResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructureDotNet;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.Constructor;

public class BlancoFixedLengthExpandIOExceptionDotNet {
    private final BlancoFixedLengthIOExceptionDotNetResourceBundle bundle = new BlancoFixedLengthIOExceptionDotNetResourceBundle();

    public void expand(final BlancoFixedLengthStructureDotNet processStructure,
            final File directoryTarget) {

        final String packageName = processStructure.getRuntimePackage()
                + bundle.getPackagePrefix();
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName, bundle.getClassName())) {
            protected void expandClassStruct() {
                setSuperClass(new Type(bundle.getSuperclassName()));
                addFileComment(bundle.getFilecomment());

                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "bZ[W𔺂blancoFixedLengthONX𐶐܂B");

                        // qݒB
                        getCgMethod().setSuperclassInvocation("base(message)");

                        getJavaDoc().addParameter("message", "bZ[WB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), "message"));
                    }

                    public void implement() {
                    }
                });

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "bZ[Wь𔺂blancoFixedLengthONX𐶐܂B");

                        // qݒB
                        getCgMethod().setSuperclassInvocation(
                                "base(message, innerException)");

                        getJavaDoc().addParameter("message", "bZ[WB");
                        getJavaDoc().addParameter("innerException",
                                "Ƃ̗OIuWFNgB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), "message"));
                        addArgument(new IgValue(new IgType("System.Exception"),
                                "innerException"));
                    }

                    public void implement() {
                    }
                });
            }
        };

        ClassExpander.generateCsSource(classExpander, directoryTarget);
    }
}
