/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoXmlUtil;
import blanco.fixedlength.expand.BlancoFixedLengthExpandIOException;
import blanco.fixedlength.expand.BlancoFixedLengthExpandReader;
import blanco.fixedlength.expand.BlancoFixedLengthExpandRecord;
import blanco.fixedlength.expand.BlancoFixedLengthExpandRuntimeUtil;
import blanco.fixedlength.expand.BlancoFixedLengthExpandWriter;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthFieldStructure;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructure;

public class BlancoFixedLengthXml2JavaClass {
    private final BlancoFixedLengthResourceBundle fBundle = new BlancoFixedLengthResourceBundle();

    private String fRuntimePackage = null;

    /**
     * ^ꂽԃt@CA^ꂽԃfBNgpȂA^[QbgfBNgɐ܂B
     * 
     * @param fileXmlSource
     *            ԃt@C
     * @param runtimePackage
     *            ^CpbP[WBw̏ꍇɂ͒`̒l𗘗pB
     * @param directoryValueObjectWork
     *            VÔ߂̃[NfBNgB
     * @param directoryBlancoTarget
     *            \[XR[ho͐ blanco tH_B
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File fileXmlSource, final String runtimePackage,
            final File directoryValueObjectWork,
            final File directoryBlancoTarget, final boolean isGenerateJUnit)
            throws TransformerException {
        fRuntimePackage = runtimePackage;

        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileXmlSource);

        try {
            final Node rootNode = result.getNode();
            if (rootNode instanceof Document) {
                // ꂪnBhLg[g擾
                final Document rootDocument = (Document) rootNode;
                final NodeList listSheet = rootDocument
                        .getElementsByTagName("sheet");
                final int sizeListSheet = listSheet.getLength();
                for (int index = 0; index < sizeListSheet; index++) {
                    final Element elementSheet = (Element) listSheet
                            .item(index);

                    final NodeList listCommon = elementSheet
                            .getElementsByTagName(fBundle
                                    .getMeta2xmlElementCommon());
                    if (listCommon.getLength() == 0) {
                        // commonꍇɂ̓XLbv܂B
                        continue;
                    }

                    final Element elementCommon = (Element) listCommon.item(0);

                    final BlancoFixedLengthStructure processStructure = new BlancoFixedLengthStructure();

                    processStructure.setFileDefinitionId(BlancoXmlUtil
                            .getTextContent(elementCommon, "fileDefinitionId"));
                    if (processStructure.getFileDefinitionId() == null) {
                        // t@C`ID`̂̂͏XLbv܂B
                        continue;
                    }

                    processStructure.setPackageName(BlancoXmlUtil
                            .getTextContent(elementCommon, "packageName"));
                    if (processStructure.getPackageName() == null) {
                        throw new IllegalArgumentException(fBundle
                                .getXml2javaclassErr001(processStructure
                                        .getFileDefinitionId()));
                    }

                    processStructure.setFileDescription(BlancoXmlUtil
                            .getTextContent(elementCommon, "fileDescription"));

                    // ^CpbP[W̊mB
                    if (fRuntimePackage != null
                            && fRuntimePackage.trim().length() > 0) {
                        // ^CpbP[W̎w肪ꍇɂ͂𗘗p܂B
                        processStructure.setRuntimePackage(fRuntimePackage);
                    } else {
                        // ^CpbP[W̎w肪Ȃꍇɂ́A`̃pbP[W𗘗p܂B
                        processStructure.setRuntimePackage(processStructure
                                .getPackageName());
                    }

                    processStructure.setEncoding(BlancoXmlUtil.getTextContent(
                            elementCommon, "encoding"));

                    final NodeList listRow = elementSheet
                            .getElementsByTagName("field");
                    final int sizeListRow = listRow.getLength();
                    for (int indexField = 0; indexField < sizeListRow; indexField++) {
                        final Element elementField = (Element) listRow
                                .item(indexField);

                        final BlancoFixedLengthFieldStructure field = new BlancoFixedLengthFieldStructure();

                        field.setName(BlancoXmlUtil.getTextContent(
                                elementField, "name"));
                        if (field.getName() == null) {
                            continue;
                        }

                        field.setType(BlancoXmlUtil.getTextContent(
                                elementField, "type"));
                        field.setNo(BlancoXmlUtil.getTextContent(elementField,
                                "no"));
                        field.setDescription(BlancoXmlUtil.getTextContent(
                                elementField, "description"));
                        field.setLength(BlancoXmlUtil.getTextContent(
                                elementField, "length"));
                        field.setDefault(BlancoXmlUtil.getTextContent(
                                elementField, "default"));
                        field.setFormat(BlancoXmlUtil.getTextContent(
                                elementField, "format"));

                        if (field.getType() == null) {
                            throw new IllegalArgumentException(fBundle
                                    .getXml2javaclassErr004(processStructure
                                            .getFileDefinitionId(), field
                                            .getName()));
                        }
                        if (field.getType().equals("java.util.Date")) {
                            if (field.getFormat() == null) {
                                throw new IllegalArgumentException(fBundle
                                        .getXml2javaclassErr005(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName()));
                            }
                        } else {
                            if (field.getFormat() != null) {
                                throw new IllegalArgumentException(fBundle
                                        .getXml2javaclassErr006(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName()));
                            }
                        }

                        if (field.getLength() == null) {
                            throw new IllegalArgumentException("t@C`ID["
                                    + processStructure.getFileDefinitionId()
                                    + "] [" + field.getName() + "]̒włB");
                        }

                        if (field.getLength() != null) {
                            try {
                                if (Integer.parseInt(field.getLength()) < 0) {
                                    // 0ȏ݂̐̂w\
                                    throw new IllegalArgumentException(
                                            fBundle
                                                    .getXml2javaclassErr007(
                                                            processStructure
                                                                    .getFileDefinitionId(),
                                                            field.getName(),
                                                            field.getLength()));
                                }
                            } catch (NumberFormatException ex) {
                                throw new IllegalArgumentException(fBundle
                                        .getXml2javaclassErr008(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName(), field
                                                        .getLength()));
                            }
                        }

                        processStructure.getListField().add(field);
                    }

                    expandSheet(processStructure, elementSheet, elementCommon,
                            directoryValueObjectWork, directoryBlancoTarget,
                            isGenerateJUnit);
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementSheet
     * @param elementCommon
     * @param directoryValueObjectWork
     * @param directoryTarget
     * @param isGenerateJUnit
     * @throws IOException
     * @throws TransformerException
     */
    private static void expandSheet(
            final BlancoFixedLengthStructure processStructure,
            final Element elementSheet, final Element elementCommon,
            final File directoryValueObjectWork, final File directoryTarget,
            final boolean isGenerateJUnit) throws IOException,
            TransformerException {
        // ŏɃR[hWJ邱ƂƂ܂B
        // R[h̏̒ɑÓ`FbNȂǂ܂߂邱ƂƂ܂B
        BlancoFixedLengthExpandRecord.expand(processStructure,
                directoryValueObjectWork, directoryTarget, isGenerateJUnit);
        new BlancoFixedLengthExpandReader().expand(processStructure,
                directoryTarget);
        new BlancoFixedLengthExpandWriter().expand(processStructure,
                directoryTarget);

        new BlancoFixedLengthExpandIOException().expand(processStructure,
                directoryTarget);
        new BlancoFixedLengthExpandRuntimeUtil().expand(processStructure,
                directoryTarget);
    }
}
