/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.File;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthResourceBundle;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthWriterResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthFieldStructure;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructure;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoFixedLengthExpandWriter {
    final BlancoFixedLengthResourceBundle bundle = new BlancoFixedLengthResourceBundle();

    final BlancoFixedLengthWriterResourceBundle writerBundle = new BlancoFixedLengthWriterResourceBundle();

    public void expand(final BlancoFixedLengthStructure processStructure,
            final File directoryTarget) {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + writerBundle.getClassNameSuffix();
        final Type typeIOException = new Type(processStructure
                .getRuntimePackage()
                + writerBundle.getAddusingtype01Suffix());
        final ClassExpander classExpander = new ClassExpander(new Type(
                processStructure.getPackageName()
                        + writerBundle.getPackagePrefix(), className)) {
            protected void expandClassStruct() {
                addImport(typeIOException);
                addFileComment(writerBundle.getFilecomment());

                getJavaDoc()
                        .addLine(
                                writerBundle
                                        .getClasscomment01(processStructure
                                                .getFileDefinitionId()
                                                + (processStructure
                                                        .getFileDescription() == null ? ""
                                                        : "/"
                                                                + processStructure
                                                                        .getFileDescription())));
                getJavaDoc().addLine(writerBundle.getClasscomment02());
                if (processStructure.getEncoding() == null) {
                    getJavaDoc()
                            .addLine(writerBundle.getClasscomment03Case01());
                } else {
                    getJavaDoc().addLine(
                            writerBundle
                                    .getClasscomment03Case02(processStructure
                                            .getEncoding()));
                }
                getJavaDoc().addLine(writerBundle.getClasscomment04());

                final FieldExpander field1 = new FieldExpander(new Type(
                        writerBundle.getFieldWriterType()), writerBundle
                        .getFieldWriterName());
                field1.getJavaDoc().addLine(
                        writerBundle.getFieldWriterJavadoc01());
                field1.getJavaDoc().addLine(
                        writerBundle.getFieldWriterJavadoc02());
                addField(field1);

                final FieldExpander field2 = new FieldExpander(new Type(
                        writerBundle.getFieldLineCounterType()), writerBundle
                        .getFieldLineCounterName());
                field2.getJavaDoc().addLine(
                        writerBundle.getFieldLineCounterJavadoc01());
                field2.getJavaDoc().addLine(
                        writerBundle.getFieldLineCounterJavadoc02());
                field2.setDefaultStatement(new Statement(writerBundle
                        .getFieldLineCounterDefault()));
                addField(field2);

                // uvΉ
                for (int indexField = 0; indexField < processStructure
                        .getListField().size(); indexField++) {
                    final BlancoFixedLengthFieldStructure field = (BlancoFixedLengthFieldStructure) processStructure
                            .getListField().get(indexField);

                    if (field.getType().equals("java.util.Date")) {
                        final FieldExpander field3 = new FieldExpander(
                                new Type("java.text.SimpleDateFormat"),
                                writerBundle
                                        .getFieldSimpleDateFormatNamePrefix()
                                        + BlancoNameAdjuster.toClassName(field
                                                .getName()));
                        field3
                                .getJavaDoc()
                                .addLine(
                                        writerBundle
                                                .getFieldSimpleDateFormatJavadoc01(field
                                                        .getName()));
                        field3.getJavaDoc().addLine(
                                writerBundle
                                        .getFieldSimpleDateFormatJavadoc02());
                        addField(field3);
                    }
                }

                addMethod(new Constructor(className) {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                writerBundle.getConstructor01Javadoc01());
                        getJavaDoc().addLine(
                                writerBundle.getConstructor01Javadoc02());
                        getJavaDoc().addParameter("arg",
                                writerBundle.getConstructor01Arg01Javadoc01());
                        addArgument(new Value(new Type(writerBundle
                                .getConstructor01Arg01Type()), "arg"));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("fWriter = arg;");

                        // uvΉ
                        for (int indexField = 0; indexField < processStructure
                                .getListField().size(); indexField++) {
                            final BlancoFixedLengthFieldStructure field = (BlancoFixedLengthFieldStructure) processStructure
                                    .getListField().get(indexField);

                            if (field.getType().equals("java.util.Date")) {
                                getData()
                                        .addLine(
                                                "fSimpleDateFormat"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + " = new SimpleDateFormat("
                                                        + (field.getFormat() == null ? "\"yyyy/MM/dd\""
                                                                : "\""
                                                                        + field
                                                                                .getFormat()
                                                                        + "\"")
                                                        + ");");
                            }
                        }
                    }
                });

                final String recordClassName = processStructure
                        .getPackageName()
                        + ".record."
                        + BlancoNameAdjuster.toClassName(processStructure
                                .getFileDefinitionId()) + "FixedLengthRecord";

                addMethod(new MethodExpander("writeRecord") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                writerBundle.getWriterecordJavadoc01());
                        getJavaDoc().addLine(
                                writerBundle.getWriterecordJavadoc02());
                        getJavaDoc().addParameter("record",
                                writerBundle.getWriterecordArg01Javadoc());
                        getJavaDoc().addException(typeIOException,
                                writerBundle.getWriterecordThrows01Javadoc());
                        getJavaDoc().addException(
                                new Type(writerBundle
                                        .getWriterecordThrows02Type()),
                                writerBundle.getWriterecordThrows02Javadoc());
                        addArgument(new Value(new Type(recordClassName),
                                "record"));
                        addException(typeIOException);
                        addException(new Type(writerBundle
                                .getWriterecordThrows02Type()));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("String writeToken = null;");
                        for (int indexField = 0; indexField < processStructure
                                .getListField().size(); indexField++) {
                            final BlancoFixedLengthFieldStructure field = (BlancoFixedLengthFieldStructure) processStructure
                                    .getListField().get(indexField);

                            getData().addLine("");
                            getData()
                                    .addLine(
                                            writerBundle
                                                    .getWriterecordLine01(
                                                            (field.getNo() == null ? ""
                                                                    : bundle
                                                                            .getFieldNo(field
                                                                                    .getNo())
                                                                            + " "),
                                                            field.getName()
                                                                    + (field
                                                                            .getDescription() == null ? ""
                                                                            : "/"
                                                                                    + field
                                                                                            .getDescription())));

                            if (field.getType().equals("java.lang.String")) {
                                // CӍڂł̂ null͒0̕ւƓǂݑւ܂B
                                getData()
                                        .addLine(
                                                "// CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B");
                                getData().addLine("// ̏ꍇɂ͒`FbN͍s܂B");
                                getData()
                                        .addLine(
                                                "writeToken = record.get"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "() == null ? \"\" : record.get"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "();");
                            } else if (field.getType().equals("int")
                                    || field.getType().equals("long")) {
                                // CӍځB
                                getData().addLine(
                                        "writeToken = String.valueOf(record.get"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + "());");
                            } else if (field.getType().equals("java.util.Date")) {
                                addUsingType(new Type("java.io.IOException"));
                                getData().addLine(
                                        "if (record.get"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + "() == null) {");
                                getData()
                                        .addLine(
                                                "throw new BlancoFixedLengthIOException(\""
                                                        + bundle
                                                                .getCsvWriterErr011(getLocationString(
                                                                        indexField,
                                                                        field
                                                                                .getNo(),
                                                                        field
                                                                                .getName(),
                                                                        field
                                                                                .getDescription()))
                                                        + "\");");
                                getData().addLine("}");
                                getData().addLine(
                                        "writeToken = fSimpleDateFormat"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + ".format(record.get"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + "());");
                            } else if (field.getType().equals(
                                    "java.math.BigDecimal")) {
                                // java.math.BigDecimal̃C|[g͕svB
                                getData()
                                        .addLine(
                                                "writeToken = record.get"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "() == null ? \"\" : record.get"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "().toString();");
                            } else {
                                getData().addLine(
                                        bundle.getNotSupportedType(field
                                                .getType()));
                                getData().addLine("writeToken = \"\";");
                            }

                            final String encodingStringOrNull = processStructure
                                    .getEncoding() == null ? "null" : "\""
                                    + processStructure.getEncoding() + "\"";

                            String strPadDirection = "Right";
                            if (field.getType().equals("int")
                                    || field.getType().equals("long")
                                    || field.getType().equals(
                                            "java.math.BigDecimal")) {
                                strPadDirection = "Left";
                            }

                            addUsingType(new Type(processStructure
                                    .getRuntimePackage()
                                    + ".util.BlancoFixedLengthRuntimeUtil"));
                            getData().addLine("// w̒܂ŃpfBO܂B");
                            getData().addLine(
                                    "writeToken = BlancoFixedLengthRuntimeUtil.pad"
                                            + strPadDirection + "(writeToken, "
                                            + field.getLength() + ", ' ', "
                                            + encodingStringOrNull + ");");

                            final String encodingStringOrBlank = (processStructure
                                    .getEncoding() == null ? "" : "\""
                                    + processStructure.getEncoding() + "\"");
                            getData().addLine(
                                    "if (writeToken.getBytes("
                                            + encodingStringOrBlank
                                            + ").length < " + field.getLength()
                                            + ") {");
                            getData()
                                    .addLine(
                                            "throw new BlancoFixedLengthIOException(\""
                                                    + bundle
                                                            .getCsvWriterErr001(
                                                                    getLocationString(
                                                                            indexField,
                                                                            field
                                                                                    .getNo(),
                                                                            field
                                                                                    .getName(),
                                                                            field
                                                                                    .getDescription()),
                                                                    field
                                                                            .getLength())
                                                    + "\");");
                            getData().addLine("}");

                            getData().addLine(
                                    "if (writeToken.getBytes("
                                            + encodingStringOrBlank
                                            + ").length > " + field.getLength()
                                            + ") {");
                            getData()
                                    .addLine(
                                            "throw new BlancoFixedLengthIOException(\""
                                                    + bundle
                                                            .getCsvWriterErr002(
                                                                    getLocationString(
                                                                            indexField,
                                                                            field
                                                                                    .getNo(),
                                                                            field
                                                                                    .getName(),
                                                                            field
                                                                                    .getDescription()),
                                                                    field
                                                                            .getLength())
                                                    + "\");");
                            getData().addLine("}");

                            getData().addLine("fWriter.write(writeToken);");
                        }
                        getData().addLine("");
                        getData().addLine(writerBundle.getWriterecordLine03());
                        getData().addLine("fWriter.newLine();");
                        getData().addLine("fLineCounter++;");
                    }
                });

                addMethod(new MethodExpander("getLineCounter") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine("ݏ̍sJE^Ԃ܂B");
                        getJavaDoc().addReturn("ݏ̍sJE^B");
                        setReturnType(new Type("long"));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("return fLineCounter;");
                    }
                });

                addMethod(new MethodExpander("flush") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(writerBundle.getFlushJavadoc01());
                        getJavaDoc().addLine(writerBundle.getFlushJavadoc02());
                        getJavaDoc().addException(
                                new Type(writerBundle.getFlushThrows01Type()),
                                writerBundle.getFlushThrows01Javadoc());
                        addException(new Type(writerBundle
                                .getFlushThrows01Type()));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("fWriter.flush();");
                    }
                });

                addMethod(new MethodExpander("close") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(writerBundle.getCloseJavadoc01());
                        getJavaDoc().addLine(writerBundle.getCloseJavadoc02());
                        getJavaDoc().addException(
                                new Type(writerBundle.getCloseThrows01Type()),
                                writerBundle.getCloseThrows01Javadoc());
                        addException(new Type(writerBundle
                                .getCloseThrows01Type()));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("fWriter.close();");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }

    private String getLocationString(int indexField, String fieldNo,
            String fieldName, String fieldDescription) {
        return writerBundle.getGetlocationstringLine01("" + (indexField + 1),
                (fieldNo == null ? "" : bundle.getFieldNo(fieldNo) + " "),
                fieldName
                        + (fieldDescription == null ? "" : "/"
                                + fieldDescription));
    }
}
