/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.File;

import blanco.fixedlength.resourcebundle.BlancoFixedLengthIOExceptionResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructure;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.Constructor;

public class BlancoFixedLengthExpandIOException {
    private final BlancoFixedLengthIOExceptionResourceBundle bundle = new BlancoFixedLengthIOExceptionResourceBundle();

    public void expand(final BlancoFixedLengthStructure processStructure,
            final File directoryTarget) {

        final String packageName = processStructure.getRuntimePackage()
                + bundle.getPackagePrefix();
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName, bundle.getClassName())) {
            protected void expandClassStruct() {
                setSuperClass(new Type(bundle.getSuperclassName()));
                addFileComment(bundle.getFilecomment());

                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "bZ[W𔺂blancoFixedLengthONX𐶐܂B");
                        getJavaDoc().addParameter("message", "bZ[WB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), "message"));
                    }

                    public void implement() {
                        getData().addLine(bundle.getConstructor01Line01());
                    }
                });

                addMethod(new Constructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "bZ[Wь𔺂blancoFixedLengthONX𐶐܂B");
                        getJavaDoc().addParameter("message", "bZ[WB");
                        getJavaDoc().addParameter("argCause", "ƂȂOIuWFNgB");
                        addArgument(new Value(new Type(bundle
                                .getConstructor01Arg01Type()), "message"));
                        addArgument(new Value(new Type("java.lang.Throwable"),
                                "argCause"));
                    }

                    public void implement() {
                        getData().addLine("super(message, argCause);");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
