/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.fixedlength.valueobject.BlancoFixedLengthFieldStructure;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructure;
import blanco.test.valueobject.BlancoValueObjectXml2JUnit;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.concretesax.BlancoValueObjectSerializer;

public class BlancoFixedLengthExpandRecord {
    /**
     * R[hWJ܂B
     * 
     * @param processStructure
     * @param direcotryValueObjectWork
     * @param directoryTarget
     * @param isGenerateJUnit
     * @throws IOException
     * @throws TransformerException
     */
    public static void expand(
            final BlancoFixedLengthStructure processStructure,
            final File direcotryValueObjectWork, final File directoryTarget,
            final boolean isGenerateJUnit) throws IOException,
            TransformerException {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + "FixedLengthRecord";
        final String packageName = processStructure.getPackageName()
                + ".record";
        final File filePojoWork = new File(direcotryValueObjectWork
                .getAbsolutePath()
                + "/" + className + ".xml");

        OutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    filePojoWork));
            final BlancoValueObjectSerializer serializer = new BlancoValueObjectSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementWorkbook();
            serializer.characters("\n");
            serializer.startElementSheet("ValueObject");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectCommon();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementName();
            // O
            serializer.characters(className);
            serializer.endElementName();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementPackage();
            serializer.characters(packageName);
            serializer.endElementPackage();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementDescription();
            serializer.characters("t@C`(Œ蒷)쐬ꂽR[hNX");
            serializer.endElementDescription();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementFileDescription();
            serializer.characters("t@C`["
                    + processStructure.getFileDefinitionId()
                    + (processStructure.getFileDescription() == null ? "" : "/"
                            + processStructure.getFileDescription())
                    + "]̃R[hNX\n");
            serializer.endElementFileDescription();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementBlancovalueobjectCommon();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectList();
            serializer.characters("\n");

            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoFixedLengthFieldStructure field = (BlancoFixedLengthFieldStructure) processStructure
                        .getListField().get(indexField);

                try {
                    String actualType = field.getType();

                    serializer.characters("    ");
                    serializer.startElementField();
                    serializer.characters("\n");
                    serializer.characters("      ");

                    if (field.getNo() != null) {
                        serializer.startElementNo();
                        serializer.characters(field.getNo());
                        serializer.endElementNo();
                    }

                    serializer.characters("\n");
                    serializer.characters("      ");
                    serializer.startElementName();
                    serializer.characters(field.getName());
                    serializer.endElementName();
                    serializer.characters("\n");
                    serializer.characters("      ");
                    serializer.startElementType();
                    serializer.characters(actualType);
                    serializer.endElementType();
                    serializer.characters("\n");

                    serializer.characters("      ");
                    serializer.startElementDescription();
                    if (field.getNo() != null) {
                        serializer.characters("ڔԍ: " + field.getNo() + "\n");
                    }
                    if (field.getDescription() != null) {
                        serializer.characters("ڂ̐: "
                                + field.getDescription() + "\n");
                    }

                    serializer.characters(": " + field.getLength() + "\n");

                    serializer.endElementDescription();
                    serializer.characters("\n");

                    if (field.getDefault() != null) {
                        serializer.characters("      ");
                        serializer.startElementDefault();
                        serializer.characters(field.getDefault());
                        serializer.endElementDefault();
                        serializer.characters("\n");
                    }

                    serializer.characters("    ");
                    serializer.endElementField();
                    serializer.characters("\n");
                } catch (SAXException e) {
                    e.printStackTrace();
                }
            }

            serializer.characters("  ");
            serializer.endElementBlancovalueobjectList();
            serializer.characters("\n");
            serializer.endElementSheet();
            serializer.characters("\n");
            serializer.endElementWorkbook();
            serializer.endDocument();

            outStream.flush();
            outStream.close();
            outStream = null;

            new BlancoValueObjectXml2JavaClass().process(filePojoWork,
                    directoryTarget);
            if (isGenerateJUnit) {
                new BlancoValueObjectXml2JUnit().process(filePojoWork,
                        directoryTarget);
            }
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
