/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * ValueObject\XMLt@C JUnitpJava\[XR[h܂B
 * 
 * String^̂߂̃eXg\bh𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitNotSupportedMethod {
    private final BlancoValueObjectTestResourceBundle fBundleTest = new BlancoValueObjectTestResourceBundle();

    /**
     * \bhWJ܂B
     * 
     * @param methodName
     *            \bhB
     * @param classInfo
     *            ͂ƂȂNXB
     * @param fieldInfo
     *            ͂ƂȂtB[hB
     * @param isNameAdjust
     *            Oό`sǂB
     * @param argFactory
     *            blancoCgt@NgB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argClass
     *            o͐NXB
     */
    public void expand(final String methodName,
            final BlancoValueObjectClassStructure classInfo,
            final BlancoValueObjectFieldStructure field,
            final boolean argNameAdjust, final BlancoCgObjectFactory argFactory,
            final BlancoCgSourceFile argSourceFile, final BlancoCgClass argClass) {
        final BlancoCgMethod method = argFactory.createMethod(methodName,
                fBundleTest.getMethodJavadoc001(field.getName()));
        argClass.getMethodList().add(method);

        method.getThrowList().add(
                argFactory.createException("java.lang.Exception", ""));

        Constructor findConstructor = null;

        final List listLine = method.getLineList();

        try {
            final Class findClass = Class.forName(field.getType());
            findConstructor = findClass.getConstructor(new Class[0]);

            if (Modifier.isPublic(findConstructor.getModifiers())) {
                method
                        .getLangDoc()
                        .getDescriptionList()
                        .add(
                                "NX["
                                        + classInfo.getName()
                                        + "]̃tB[h["
                                        + field.getName()
                                        + "]͌^["
                                        + field.getType()
                                        + "]łB̌^̃ftHgRXgN^ĂяoȂP̎s܂BftHgRXgN^̌Ăяop𔭐ꍇɂ́ÃtB[hɑ΂鎩P͎̎sȂłB<br>");
            } else {
                method.getLangDoc().getDescriptionList().add(
                        "TODO NX["
                                + classInfo.getName()
                                + "]̃tB[h["
                                + field.getName()
                                + "]͌^["
                                + field.getType()
                                + "]łǍ^̓ftHgRXgN^publicł͂Ȃ("
                                + Modifier.toString(findConstructor
                                        .getModifiers())
                                + ")ߒP͎̎̎ł܂B");
                // nullŃNA
                findConstructor = null;
            }
        } catch (ClassNotFoundException e) {
            // NX̃[hɎsꍇB̃P[X肦܂B
            method
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "TODO NX["
                                    + classInfo.getName()
                                    + "]̃tB[h["
                                    + field.getName()
                                    + "]Ɍ^["
                                    + field.getType()
                                    + "]w肳Ă܂Ǎ^̃CX^XɎs܂BLȌ^ł邩ǂmFĂBP͎̎̎ł܂B");
        } catch (NoSuchMethodException e) {
            // ftHgRXgN^擾łȂꍇB̃p^[͕ʂɂ肦܂B̂܂ܗ܂B
            method
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "TODO NX["
                                    + classInfo.getName()
                                    + "]̃tB[h["
                                    + field.getName()
                                    + "]͌^["
                                    + field.getType()
                                    + "]łǍ^̓ftHgRXgN^܂B̂ߒP͎̎̎ł܂B");
        }

        if (findConstructor == null) {
            listLine.add("// TODO NX[" + classInfo.getName() + "]̃tB[h["
                    + field.getName() + "]̒P̎ɂĂ͎̑Ώ۔͈͊OłB");
        } else {
            final String fieldNameAdjustered = (argNameAdjust == false ? field
                    .getName() : BlancoNameAdjuster
                    .toClassName(field.getName()));

            argSourceFile.getImportList().add(field.getType());

            listLine.add(fBundleTest.getMethodOtherobjectB01L01());
            listLine.add(fBundleTest.getMethodOtherobjectB01L02(classInfo
                    .getName()));
            listLine.add(fBundleTest.getMethodOtherobjectB01L03());

            listLine.add(fBundleTest.getMethodOtherobjectB02L01());
            listLine.add(fBundleTest.getMethodOtherobjectB02L02(classInfo
                    .getName(), field.getName(), fieldNameAdjustered));
            listLine.add(fBundleTest.getMethodOtherobjectB02L03());

            listLine.add(fBundleTest.getMethodOtherobjectB03L01());
            listLine.add(fBundleTest.getMethodOtherobjectB03L02(BlancoNameUtil
                    .trimJavaPackage(field.getType())));
            listLine.add(fBundleTest
                    .getMethodOtherobjectB03L03(fieldNameAdjustered));
            listLine.add(fBundleTest.getMethodOtherobjectB03L04(classInfo
                    .getName(), field.getName(), BlancoNameUtil
                    .trimJavaPackage(field.getType()), fieldNameAdjustered));
            listLine.add(fBundleTest.getMethodOtherobjectB03L05());

            listLine.add(fBundleTest.getMethodOtherobjectB04L01());
            listLine.add(fBundleTest
                    .getMethodOtherobjectB04L02(fieldNameAdjustered));
            listLine.add(fBundleTest.getMethodOtherobjectB04L03(classInfo
                    .getName(), field.getName(), fieldNameAdjustered));
            listLine.add(fBundleTest.getMethodOtherobjectB04L04());
        }
    }
}
