/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.fixedlength.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoFixedLengthRuntimeUtil]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoFixedLengthRuntimeUtilResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoFixedLengthRuntimeUtilResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthRuntimeUtil]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoFixedLengthRuntimeUtilResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthRuntimeUtil");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoFixedLengthRuntimeUtilResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthRuntimeUtil]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoFixedLengthRuntimeUtilResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthRuntimeUtil", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoFixedLengthRuntimeUtilResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthRuntimeUtil]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoFixedLengthRuntimeUtilResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthRuntimeUtil", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[PACKAGE.PREFIX]
     *
     * [.util] (ja)<br>
     *
     * @return key[PACKAGE.PREFIX]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getPackagePrefix() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = ".util";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("PACKAGE.PREFIX");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[PACKAGE.PREFIX]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[CLASS_NAME]
     *
     * [BlancoFixedLengthRuntimeUtil] (ja)<br>
     *
     * @return key[CLASS_NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getClassName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "BlancoFixedLengthRuntimeUtil";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CLASS_NAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[CLASS_NAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[FILECOMMENT]
     *
     * [blancoFixedLengthŗps[eBeBNX&lt;br&gt;] (ja)<br>
     *
     * @return key[FILECOMMENT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getFilecomment() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoFixedLengthŗps[eBeBNX<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("FILECOMMENT");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[FILECOMMENT]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[CLASSCOMMENT.01]
     *
     * [blancoFixedLengthŗps[eBeBNX&lt;br&gt;] (ja)<br>
     *
     * @return key[CLASSCOMMENT.01]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getClasscomment01() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoFixedLengthŗps[eBeBNX<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CLASSCOMMENT.01");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[CLASSCOMMENT.01]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[CLASSCOMMENT.02]
     *
     * [̃t@Cblanco Frameworkɂ莩Ă܂B] (ja)<br>
     *
     * @return key[CLASSCOMMENT.02]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getClasscomment02() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̃t@Cblanco Frameworkɂ莩Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CLASSCOMMENT.02");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[CLASSCOMMENT.02]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.NAME]
     *
     * [readToken] (ja)<br>
     *
     * @return key[READTOKEN.NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "readToken";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.NAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.NAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.JAVADOC]
     *
     * [^ꂽReader w̒̌Œ蒷g[No܂] (ja)<br>
     *
     * @return key[READTOKEN.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenJavadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^ꂽReader w̒̌Œ蒷g[No܂";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.01.TYPE]
     *
     * [java.io.Reader] (ja)<br>
     *
     * @return key[READTOKEN.ARG.01.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg01Type() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "java.io.Reader";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.01.TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.01.TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.01.NAME]
     *
     * [argReader] (ja)<br>
     *
     * @return key[READTOKEN.ARG.01.NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg01Name() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "argReader";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.01.NAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.01.NAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.01.JAVADOC]
     *
     * [^ꂽ[_] (ja)<br>
     *
     * @return key[READTOKEN.ARG.01.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg01Javadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^ꂽ[_";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.01.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.01.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.02.TYPE]
     *
     * [int] (ja)<br>
     *
     * @return key[READTOKEN.ARG.02.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg02Type() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "int";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.02.TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.02.TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.02.NAME]
     *
     * [argTokenLength] (ja)<br>
     *
     * @return key[READTOKEN.ARG.02.NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg02Name() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "argTokenLength";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.02.NAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.02.NAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.02.JAVADOC]
     *
     * [ǂݍ݂҂g[N̒B] (ja)<br>
     *
     * @return key[READTOKEN.ARG.02.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg02Javadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ǂݍ݂҂g[N̒B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.02.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.02.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.03.TYPE]
     *
     * [java.lang.String] (ja)<br>
     *
     * @return key[READTOKEN.ARG.03.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg03Type() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "java.lang.String";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.03.TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.03.TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.03.NAME]
     *
     * [argEncoding] (ja)<br>
     *
     * @return key[READTOKEN.ARG.03.NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg03Name() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "argEncoding";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.03.NAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.03.NAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.ARG.03.JAVADOC]
     *
     * [̃GR[fBOB] (ja)<br>
     *
     * @return key[READTOKEN.ARG.03.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenArg03Javadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̃GR[fBOB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.ARG.03.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.ARG.03.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.RETURN.TYPE]
     *
     * [java.lang.String] (ja)<br>
     *
     * @return key[READTOKEN.RETURN.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenReturnType() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "java.lang.String";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.RETURN.TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.RETURN.TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.RETURN.JAVADOC]
     *
     * [oꂽŒ蒷g[NB󋵂ɂĂ͊҂钷Ƃ͈قȂ钷̕񂪖߂܂B] (ja)<br>
     *
     * @return key[READTOKEN.RETURN.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenReturnJavadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "oꂽŒ蒷g[NB󋵂ɂĂ͊҂钷Ƃ͈قȂ钷̕񂪖߂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.RETURN.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.RETURN.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.THROWS.01.TYPE]
     *
     * [java.io.IOException] (ja)<br>
     *
     * @return key[READTOKEN.THROWS.01.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenThrows01Type() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "java.io.IOException";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.THROWS.01.TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.THROWS.01.TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.THROWS.01.JAVADOC]
     *
     * [o͗OꍇB] (ja)<br>
     *
     * @return key[READTOKEN.THROWS.01.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenThrows01Javadoc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "o͗OꍇB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.THROWS.01.JAVADOC");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.THROWS.01.JAVADOC]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.01]
     *
     * [if (argReader == null) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.01]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine01() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "if (argReader == null) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.01");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.01]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.02]
     *
     * [throw new IllegalArgumentException(&quot;readToken\bh̓̓p[^̃[_null^܂B&quot;);] (ja)<br>
     *
     * @return key[READTOKEN.LINE.02]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine02() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "throw new IllegalArgumentException(\"readToken\bh̓̓p[^̃[_null^܂B\");";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.02");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.02]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.03]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.03]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine03() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.03");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.03]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.04]
     *
     * [if (argTokenLength &lt;= 0) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.04]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine04() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "if (argTokenLength <= 0) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.04");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.04]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.05]
     *
     * [throw new IllegalArgumentException(&quot;readToken\bh̒Ƃ0ȉ^܂B1ȏ̒l^ĂB&quot;);] (ja)<br>
     *
     * @return key[READTOKEN.LINE.05]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine05() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "throw new IllegalArgumentException(\"readToken\bh̒Ƃ0ȉ^܂B1ȏ̒l^ĂB\");";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.05");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.05]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.06]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.06]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine06() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.06");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.06]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.07]
     *
     * [] (ja)<br>
     *
     * @return key[READTOKEN.LINE.07]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine07() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.07");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.07]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.08]
     *
     * [final StringBuffer buffer = new StringBuffer();] (ja)<br>
     *
     * @return key[READTOKEN.LINE.08]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine08() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "final StringBuffer buffer = new StringBuffer();";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.08");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.08]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.09]
     *
     * [for (;;) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.09]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine09() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "for (;;) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.09");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.09]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.10]
     *
     * [final int iRead = argReader.read();] (ja)<br>
     *
     * @return key[READTOKEN.LINE.10]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine10() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "final int iRead = argReader.read();";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.10");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.10]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.11]
     *
     * [if (iRead &lt; 0) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.11]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine11() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "if (iRead < 0) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.11");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.11]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.12]
     *
     * [// I[ɓB܂Bf܂B] (ja)<br>
     *
     * @return key[READTOKEN.LINE.12]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine12() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "// I[ɓB܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.12");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.12]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.13]
     *
     * [break;] (ja)<br>
     *
     * @return key[READTOKEN.LINE.13]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine13() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "break;";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.13");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.13]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.14]
     *
     * [} else {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.14]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine14() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "} else {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.14");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.14]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.15]
     *
     * [buffer.append((char) iRead);] (ja)<br>
     *
     * @return key[READTOKEN.LINE.15]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine15() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "buffer.append((char) iRead);";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.15");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.15]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.16]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.16]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine16() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.16");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.16]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.17]
     *
     * [] (ja)<br>
     *
     * @return key[READTOKEN.LINE.17]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine17() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.17");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.17]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.18]
     *
     * [byte[] bytesLengthCheck = null;] (ja)<br>
     *
     * @return key[READTOKEN.LINE.18]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine18() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "byte[] bytesLengthCheck = null;";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.18");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.18]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.19]
     *
     * [if (argEncoding == null) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.19]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine19() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "if (argEncoding == null) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.19");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.19]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.20]
     *
     * [bytesLengthCheck = buffer.toString().getBytes();] (ja)<br>
     *
     * @return key[READTOKEN.LINE.20]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine20() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bytesLengthCheck = buffer.toString().getBytes();";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.20");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.20]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.21]
     *
     * [} else {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.21]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine21() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "} else {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.21");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.21]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.22]
     *
     * [bytesLengthCheck = buffer.toString().getBytes(argEncoding);] (ja)<br>
     *
     * @return key[READTOKEN.LINE.22]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine22() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bytesLengthCheck = buffer.toString().getBytes(argEncoding);";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.22");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.22]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.23]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.23]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine23() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.23");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.23]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.24]
     *
     * [] (ja)<br>
     *
     * @return key[READTOKEN.LINE.24]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine24() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.24");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.24]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.25]
     *
     * [if (bytesLengthCheck.length &gt;= argTokenLength) {] (ja)<br>
     *
     * @return key[READTOKEN.LINE.25]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine25() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "if (bytesLengthCheck.length >= argTokenLength) {";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.25");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.25]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.26]
     *
     * [// Œ蒷g[N҂钷ɓB܂͊҂钷𒴂܂B] (ja)<br>
     *
     * @return key[READTOKEN.LINE.26]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine26() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "// Œ蒷g[N҂钷ɓB܂͊҂钷𒴂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.26");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.26]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.27]
     *
     * [// f܂B] (ja)<br>
     *
     * @return key[READTOKEN.LINE.27]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine27() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "// f܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.27");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.27]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.28]
     *
     * [break;] (ja)<br>
     *
     * @return key[READTOKEN.LINE.28]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine28() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "break;";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.28");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.28]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.29]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.29]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine29() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.29");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.29]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.30]
     *
     * [}] (ja)<br>
     *
     * @return key[READTOKEN.LINE.30]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine30() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.30");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.30]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthRuntimeUtil], key[READTOKEN.LINE.31]
     *
     * [return buffer.toString();] (ja)<br>
     *
     * @return key[READTOKEN.LINE.31]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReadtokenLine31() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "return buffer.toString();";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("READTOKEN.LINE.31");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthRuntimeUtil]AL[[READTOKEN.LINE.31]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
