/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.util.BlancoValueObjectUtil;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * o[IuWFNgpXMLt@C Java\[XR[hNXB
 * 
 * blancoValueObject̎傽NX̂ЂƂłB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JavaClass {
    /**
     * blancoValueObject̃\[XohIuWFNgB
     */
    private final BlancoValueObjectResourceBundle fBundle = new BlancoValueObjectResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * blancoValueObject 0.8.0G~[g邩ǂB
     */
    private boolean fEmulateVersion080 = false;

    /**
     * o[W0.8.0G~[g邩ǂB
     * 
     * @param argEmulateVersion
     *            G~[g邩ǂB
     */
    public void setEmulateVersion080(final boolean argEmulateVersion) {
        fEmulateVersion080 = argEmulateVersion;
    }

    /**
     * o[IuWFNg\钆XMLt@CAJava\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param argDirectoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {
        final BlancoValueObjectClassStructure[] structures = new BlancoValueObjectXmlParser()
                .parseFile(argMetaXmlSourceFile);
        for (int index = 0; index < structures.length; index++) {
            // ꂽ񂩂Java\[XR[h𐶐܂B
            classStructure2JavaSource(structures[index], argDirectoryTarget);
        }
    }

    /**
     * ^ꂽNXo[IuWFNgAJava\[XR[h܂B
     * 
     * @param argClassStructure
     *            NX
     * @param argDirectoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void classStructure2JavaSource(
            final BlancoValueObjectClassStructure argClassStructure,
            final File argDirectoryTarget) throws IOException {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        if (fEmulateVersion080 == false) {
            fCgSourceFile = fCgFactory.createSourceFile(argClassStructure
                    .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        } else {
            fCgSourceFile = fCgFactory.createSourceFile(argClassStructure
                    .getPackage(),
                    "This code is generated by blanco Framework.");
        }

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(argClassStructure.getName(), "");
        fCgSourceFile.getClassList().add(fCgClass);

        if (argClassStructure.getFilecomment() != null) {
            // t@CRgݒ肵܂B
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(argClassStructure
                            .getFilecomment());
            for (int index = 0; index < lines.length; index++) {
                fCgSourceFile.getLangDoc().getDescriptionList().add(
                        lines[index]);
            }
        }

        if (argClassStructure.getJavadoc() != null) {
            // NXJavaDocݒ肵܂B
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(argClassStructure
                            .getJavadoc());
            for (int index = 0; index < lines.length; index++) {
                fCgClass.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }

        for (int indexField = 0; indexField < argClassStructure.getListField()
                .size(); indexField++) {
            // ̂̂̃tB[h܂B
            final BlancoValueObjectFieldStructure fieldStructure = (BlancoValueObjectFieldStructure) argClassStructure
                    .getListField().get(indexField);

            // K{ڂݒ̏ꍇɂ͗O{܂B
            if (fieldStructure.getName() == null) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr003(argClassStructure.getName()));
            }
            if (fieldStructure.getType() == null) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr004(argClassStructure.getName(),
                                fieldStructure.getName()));
            }

            // tB[h̐B
            buildField(argClassStructure, fieldStructure);

            // Zb^[\bh̐B
            buildMethodSet(fieldStructure);

            // Qb^[\bh̐B
            buildMethodGet(fieldStructure);
        }

        // toString\bh̐B
        buildMethodToString(argClassStructure);

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * NXɃtB[h𐶐܂B
     * 
     * @param argClassStructure
     *            NXB
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildField(
            final BlancoValueObjectClassStructure argClassStructure,
            final BlancoValueObjectFieldStructure argFieldStructure) {
        final BlancoCgField cgField = fCgFactory.createField("f"
                + getFieldNameAdjustered(argFieldStructure), argFieldStructure
                .getType(), fBundle.getXml2javaclassFieldName(argFieldStructure
                .getName()));
        fCgClass.getFieldList().add(cgField);

        if (fEmulateVersion080) {
            cgField.setDescription(null);
            cgField.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassFieldName(argFieldStructure
                            .getName())
                            + "<br>");
        }

        // tB[hJavaDocݒ肵܂B
        cgField.getLangDoc().getDescriptionList().add(
                fBundle.getXml2javaclassFieldType(argFieldStructure.getType()));
        if (argFieldStructure.getDefault() != null) {
            // tB[h̃ftHglݒ肵܂B
            cgField.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassFieldDefault(argFieldStructure
                            .getDefault()));
            if (argFieldStructure.getType().equals("java.lang.String")) {
                // _uNI[gt^܂B
                cgField.setDefault("\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(argFieldStructure
                                        .getDefault()) + "\"");
            } else if (argFieldStructure.getType().equals("boolean")
                    || argFieldStructure.getType().equals("short")
                    || argFieldStructure.getType().equals("int")
                    || argFieldStructure.getType().equals("long")) {
                cgField.setDefault(argFieldStructure.getDefault());
            } else if (argFieldStructure.getType().equals("java.lang.Boolean")
                    || argFieldStructure.getType().equals("java.lang.Integer")
                    || argFieldStructure.getType().equals("java.lang.Long")) {
                cgField.setDefault("new "
                        + BlancoNameUtil.trimJavaPackage(argFieldStructure
                                .getType()) + "("
                        + argFieldStructure.getDefault() + ")");
            } else if (argFieldStructure.getType().equals("java.lang.Short")) {
                cgField.setDefault("new "
                        + BlancoNameUtil.trimJavaPackage(argFieldStructure
                                .getType()) + "((short) "
                        + argFieldStructure.getDefault() + ")");
            } else if (argFieldStructure.getType().equals(
                    "java.math.BigDecimal")) {
                fCgSourceFile.getImportList().add("java.math.BigDecimal");
                // 񂩂BigDecimalւƕϊ܂B
                cgField.setDefault("new BigDecimal(\""
                        + argFieldStructure.getDefault() + "\")");
            } else if (argFieldStructure.getType()
                    .equals("java.util.ArrayList")) {
                // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                // TODO 2blancoValueObject̗pꍇɂ́ASNXC|[gÓB
                fCgSourceFile.getImportList().add("java.util.ArrayList");
                cgField.setDefault(argFieldStructure.getDefault());
            } else {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr005(argClassStructure.getName(),
                                argFieldStructure.getName(), argFieldStructure
                                        .getDefault(), argFieldStructure
                                        .getType()));
            }
        }

        if (argFieldStructure.getJavadoc() != null) {
            // tB[hJavaDocݒ肵܂B
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(argFieldStructure
                            .getJavadoc());
            for (int index = 0; index < lines.length; index++) {
                cgField.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }
    }

    /**
     * set\bh𐶐܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildMethodSet(
            final BlancoValueObjectFieldStructure argFieldStructure) {
        // ̂̂̃tB[hɑ΂Zb^[\bh𐶐܂B
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("set"
                + getFieldNameAdjustered(argFieldStructure), fBundle
                .getXml2javaclassSetJavadoc01(argFieldStructure.getName()));
        fCgClass.getMethodList().add(cgMethod);

        if (fEmulateVersion080) {
            cgMethod.setDescription(null);
            cgMethod.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassSetJavadoc01(argFieldStructure
                            .getName())
                            + "<br>");
        }

        // \bh̃VOj`w
        cgMethod.getLangDoc().getDescriptionList().add(
                fBundle.getXml2javaclassSetJavadoc02(argFieldStructure
                        .getType()));
        if (argFieldStructure.getJavadoc() != null) {
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(argFieldStructure
                            .getJavadoc());
            for (int index = 0; index < lines.length; index++) {
                cgMethod.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }

        cgMethod.getParameterList().add(
                fCgFactory.createParameter("arg"
                        + getFieldNameAdjustered(argFieldStructure),
                        argFieldStructure.getType(),
                        fBundle.getXml2javaclassSetArgJavadoc(argFieldStructure
                                .getName())));

        // \bh̎
        final List listLine = cgMethod.getLineList();

        listLine.add("f" + getFieldNameAdjustered(argFieldStructure) + " = "
                + "arg" + getFieldNameAdjustered(argFieldStructure) + ";");
    }

    /**
     * get\bh𐶐܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildMethodGet(
            final BlancoValueObjectFieldStructure argFieldStructure) {
        // ̂̂̃tB[hɑ΂Qb^[\bh𐶐܂B
        final BlancoCgMethod method = fCgFactory.createMethod("get"
                + getFieldNameAdjustered(argFieldStructure), fBundle
                .getXml2javaclassGetJavadoc01(argFieldStructure.getName()));
        fCgClass.getMethodList().add(method);

        if (fEmulateVersion080) {
            method.setDescription(null);
            method.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassGetJavadoc01(argFieldStructure
                            .getName())
                            + "<br>");
        }

        // \bh̃VOj`w
        method.getLangDoc().getDescriptionList().add(
                fBundle.getXml2javaclassGetJavadoc02(argFieldStructure
                        .getType()));
        if (argFieldStructure.getDefault() != null) {
            method.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassGetArgJavadoc(argFieldStructure
                            .getDefault()));
        }
        if (argFieldStructure.getJavadoc() != null) {
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(argFieldStructure
                            .getJavadoc());
            for (int index = 0; index < lines.length; index++) {
                method.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }

        method.setReturn(fCgFactory.createReturn(argFieldStructure.getType(),
                fBundle.getXml2javaclassGetReturnJavadoc(argFieldStructure
                        .getName())));

        // \bh̎
        final List listLine = method.getLineList();

        listLine.add("return f" + getFieldNameAdjustered(argFieldStructure)
                + ";");
    }

    /**
     * toString\bh𐶐܂B
     * 
     * @param argClassStructure
     *            NXB
     */
    private void buildMethodToString(
            final BlancoValueObjectClassStructure argClassStructure) {
        final BlancoCgMethod method = fCgFactory.createMethod("toString",
                "̃o[IuWFNg̕\擾܂B");
        fCgClass.getMethodList().add(method);

        method.getLangDoc().getDescriptionList().add(
                "IuWFNg̃V[͈͂łtoStringȂ_ɒӂėpĂB");

        method.setReturn(fCgFactory.createReturn("java.lang.String",
                "o[IuWFNg̕\B"));

        final List listLine = method.getLineList();

        listLine.add("final StringBuffer buf = new StringBuffer();");
        listLine.add("buf.append(\"" + argClassStructure.getPackage() + "."
                + argClassStructure.getName() + "[\");");
        for (int indexField = 0; indexField < argClassStructure.getListField()
                .size(); indexField++) {
            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) argClassStructure
                    .getListField().get(indexField);

            final String fieldNameAdjustered = (getNameAdjust() == false ? field
                    .getName()
                    : BlancoNameAdjuster.toClassName(field.getName()));

            if (field.getType().endsWith("[]") == false) {
                listLine.add("buf.append(\"" + (indexField == 0 ? "" : ",")
                        + field.getName() + "=\" + f" + fieldNameAdjustered
                        + ");");
            } else {
                // 2006.05.31 t.iga z̏ꍇɂ́A
                // ̔z񎩐gnullǂ̃`FbNKvłB
                listLine.add("if (f" + fieldNameAdjustered + " == null) {");
                // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                listLine.add("buf.append(" + (indexField == 0 ? "\"" :
                // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                        "\",") + field.getName() + "=null\");");
                listLine.add("} else {");

                // z̏ꍇɂ̓fB[vtoString܂B
                listLine.add("buf.append("
                // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                        + (indexField == 0 ? "\"" :
                        // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                                "\",") + field.getName() + "=[\");");
                listLine.add("for (int index = 0; index < f"
                        + fieldNameAdjustered + ".length; index++) {");
                // 2006.05.31 t.iga
                // ArrayListȂǂtoStringƓlɂȂ悤ɁAJ}̂ƂɔpXy[Xt^悤ɂ܂B
                listLine.add("buf.append((index == 0 ? \"\" : \", \") + f"
                        + fieldNameAdjustered + "[index]);");
                listLine.add("}");
                listLine.add("buf.append(\"]\");");
                listLine.add("}");
            }
        }
        listLine.add("buf.append(\"]\");");
        listLine.add("return buf.toString();");
    }

    /**
     * ς݂̃tB[h擾܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     * @return ̃tB[hB
     */
    private String getFieldNameAdjustered(
            final BlancoValueObjectFieldStructure argFieldStructure) {
        return (getNameAdjust() == false ? argFieldStructure.getName()
                : BlancoNameAdjuster.toClassName(argFieldStructure.getName()));
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param argIsNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean argIsNameAdjust) {
        fNameAdjust = argIsNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
