/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobjectfactory.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

import javax.xml.transform.TransformerException;

import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.valueobject.BlancoValueObjectMeta2Xml;
import blanco.valueobjectfactory.BlancoValueObjectFactoryConstants;
import blanco.valueobjectfactory.BlancoValueObjectFactoryMeta2Xml;
import blanco.valueobjectfactory.BlancoValueObjectFactoryXml2SourceFile;
import blanco.valueobjectfactory.resourcebundle.BlancoValueObjectFactoryResourceBundle;

/**
 * uo[IuWFNgt@Ng`vExcell o[IuWFNĝ߂̃t@NgNXE\[XR[h𐶐邽߂Ant^XNB
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectFactoryTask extends
        AbstractBlancoValueObjectFactoryTask {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoValueObjectFactoryResourceBundle fBundle = new BlancoValueObjectFactoryResourceBundle();

    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- "
                + BlancoValueObjectFactoryConstants.PRODUCT_NAME + " ("
                + BlancoValueObjectFactoryConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            // e|fBNg쐬B
            new File(getTmpdir()
                    + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            final HashMap valueObjectMap = new HashMap();
            final HashMap resourceBundleMap = new HashMap();

            {
                // ̉ߒŕKvƂȂValueObjectNX̃e|B
                new File(getTmpdir()
                        + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                        + "/valueobject").mkdirs();

                // Ƀo[IuWFNg`͂܂B
                new BlancoValueObjectMeta2Xml()
                        .processDirectory(
                                fileMetadir,
                                getTmpdir()
                                        + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                                        + "/valueobject");

                // o[IuWFNg`WJ
                // nbVɋLĂ
                BlancoValueObjectFactoryXml2SourceFile
                        .processBlancoValueObjectXmlDirectory(
                                new File(
                                        getTmpdir()
                                                + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                                                + "/valueobject"),
                                valueObjectMap);
            }

            {
                // ̉ߒŕKvƂȂResourceBundleNX̃e|B
                new File(getTmpdir()
                        + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                        + "/resourcebundle").mkdirs();

                // Ƀ\[Xoh`͂܂B
                new BlancoResourceBundleMeta2Xml()
                        .processDirectory(
                                fileMetadir,
                                getTmpdir()
                                        + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                                        + "/resourcebundle");

                // \[Xoh`WJ
                // nbVɋLĂ
                BlancoValueObjectFactoryXml2SourceFile
                        .processBlancoResourceBundleXmlDirectory(
                                new File(
                                        getTmpdir()
                                                + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
                                                + "/resourcebundle"),
                                resourceBundleMap);
            }

            // w肳ꂽ^fBNg܂B
            new BlancoValueObjectFactoryMeta2Xml()
                    .processDirectory(
                            fileMetadir,
                            getTmpdir()
                                    + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoValueObjectFactoryXml2SourceFile().process(
                        fileMeta2[index], valueObjectMap, resourceBundleMap,
                        new File(getTargetdir()));
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}
