/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.sample.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoValueObjectFactorySampleSetting]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoValueObjectFactorySampleSettingResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoValueObjectFactorySampleSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObjectFactorySampleSetting]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoValueObjectFactorySampleSettingResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObjectFactorySampleSetting");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoValueObjectFactorySampleSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObjectFactorySampleSetting]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoValueObjectFactorySampleSettingResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObjectFactorySampleSetting", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoValueObjectFactorySampleSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObjectFactorySampleSetting]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoValueObjectFactorySampleSettingResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObjectFactorySampleSetting", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_HOST]
     *
     * [] (ja)<br>
     *
     * @return key[SEND_HOST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendHost() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_HOST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_PORT]
     *
     * [-1] (ja)<br>
     *
     * @return key[SEND_PORT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendPort() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "-1";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_PORT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_USE_SSL]
     *
     * [false] (ja)<br>
     *
     * @return key[SEND_USE_SSL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendUseSsl() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_USE_SSL");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_USER_NAME]
     *
     * [] (ja)<br>
     *
     * @return key[SEND_USER_NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendUserName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_USER_NAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_PASSWORD]
     *
     * [] (ja)<br>
     *
     * @return key[SEND_PASSWORD]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendPassword() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_PASSWORD");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_SMTP_AUTH]
     *
     * [true] (ja)<br>
     *
     * @return key[SEND_SMTP_AUTH]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendSmtpAuth() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_SMTP_AUTH");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_HOST]
     *
     * [] (ja)<br>
     *
     * @return key[RECEIVE_HOST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceiveHost() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_HOST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_PORT]
     *
     * [-1] (ja)<br>
     *
     * @return key[RECEIVE_PORT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceivePort() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "-1";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_PORT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_USE_SSL]
     *
     * [false] (ja)<br>
     *
     * @return key[RECEIVE_USE_SSL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceiveUseSsl() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_USE_SSL");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_USER_NAME]
     *
     * [] (ja)<br>
     *
     * @return key[RECEIVE_USER_NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceiveUserName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_USER_NAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_PASSWORD]
     *
     * [] (ja)<br>
     *
     * @return key[RECEIVE_PASSWORD]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceivePassword() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_PASSWORD");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_PROTOCOL]
     *
     * [pop3] (ja)<br>
     *
     * @return key[RECEIVE_PROTOCOL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceiveProtocol() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "pop3";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_PROTOCOL");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[RECEIVE_POP3_APOP]
     *
     * [false] (ja)<br>
     *
     * @return key[RECEIVE_POP3_APOP]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getReceivePop3Apop() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("RECEIVE_POP3_APOP");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[MAIL_CONNECTION_TIMEOUT]
     *
     * [60000] (ja)<br>
     *
     * @return key[MAIL_CONNECTION_TIMEOUT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMailConnectionTimeout() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "60000";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MAIL_CONNECTION_TIMEOUT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[MAIL_TIMEOUT]
     *
     * [600000] (ja)<br>
     *
     * @return key[MAIL_TIMEOUT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMailTimeout() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "600000";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MAIL_TIMEOUT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SESSION_LOG_DIRECTORY_ERROR]
     *
     * [] (ja)<br>
     *
     * @return key[SESSION_LOG_DIRECTORY_ERROR]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSessionLogDirectoryError() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SESSION_LOG_DIRECTORY_ERROR");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SESSION_LOG_DIRECTORY_SUCCESS]
     *
     * [] (ja)<br>
     *
     * @return key[SESSION_LOG_DIRECTORY_SUCCESS]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSessionLogDirectorySuccess() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SESSION_LOG_DIRECTORY_SUCCESS");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SOCKETFACTORY_CLASS]
     *
     * [javax.net.ssl.SSLSocketFactory] (ja)<br>
     *
     * @return key[SOCKETFACTORY_CLASS]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSocketfactoryClass() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "javax.net.ssl.SSLSocketFactory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SOCKETFACTORY_CLASS");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SOCKETFACTORY_FALLBACK]
     *
     * [false] (ja)<br>
     *
     * @return key[SOCKETFACTORY_FALLBACK]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSocketfactoryFallback() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SOCKETFACTORY_FALLBACK");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_MAILER_NAME]
     *
     * [blancoMail 0.1] (ja)<br>
     *
     * @return key[SEND_MAILER_NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendMailerName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoMail 0.1";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_MAILER_NAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_ENCODING]
     *
     * [ISO-2022-JP] (ja)<br>
     *
     * @return key[SEND_ENCODING]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendEncoding() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ISO-2022-JP";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_ENCODING");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_FORTH_CONTENT_TRANSFER_ENCODING_7BIT]
     *
     * [true] (ja)<br>
     *
     * @return key[SEND_FORTH_CONTENT_TRANSFER_ENCODING_7BIT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendForthContentTransferEncoding7bit() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_FORTH_CONTENT_TRANSFER_ENCODING_7BIT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_FORTH_NEWLINE_AFTER_MESSAGE_TEXT]
     *
     * [true] (ja)<br>
     *
     * @return key[SEND_FORTH_NEWLINE_AFTER_MESSAGE_TEXT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendForthNewlineAfterMessageText() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_FORTH_NEWLINE_AFTER_MESSAGE_TEXT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_MAX_RECIPIENT_ADDR_TO]
     *
     * [10] (ja)<br>
     *
     * @return key[SEND_MAX_RECIPIENT_ADDR_TO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendMaxRecipientAddrTo() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "10";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_MAX_RECIPIENT_ADDR_TO");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObjectFactorySampleSetting], key[SEND_MAX_RECIPIENT_ADDR_CC]
     *
     * [10] (ja)<br>
     *
     * @return key[SEND_MAX_RECIPIENT_ADDR_CC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSendMaxRecipientAddrCc() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "10";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SEND_MAX_RECIPIENT_ADDR_CC");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
