/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.concurrent.ExecutorService;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassNameCache;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.TransformedClassCache;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);
    private static final File lockFile = new File(Pleiades.getConfigurationPath(), ".lock");

    public TranslationTransformer() {
        this.load();
    }

    protected void load() {
        lockFile.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                TranslationTransformer.unlock();
            }
        });
        ExecutorService executorService = Pleiades.getExecutorService();
        TranslationTransformer.lock();
        executorService.execute(new Runnable(){

            public void run() {
                ExcludesClassNameCache.getInstance();
            }
        });
        executorService.execute(new Runnable(){

            public void run() {
                TransformedClassCache.getInstance();
            }
        });
        executorService.execute(new Runnable(){

            public void run() {
                DynamicTranslationDictionary.getInstance();
                TranslationTransformer.unlock();
            }
        });
        executorService.shutdown();
    }

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        ExcludesClassNameCache excludeList = ExcludesClassNameCache.getInstance();
        if (excludeList.contains(className)) {
            return null;
        }
        TransformedClassCache classCache = TransformedClassCache.getInstance();
        byte[] cachedBytecode = classCache.get(className);
        if (cachedBytecode != null) {
            return cachedBytecode;
        }
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        byte[] transformedBytecode = this.transformClass(ctClass);
        if (transformedBytecode == null) {
            excludeList.add(className);
        } else {
            classCache.put(className, transformedBytecode);
        }
        return transformedBytecode;
    }

    protected byte[] transformClass(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        TranslationEditor editor = new TranslationEditor(ctClass);
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior ctBehavior = ctBehaviorArray[n2];
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
            ++n2;
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        return editor.toBytecode();
    }

    public static void destroy() {
        TranslationTransformer.lock();
        try {
            try {
                DynamicTranslationDictionary.getInstance().store();
                TransformedClassCache.getInstance().store();
                ExcludesClassNameCache.getInstance().store();
            }
            catch (Exception e) {
                log.error("\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u7834\u68c4\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                TranslationTransformer.unlock();
            }
        }
        finally {
            TranslationTransformer.unlock();
        }
    }

    private static void lock() {
        int MAX_WAIT = 30;
        try {
            int i = 1;
            while (i <= 30 && lockFile.exists()) {
                Thread.sleep(1000L);
                log.debug("\u30ed\u30c3\u30af\u89e3\u9664\u5f85\u6a5f\u4e2d\u3067\u3059\u3002(" + i + "/" + 30 + " \u79d2)");
                ++i;
            }
        }
        catch (Exception e) {
            log.error("\u30ed\u30c3\u30af\u5f85\u3061\u3067\u5272\u308a\u8fbc\u307f\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
        }
        try {
            lockFile.createNewFile();
            log.debug("\u30ed\u30c3\u30af\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            log.error("\u30ed\u30c3\u30af\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private static void unlock() {
        try {
            lockFile.delete();
            log.debug("\u30ed\u30c3\u30af\u89e3\u9664\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            log.error("\u30ed\u30c3\u30af\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }
}

