/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.Property;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectMappingAssembler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(AspectMappingAssembler.class);
    private final Set<Property> properties = new HashSet<Property>();
    private final Map<JointPoint, PointCut> jointMap;
    private PointCut pointCut;
    private StringBuilder adviceBuffer;
    private JointPoint jointPoint;
    private String editPoint;

    public AspectMappingAssembler(Map<JointPoint, PointCut> jointMap) {
        this.jointMap = jointMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("pleiades")) return;
        if (qName.equals("property")) {
            Property property = new Property();
            property.setName(attributes.getValue("name"));
            property.setValue(attributes.getValue("value"));
            this.properties.add(property);
            return;
        } else if (qName.equals("pointCut")) {
            this.pointCut = new PointCut();
            this.pointCut.setTiming(attributes.getValue("timing"));
            this.editPoint = attributes.getValue("editPoint");
            return;
        } else if (qName.equals("advice")) {
            this.adviceBuffer = new StringBuilder();
            return;
        } else if (qName.equals("jointPoint")) {
            this.jointPoint = this.createJointPoint(new JointPoint(), attributes);
            if (this.jointMap.containsKey(this.jointPoint)) {
                log.warn("\u30b8\u30e7\u30a4\u30f3\u30c8\u30fb\u30dd\u30a4\u30f3\u30c8\u5b9a\u7fa9\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002" + this.jointPoint);
            }
            PointCut curPointCut = new PointCut(this.pointCut);
            this.jointMap.put(this.jointPoint, curPointCut);
            curPointCut.setJointPoint(this.jointPoint);
            return;
        } else if (qName.endsWith("cludeWhere")) {
            JointPoint where = this.createJointPoint(new JointPoint(), attributes);
            PointCut curPointCut = this.jointMap.get(this.jointPoint);
            if (qName.equals("excludeWhere")) {
                curPointCut.getExcludeWheres().add(where);
                return;
            } else {
                if (!qName.equals("includeWhere")) throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
                curPointCut.getIncludeWheres().add(where);
            }
            return;
        } else {
            if (!qName.endsWith("cludeTrace")) throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
            JointPoint where = this.createJointPoint(new JointPoint(), attributes);
            PointCut curPointCut = this.jointMap.get(this.jointPoint);
            if (qName.equals("excludeTrace")) {
                curPointCut.getExcludeTrace().add(where);
                return;
            } else {
                if (!qName.equals("includeTrace")) throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
                curPointCut.getIncludeTrace().add(where);
            }
        }
    }

    private JointPoint createJointPoint(JointPoint jointPoint, Attributes attributes) {
        jointPoint.setClassName(attributes.getValue("className"));
        jointPoint.setMethodName(attributes.getValue("methodName"));
        jointPoint.setDescriptor(attributes.getValue("descriptor"));
        jointPoint.setEditPoint(this.editPoint);
        return jointPoint;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("advice")) {
            String advice = this.adviceBuffer.toString();
            for (Property property : this.properties) {
                advice = advice.replaceAll("\\?\\{" + property.getName() + "\\}", property.getValue());
            }
            this.pointCut.setAdvice(advice);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.adviceBuffer != null) {
            this.adviceBuffer.append(ch, start, length);
        }
    }
}

