/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.csv.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoCsv]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoCsvResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoCsvResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCsv]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoCsvResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoCsv");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoCsvResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCsv]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoCsvResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoCsv", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoCsvResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCsv]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoCsvResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoCsv", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoCsv], key[METAFILE_DISPLAYNAME]
     *
     * [t@C`(CSV)] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(CSV)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoCsv], key[META2XML.ELEMENT_COMMON]
     *
     * [blancocsv-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancocsv-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoCsv], key[META2XML.ELEMENT_LIST]
     *
     * [blancocsv-fieldList] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancocsv-fieldList";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR001]
     *
     * [{0}̏ɂĕsȏI[m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĕsȏI[m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR002]
     *
     * [{0}̏ɂMIN({1})Zl[&quot; + tokenString + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂMIN({1})Zl[\" + tokenString + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR003]
     *
     * [{0}̏ɂMAX({1})l[&quot; + tokenString + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂMAX({1})l[\" + tokenString + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR004]
     *
     * [{0}̏ɂĐl(int)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(int)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR005]
     *
     * [{0}̏ɂĐl(long)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr005(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(long)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR006]
     *
     * [{0}̏ɂė^ꂽ`[&quot; + fSimpleDateFormat{1}.toPattern() + &quot;]ł͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr006(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂė^ꂽ`[\" + fSimpleDateFormat{1}.toPattern() + \"]ł͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR007]
     *
     * [{0}̏ɂĐl(decimal)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr007(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(decimal)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_READER.ERR008]
     *
     * [{0}̏ɂĕK{ڂɒlĂȂƂm܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr008(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĕK{ڂɒlĂȂƂm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR008");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_WRITER.ERR001]
     *
     * [{0}̏ɂMIN({1})Zl[&quot; + writeToken + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr001(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂMIN({1})Zl[\" + writeToken + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_WRITER.ERR002]
     *
     * [{0}̏ɂMAX({1})l[&quot; + writeToken + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂMAX({1})l[\" + writeToken + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_WRITER.ERR003]
     *
     * [{0}̏ɂăf[^[&quot; + writeToken + &quot;]ɍڂ̃f~^[{1}]܂܂邱Ƃm܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂăf[^[\" + writeToken + \"]ɍڂ̃f~^[{1}]܂܂邱Ƃm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_WRITER.ERR004]
     *
     * [{0}̏ɂĕK{ڂnull^Ă邱Ƃm܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĕK{ڂnull^Ă邱Ƃm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[CSV_WRITER.ERR005]
     *
     * [{0}̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr005(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR001]
     *
     * [t@C`(CSV) t@C`ID[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(CSV) t@C`ID[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR002]
     *
     * [t@C`(CSV) t@C`ID[{0}]̃f~^w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(CSV) t@C`ID[{0}]̃f~^w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR003]
     *
     * [t@C`(CSV) t@C`ID[{0}]́uf~^vuCӎwvɐݒ肷ꍇɂ́AuCӎwf~^vw肷Kv܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr003(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(CSV) t@C`ID[{0}]́uf~^vuCӎwvɐݒ肷ꍇɂ́AuCӎwf~^vw肷Kv܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR004]
     *
     * [t@C`ID[{0}] [{1}]́u^vw肳Ă܂Bu^vw肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr004(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vw肳Ă܂Bu^vw肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR005]
     *
     * [t@C`ID[{0}] [{1}]́u^vłAuvw肳Ă܂Bu^v̏ꍇ́uvw肵ĂB\n: [yyyy/MM/dd HH:mm:ss]̂悤Ɏw肵܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr005(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vłAuvw肳Ă܂Bu^v̏ꍇ́uvw肵ĂB\n: [yyyy/MM/dd HH:mm:ss]̂悤Ɏw肵܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR006]
     *
     * [t@C`ID[{0}] [{1}]́u^vł͂܂񂪁Auvw肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr006(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vł͂܂񂪁Auvw肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR007]
     *
     * [t@C`ID[{0}] [{1}]́uMINvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr007(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uMINvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR008]
     *
     * [t@C`ID[{0}] [{1}]́uMINvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr008(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uMINvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR008");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR009]
     *
     * [t@C`ID[{0}] [{1}]́uMAXvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr009(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uMAXvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR009");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR010]
     *
     * [t@C`ID[{0}] [{1}]́uMAXvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR010]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr010(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uMAXvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR010");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[XML2JAVACLASS.ERR011]
     *
     * [t@C`ID[{0}] [{1}]́uMINv({2})ƁuMAXv({3})̑召֌WsłB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr011(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uMINv({2})ƁuMAXv({3})̑召֌WsłB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[FIELD_NO]
     *
     * [ڔԍ[{0}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[FIELD_NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڔԍ[{0}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("FIELD_NO");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[NOT_SUPPORTED_TYPE]
     *
     * [// TODO: x: T|[gȂ^[{0}]^܂BXLbv܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[NOT_SUPPORTED_TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getNotSupportedType(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "// TODO: x: T|[gȂ^[{0}]^܂BXLbv܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("NOT_SUPPORTED_TYPE");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoCsv], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
