/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.properties;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

import blanco.commons.util.BlancoStreamUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.properties.manifest.valueobject.BlancoPropertiesManifest;
import blanco.properties.resourcebundle.BlancoPropertiesResourceBundle;

/**
 * blancoPropertiesœIɗp郆[eBeBNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoPropertiesUtil {
    private static final BlancoPropertiesResourceBundle fBundle = new BlancoPropertiesResourceBundle();

    /**
     * vOC .nl_<P[>  o[Wԍt^̂擾܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @return TtBbNXtvOCB
     */
    public static String getPluginNameWithSuffix(
            final BlancoPropertiesManifest manifest, final String targetLocale) {
        return manifest.getBundleSymbolicName() + "."
                + fBundle.getSymbolicNameSuffixWithoutLocale() + targetLocale
                + "_" + manifest.getBundleVersion();
    }

    /**
     * vOC̃t̂V{bNސ܂B
     * 
     * @param pluginFullName
     *            vOC̃t́B
     * @return V{bNB
     */
    public static String getBundleSymbolicName(final String pluginFullName) {
        // |CgBA_[o[ŕB
        final int underLine = pluginFullName.indexOf('_');
        if (underLine < 0) {
            throw new IllegalArgumentException("s\: getBundleSymbolicName("
                    + pluginFullName + ")");
        }
        return pluginFullName.substring(0, underLine);
    }

    /**
     * vOC̃t̂o[Wސ܂B
     * 
     * @param pluginFullName
     *            vOC̃t́B
     * @return o[WB
     */
    public static String getBundleVersion(final String pluginFullName) {
        // |CgBA_[o[ŕB
        final int underLine = pluginFullName.indexOf('_');
        if (underLine < 0) {
            throw new IllegalArgumentException("s\: getBundleVersion("
                    + pluginFullName + ")");
        }
        return pluginFullName.substring(underLine + 1);
    }

    /**
     * ̓Xg[SēǂݍŃoCgz񉻂܂B
     * 
     * @param inStream
     *            ̓Xg[B
     * @return oCgz񉻂ꂽSf[^B
     * @throws IOException
     *             o͗OꍇB
     */
    public static byte[] readBytes(final InputStream inStream)
            throws IOException {
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BlancoStreamUtil.copy(inStream, outStream);
        outStream.flush();
        outStream.close();
        return outStream.toByteArray();
    }

    /**
     * p\ȃP[̈ꗗ擾܂B
     * 
     * @return p\ȃP[̈ꗗB
     */
    public static String[] getAvailableLocaleStrings() {
        final Locale[] knownLocales = Locale.getAvailableLocales();
        final String[] wrkStrings = new String[knownLocales.length];
        for (int index = 0; index < knownLocales.length; index++) {
            wrkStrings[index] = knownLocales[index].toString();
        }
        return wrkStrings;
    }

    /**
     * ^ꂽL[{l\vpeBt@ĈPs𕶎ƂĎ擾܂B
     * 
     * @param key
     *            L[B
     * @param value
     *            lB
     * @return vpeBt@CɓWJꂽۂ̂PsB
     */
    public static String getPropertiesLine(final String key, final String value) {
        String result = null;
        final Properties prop = new Properties();
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            prop.setProperty(key, value);

            prop.store(outStream, "");
            outStream.flush();
            outStream.close();

            final byte[] buf = outStream.toByteArray();
            final BufferedReader reader = new BufferedReader(
                    new InputStreamReader(new ByteArrayInputStream(buf),
                            "UTF-8"));
            for (;;) {
                final String line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (line.startsWith("#")) {
                    continue;
                }
                if (line.trim().length() == 0) {
                    continue;
                }
                result = line;
            }

            reader.close();

            if (result == null) {
                throw new IllegalArgumentException("肦܂");
            }
            return result;
        } catch (IOException e) {
            // ͂肦ȂB
            throw new IllegalArgumentException("肦ȂO: ", e);
        }
    }

    /**
     * GXP[v܂܂ꂽL[񂩂AGXP[vꂽL[擾܂B
     * 
     * : getKeyWithEscape
     * 
     * @param keyStringWithEscape
     *            GXP[v܂܂ꂽL[B
     * @return GXP[vꂽL[B
     * @throws IOException
     */
    public static String normalizeKeyString(final String keyStringWithEscape) {
        final Properties prop = new Properties();
        try {
            prop.load(new ByteArrayInputStream(new String(keyStringWithEscape
                    + "=dummy").getBytes("UTF-8")));
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("肦ȂOB", e);
        } catch (IOException e) {
            throw new IllegalArgumentException("肦ȂOB", e);
        }

        final Iterator ite = prop.keySet().iterator();
        if (ite.hasNext() == false) {
            throw new IllegalArgumentException("肦ȂOB");
        }
        return (String) ite.next();
    }

    // Babel URI Ɋւ郁\bhB

    /**
     * }jtFXg URI𐶐܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @param strPropertyFilePath
     *            vpeBt@C̃pXB(}jtFXg猈łȂꍇɗp)
     * @return URIB
     * @throws IOException
     *             o͗OꍇB
     */
    public static String getBabelURI(BlancoPropertiesManifest manifest,
            String strPropertyFilePath) {
        // TODO o[W𖄂ߍނȂǂ̍l@B
        // : babel://V{:o[W/vpeBt@C̃pX

        // Ăꍇɂ / ɕϊ܂B
        strPropertyFilePath = BlancoStringUtil.replaceAll(strPropertyFilePath,
                '\\', '/');

        return "babel://" + manifest.getBundleSymbolicName() + "/"
                + strPropertyFilePath;
    }

    public static String getHostFromBabelURI(final String bundleURI) {
        final String strUrl = "https://"
                + bundleURI.substring("https://".length());
        try {
            URL url = new URL(strUrl);
            return url.getHost();
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException("URLs", e);
        }
    }

    public static String getPathFromBabelURI(final String bundleURI) {
        final String strUrl = "https://"
                + bundleURI.substring("https://".length());
        try {
            final URL url = new URL(strUrl);
            return url.getPath();
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException("URLs", e);
        }
    }

    public static String getFileFromBabelURI(final String bundleURI) {
        final String strUrl = "https://"
                + bundleURI.substring("https://".length());
        try {
            final URL url = new URL(strUrl);
            return url.getFile();
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException("URLs", e);
        }
    }

    /**
     * ^ꂽ URI  vt@XEL[[hǂ𔻒肵܂B
     * 
     * @param bundleURI
     * @return
     */
    public static boolean isPreferenceKeywords(final String bundleURI) {
        if (BlancoStringUtil.null2Blank(bundleURI).indexOf(
                ".properties?key=preferenceKeywords.") >= 0) {
            return true;
        }
        if (BlancoStringUtil.null2Blank(bundleURI).indexOf(
                ".properties?key=PreferenceKeywords.") >= 0) {
            return true;
        }

        if ("babel://org.eclipse.ltk.ui.refactoring/plugin.properties?key=RefactoringPropertyPage_keywords"
                .equals(bundleURI)) {
            return true;
        }
        if ("babel://org.eclipse.pde.api.tools.ui/plugin.properties?key=ApiProfilesPreferencePage.keywords"
                .equals(bundleURI)) {
            return true;
        }

        // Spring IDE
        if ("babel://org.springframework.ide.eclipse.beans.ui/plugin.properties?key=propertyKeywords.label"
                .equals(bundleURI)) {
            return true;
        }

        return false;
    }
}
