/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.task;

import java.io.IOException;

import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorDiffResultDetailProcessInput;

/**
 * ob`NX [BlancoNLpackGeneratorDiffResultDetailBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.nlpack.generator.task.BlancoNLpackGeneratorDiffResultDetailBatchProcess -help
 * </code>
 */
public class BlancoNLpackGeneratorDiffResultDetailBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoNLpackGeneratorDiffResultDetailBatchProcess batchProcess = new BlancoNLpackGeneratorDiffResultDetailBatchProcess();

        // ob`̈B
        final BlancoNLpackGeneratorDiffResultDetailProcessInput input = new BlancoNLpackGeneratorDiffResultDetailProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourceleftProcessed = false;
        boolean isFieldSourcerightProcessed = false;
        boolean isFieldTargetdiffProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourceleft=")) {
                input.setSourceleft(arg.substring(12));
                isFieldSourceleftProcessed = true;
            } else if (arg.startsWith("-sourceright=")) {
                input.setSourceright(arg.substring(13));
                isFieldSourcerightProcessed = true;
            } else if (arg.startsWith("-targetdiff=")) {
                input.setTargetdiff(arg.substring(12));
                isFieldTargetdiffProcessed = true;
            } else if (arg.startsWith("-reportequal=")) {
                input.setReportequal(Boolean.valueOf(arg.substring(13)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourceleftProcessed == false) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourceleft]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldSourcerightProcessed == false) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourceright]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldTargetdiffProcessed == false) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdiff]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoNLpackGeneratorDiffResultDetailProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoNLpackGeneratorDiffResultDetailProcessC^tF[X blanco.nlpack.generator.taskpbP[W BlancoNLpackGeneratorDiffResultDetailProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoNLpackGeneratorDiffResultDetailProcess process = new BlancoNLpackGeneratorDiffResultDetailProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoNLpackGeneratorDiffResultDetailProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoNLpackGeneratorDiffResultDetailBatchProcess: Usage:");
        System.out.println("  java blanco.nlpack.generator.task.BlancoNLpackGeneratorDiffResultDetailBatchProcess -verbose=l1 -sourceleft=l2 -sourceright=l3 -targetdiff=l4 -reportequal=l5");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourceleft");
        System.out.println("      [̖͂|󌋉ʃO()B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -sourceright");
        System.out.println("      [̖͂|󌋉ʃO(E)B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdiff");
        System.out.println("      [o̖͂|󌋉ʃOt@CB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -reportequal");
        System.out.println("      [vs񍐂邩ǂBʏ ͕svƍlĂ܂B]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoNLpackGeneratorDiffResultDetailProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourceleft() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourceleft]ɒlݒ肳Ă܂B");
        }
        if (input.getSourceright() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourceright]ɒlݒ肳Ă܂B");
        }
        if (input.getTargetdiff() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorDiffResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdiff]ɒlݒ肳Ă܂B");
        }
    }
}
