/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.xliff.util.task;

import java.io.IOException;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilMergeProcessInput;

/**
 * ob`NX [BlancoXliffUtilMergeBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.xliff.util.task.BlancoXliffUtilMergeBatchProcess -help
 * </code>
 */
public class BlancoXliffUtilMergeBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoXliffUtilMergeBatchProcess batchProcess = new BlancoXliffUtilMergeBatchProcess();

        // ob`̈B
        final BlancoXliffUtilMergeProcessInput input = new BlancoXliffUtilMergeProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldTargetdirProcessed = false;
        boolean isFieldToolidProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
                isFieldTargetdirProcessed = true;
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
            } else if (arg.startsWith("-sourcefile=")) {
                input.setSourcefile(arg.substring(12));
            } else if (arg.startsWith("-toolid=")) {
                input.setToolid(arg.substring(8));
                isFieldToolidProcessed = true;
            } else if (arg.startsWith("-settarget=")) {
                input.setSettarget(Boolean.valueOf(arg.substring(11)).booleanValue());
            } else if (arg.startsWith("-settargetoverwrite=")) {
                input.setSettargetoverwrite(Boolean.valueOf(arg.substring(20)).booleanValue());
            } else if (arg.startsWith("-setalttrans=")) {
                input.setSetalttrans(Boolean.valueOf(arg.substring(13)).booleanValue());
            } else if (arg.startsWith("-copyalttrans=")) {
                input.setCopyalttrans(Boolean.valueOf(arg.substring(14)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoXliffUtilMergeBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldTargetdirProcessed == false) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldToolidProcessed == false) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[toolid]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoXliffUtilMergeProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoXliffUtilMergeProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilMergeProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoXliffUtilMergeProcess process = new BlancoXliffUtilMergeProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoXliffUtilMergeProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoXliffUtilMergeBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoXliffUtilMergeBatchProcess: Usage:");
        System.out.println("  java blanco.xliff.util.task.BlancoXliffUtilMergeBatchProcess -verbose=l1 -targetdir=l2 -sourcedir=l3 -sourcefile=l4 -toolid=l5 -settarget=l6 -settargetoverwrite=l7 -setalttrans=l8 -copyalttrans=l9");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -targetdir");
        System.out.println("      [o͑Ώۂ XLIFF (*.xlf) t@C()܂܂fBNgBɏ܂BύX  XLIFF ݂̂Ɏ{܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -sourcedir");
        System.out.println("      [͑Ώۂ XLIFF (*.xlf) t@C(E)܂܂fBNgBӂɑ݂Ȃ trans-unit (Babel URI) ͖܂BsourcefileƔrpB]");
        System.out.println("      ^[]");
        System.out.println("    -sourcefile");
        System.out.println("      [͑Ώۂ XLIFF (*.xlf) t@C(E)Bӂɑ݂Ȃ trans-unit (Babel URI) ͖܂BsourcedirƔrpB]");
        System.out.println("      ^[]");
        System.out.println("    -toolid");
        System.out.println("      [}[W{ۂɗp tool-idBnlpack  pleiades Ȃǂw肵܂Balt-trans ŗp܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -settarget");
        System.out.println("      [trans-unit  target ɂāAlZbg邩ǂBȂA{I source 񂪈v邱ƂOƂȂ܂B]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -settargetoverwrite");
        System.out.println("      [trans-unit  target ɂāA݂̗Lɂ炸lZbg邩ǂB|󕨂̗D揇ʂ݂ꍇ̃}[WɂĂ̂݃Zbg܂B]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -setalttrans");
        System.out.println("      [Zbg target ̓e alt-trans ɃZbg邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -copyalttrans");
        System.out.println("      [͌ alt-trans  o͐ alt-trans ɃZbg邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoXliffUtilMergeProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getTargetdir() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilMergeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
        }
        if (input.getToolid() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilMergeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[toolid]ɒlݒ肳Ă܂B");
        }
    }
}
