package blanco.xliff.util.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import blanco.commons.util.BlancoStringUtil;
import blanco.properties.BlancoPropertiesUtil;
import blanco.xliff.BlancoXliffParser;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.util.BlancoXliffUtilConstants;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilMergeProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilMergeProcessImpl implements
        BlancoXliffUtilMergeProcess {
    private BlancoXliffUtilMergeProcessInput fInput = null;

    private String fPrevBundleSymbolicName = null;

    private BlancoXliff fXliffTarget = null;

    private int fUpdateXliffCount = 0;

    private int fSkipXliffCount = 0;

    private int fTotalUnitCount = 0;

    private int fMissUnitCount = 0;

    public int execute(final BlancoXliffUtilMergeProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;
        fPrevBundleSymbolicName = null;

        final boolean isSourceDir = BlancoStringUtil.null2Blank(
                fInput.getSourcedir()).length() > 0;
        final boolean isSourceFile = BlancoStringUtil.null2Blank(
                fInput.getSourcefile()).length() > 0;
        if (isSourceDir == false && isSourceFile == false) {
            throw new IllegalArgumentException(
                    "sourcedir ܂ sourcefile ̂ꂩ͎w肵ĂB");
        }
        if (isSourceDir && isSourceFile) {
            throw new IllegalArgumentException(
                    "sourcedir ܂ sourcefile ̂ꂩ̂ݎw肵ĂB");
        }

        final File targetDir = new File(fInput.getTargetdir());
        if (targetDir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ targetdir["
                    + targetDir.getAbsolutePath() + "]݂͑܂B");
        }
        if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ targetdir["
                    + targetDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        if (isSourceDir) {
            final File sourceDir = new File(fInput.getSourcedir());
            if (sourceDir.exists() == false) {
                throw new IllegalArgumentException("w肳ꂽ sourcedir["
                        + sourceDir.getAbsolutePath() + "]݂͑܂B");
            }
            if (sourceDir.isDirectory() == false) {
                throw new IllegalArgumentException("w肳ꂽ sourcedir["
                        + sourceDir.getAbsolutePath() + "]̓fBNgł͂܂B");
            }

            if (sourceDir.getCanonicalPath().equals(
                    targetDir.getCanonicalPath())) {
                throw new IllegalArgumentException("sourcedir["
                        + sourceDir.getAbsolutePath() + "]  targetdir["
                        + targetDir.getAbsolutePath() + "] Ƃ͓fBNgłB");
            }
        } else {
            // t@C݃`FbNB
        }

        if (fInput.getSettarget() == false && fInput.getSettargetoverwrite()) {
            throw new IllegalArgumentException(
                    "settargetoverwrite 𗘗pꍇɂ settarget  true ɐݒ肵ĂB");
        }

        if (fInput.getSettarget() == false && fInput.getSetalttrans() == false) {
            throw new IllegalArgumentException(
                    "settarget ܂ setalttrans ̂ꂩ true ɐݒ肵ĂB");
        }

        if (isSourceDir) {
            final File[] targetFiles = targetDir.listFiles();
            if (targetFiles == null) {
                return 0;
            }
            for (int index = 0; index < targetFiles.length; index++) {
                if (targetFiles[index].isFile() == false) {
                    continue;
                }
                if (targetFiles[index].getName().endsWith(".xlf")) {
                    processXliffWithDir(targetFiles[index], new File(fInput
                            .getSourcedir()));
                }
            }
        } else {
            // ͂̓t@CB
            processXliffWithFile(targetDir, new File(fInput.getSourcefile()));
        }

        System.out.println("xliff: merge: update=" + fUpdateXliffCount
                + ", skip=" + fSkipXliffCount);
        System.out.println("- trans-unit (total=" + fTotalUnitCount + ", miss="
                + fMissUnitCount + ")");

        return 0;
    }

    /**
     * fBNgɂXLIFF̍XVB
     * 
     * @param fileTarget
     * @param sourceDir
     * @throws IOException
     */
    private void processXliffWithDir(final File fileTarget, final File sourceDir)
            throws IOException {
        final File fileSource = new File(sourceDir.getAbsoluteFile() + "/"
                + fileTarget.getName());
        if (fileSource.exists() == false) {
            //  XLIFF ݂͑܂B
            return;
        }

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());
        final BlancoXliff xliffTarget = BlancoXliffUtil.getXliffInstance(
                fileTarget.getParentFile(), bundleSymbolicName);
        final BlancoXliff xliffSource = BlancoXliffUtil.getXliffInstance(
                fileSource.getParentFile(), bundleSymbolicName);
        final Map<String, BlancoXliffTransUnit> mapSource = new HashMap<String, BlancoXliffTransUnit>();
        buildMap(xliffSource, mapSource);

        for (int indexFile = 0; indexFile < xliffTarget.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffTarget
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit targetUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                final BlancoXliffTransUnit sourceUnit = mapSource
                        .get(targetUnit.getId());
                if (sourceUnit == null) {
                    // ł
                    continue;
                }

                //  trans-unit }[W܂B
                mergeTransUnit(targetUnit, sourceUnit);
            }
        }

        // }[Wʂۑ܂B
        switch (BlancoXliffUtil.saveXliffInstance(xliffTarget, fileTarget
                .getParentFile(), bundleSymbolicName)) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: create: "
                        + bundleSymbolicName);
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: update: "
                        + bundleSymbolicName);
            }
            fUpdateXliffCount++;
            break;
        case 0:
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: skip  : "
                        + bundleSymbolicName);
            }
            fSkipXliffCount++;
            break;
        }
    }

    /**
     * t@CɂXLIFF̍XVB
     * 
     * @param dirTarget
     * @param sourceFile
     * @throws IOException
     */
    private void processXliffWithFile(final File dirTarget,
            final File sourceFile) throws IOException {
        final BlancoXliff xliffSource = new BlancoXliffParser()
                .parse(sourceFile);

        for (int indexFile = 0; indexFile < xliffSource.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffSource
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit sourceUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);

                final String bundleSymbolicName = BlancoPropertiesUtil
                        .getHostFromBabelURI(sourceUnit.getId());

                // XLIFF[h̃LbVB
                if (bundleSymbolicName.equals(fPrevBundleSymbolicName) == false) {
                    fXliffTarget = BlancoXliffUtil.getXliffInstance(dirTarget,
                            bundleSymbolicName);
                }

                boolean isUpdated = false;

                final Map<String, BlancoXliffTransUnit> mapTarget = new HashMap<String, BlancoXliffTransUnit>();
                buildMap(fXliffTarget, mapTarget);

                final BlancoXliffTransUnit targetTransUnit = mapTarget
                        .get(sourceUnit.getId());
                if (targetTransUnit != null) {
                    //  trans-unit }[W܂B
                    isUpdated = mergeTransUnit(targetTransUnit, sourceUnit);
                } else {
                    fMissUnitCount++;
                    System.out.println("trace: }[WɊY Babel URI ܂B["
                            + sourceUnit.getId() + "]");
                }

                if (isUpdated) {
                    // }[Wʂۑ܂B
                    switch (BlancoXliffUtil.saveXliffInstance(fXliffTarget,
                            dirTarget, bundleSymbolicName)) {
                    case 1:
                        // {IɁAɂ͓Ȃ݁B
                        if (fInput.getVerbose()) {
                            System.out.println("xliff: merge: create: "
                                    + bundleSymbolicName);
                        }
                        break;
                    case 2:
                        if (fInput.getVerbose()) {
                            System.out.println("xliff: merge: update: "
                                    + bundleSymbolicName);
                        }
                        fUpdateXliffCount++;
                        break;
                    case 0:
                        if (fInput.getVerbose()) {
                            System.out.println("xliff: merge: skip  : "
                                    + bundleSymbolicName);
                        }
                        fSkipXliffCount++;
                        break;
                    }
                }
            }
        }
    }

    private boolean mergeTransUnit(final BlancoXliffTransUnit targetUnit,
            final BlancoXliffTransUnit sourceUnit) {
        boolean isUpdate = false;

        fTotalUnitCount++;

        // state ΁A]
        if (targetUnit.getTarget() != null
                && sourceUnit.getTarget() != null
                && BlancoStringUtil.null2Blank(
                        sourceUnit.getTarget().getState()).length() > 0) {
            if (BlancoStringUtil.null2Blank(targetUnit.getTarget().getState())
                    .length() > 0) {
                //  state ݂ꍇ
                if (fInput.getSettargetoverwrite()) {
                    targetUnit.getTarget().setState(
                            sourceUnit.getTarget().getState());
                }
            } else {
                //  state ݂Ȃꍇ
                targetUnit.getTarget().setState(
                        sourceUnit.getTarget().getState());
            }
        }

        // note΁A]: Jn
        for (int indexNote = 0; indexNote < sourceUnit.getNoteList().size(); indexNote++) {
            final BlancoXliffNote note = (BlancoXliffNote) sourceUnit
                    .getNoteList().get(indexNote);
            if (BlancoStringUtil.null2Blank(note.getFrom()).equals(
                    "blanconlpackgenerator.version")
                    || BlancoStringUtil.null2Blank(note.getFrom()).equals(
                            "blanconlpackgenerator.action")) {
                continue;
            }

            // e note  targetɑ݂邩ǂ`FbNB
            boolean isEqualExist = false;
            for (int indexTargetNote = 0; indexTargetNote < targetUnit
                    .getNoteList().size(); indexTargetNote++) {
                final BlancoXliffNote targetNote = (BlancoXliffNote) targetUnit
                        .getNoteList().get(indexTargetNote);
                if (BlancoStringUtil.null2Blank(note.getFrom()).equals(
                        BlancoStringUtil.null2Blank(targetNote.getFrom())) == false) {
                    // from قȂ̂́AႤ̂ƔfB
                    continue;
                }
                if (BlancoStringUtil.null2Blank(note.getText()).equals(
                        BlancoStringUtil.null2Blank(targetNote.getText())) == false) {
                    // eLXgeقȂ΁AႤ̂ƔfB
                    continue;
                }
                // ɓo^܂B
                isEqualExist = true;
            }

            if (isEqualExist == false) {
                targetUnit.getNoteList().add(note);
            }
        }
        // note΁A]: I

        if (targetUnit.getTranslate() == false) {
            // |svB
            // TODO ӁFł ^[Qbg translate="no" Ə͓]܂B
            return false;
        }

        if (sourceUnit.getTranslate() == false) {
            // KvɉāAsource  translate="no" ]܂B
            if (BlancoStringUtil.null2Blank(sourceUnit.getSource()).equals(
                    BlancoStringUtil.null2Blank(targetUnit.getSource()))) {
                // translate="no"  source \[XE^[Qbgňvꍇɂ͖|ΏۊOB
                targetUnit.setTranslate(false);
                // ύX{I
                return true;
            } else {
                System.out.println("trace: ςĂ܂[" + sourceUnit.getId()
                        + "]");
            }
        }

        // ȊO͖|ɂĂ̍lKv trans-unit

        if (BlancoStringUtil.null2Blank(sourceUnit.getSource()).length() == 0
                || sourceUnit.getTarget() == null
                || BlancoStringUtil.null2Blank(
                        sourceUnit.getTarget().getTarget()).length() == 0) {
            // source ̏ꍇȂǂɂ͏łȂ̂ŁAXLbv܂B
            return false;
        }

        // ܂ł珈ρI
        isUpdate = true;

        if (fInput.getCopyalttrans()) {
            // alt-transRs[܂B
            copyAltTrans(sourceUnit, targetUnit);
        }

        if (fInput.getSetalttrans()) {
            // alt-transZbg܂B
            setAltTrans(fInput.getToolid(), targetUnit, sourceUnit.getSource(),
                    sourceUnit.getTarget().getTarget());
        }

        if (fInput.getSettarget()) {
            // {ƂȂ|{܂B
            translate(targetUnit, sourceUnit);
        }

        return isUpdate;
    }

    /**
     * |{܂B
     * 
     * @param targetUnit
     * @param sourceUnit
     */
    private void translate(final BlancoXliffTransUnit targetUnit,
            final BlancoXliffTransUnit sourceUnit) {
        final String sourceSourceText = BlancoStringUtil.null2Blank(sourceUnit
                .getSource());
        String sourceTargetText = "";
        if (sourceUnit.getTarget() != null) {
            sourceTargetText = BlancoStringUtil.null2Blank(sourceUnit
                    .getTarget().getTarget());
        }
        final String targetSourceText = BlancoStringUtil.null2Blank(targetUnit
                .getSource());
        String targetTargetText = "";
        if (targetUnit.getTarget() != null) {
            targetTargetText = BlancoStringUtil.null2Blank(targetUnit
                    .getTarget().getTarget());
        }

        // Ώtrans-unit source, target ǂ̂炢قȂ̂`FbNB
        final boolean isSourceEqual = sourceSourceText.equals(targetSourceText);
        final boolean isTargetEqual = sourceTargetText.equals(targetTargetText);
        if (isSourceEqual && isTargetEqual) {
            // equal
            // |󌳁A|̗vԁB
        } else if (isSourceEqual && !isTargetEqual) {
            // change.o
            // |݈̂قȂԁB

            if (fInput.getSettargetoverwrite()
                    || targetUnit.getTarget() == null) {
                // ㏑[h ܂ target ꍇB
                // ͂ target ̂܂܊pB
                targetUnit.setTarget(sourceUnit.getTarget());
            }
        } else if (!isSourceEqual && isTargetEqual) {
            // change.i
            // |󌳂݈̂قȂԁB
        } else {
            // change.io
            // |󌳁A|̗قȂԁB
        }
    }

    private void buildMap(final BlancoXliff xliffInput,
            final Map<String, BlancoXliffTransUnit> mapOutput) {
        for (int indexFile = 0; indexFile < xliffInput.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffInput
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit unit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                mapOutput.put(unit.getId(), unit);
            }
        }
    }

    /**
     * alt-trans Zbg܂B
     * 
     * @param transUnit
     * @param targetString
     * @return
     */
    private boolean setAltTrans(final String tool_id,
            final BlancoXliffTransUnit transUnit, final String sourceString,
            final String targetString) {
        boolean isModified = false;

        if (BlancoXliffUtil.getAltTrans(transUnit, tool_id, BlancoStringUtil
                .null2Blank(sourceString), BlancoStringUtil
                .null2Blank(targetString)) == null) {
            isModified = true;
            final BlancoXliffAltTrans altTransNew = new BlancoXliffAltTrans();
            transUnit.getAltTransList().add(altTransNew);
            altTransNew.setToolId(tool_id);
            altTransNew.setSource(sourceString);
            final BlancoXliffTarget target = new BlancoXliffTarget();
            altTransNew.setTarget(target);
            target.setTarget(targetString);

            final BlancoXliffNote note = new BlancoXliffNote();
            note.setFrom(BlancoXliffUtilConstants.PRODUCT_NAME_LOWER
                    + ".version");
            note.setText(BlancoXliffUtilConstants.VERSION);
            altTransNew.getNoteList().add(note);
        }

        return isModified;
    }

    /**
     * alt-trans Rs[܂B
     * 
     * @param transUnit
     * @param targetString
     * @return
     */
    private boolean copyAltTrans(final BlancoXliffTransUnit sourceTransUnit,
            final BlancoXliffTransUnit targetTransUnit) {
        boolean isModified = false;

        for (int sourceIndex = 0; sourceIndex < sourceTransUnit
                .getAltTransList().size(); sourceIndex++) {
            final BlancoXliffAltTrans altTrans = (BlancoXliffAltTrans) sourceTransUnit
                    .getAltTransList().get(sourceIndex);

            // d͋Cɂ Ƃ肠Zbg܂B
            targetTransUnit.getAltTransList().add(altTrans);
        }

        return isModified;
    }
}
